/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.transforms.empty;

import java.net.URI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.ResourceType;
import org.entrystore.impl.RepositoryProperties;
import org.entrystore.repository.util.NS;
import org.entrystore.transforms.Pipeline;
import org.entrystore.transforms.Transform;
import org.entrystore.transforms.TransformParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformParameters(type="empty", extensions={})
public class EmptyTransform
extends Transform {
    private static Logger log = LoggerFactory.getLogger(EmptyTransform.class);

    public Object transform(Pipeline pipeline, Entry sourceEntry) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        String pipelineURI = pipeline.getEntry().getEntryURI().toString();
        Entry newEntry = pipeline.getEntry().getContext().createResource(null, GraphType.PipelineResult, ResourceType.InformationResource, null);
        newEntry.setStatus(URI.create(RepositoryProperties.Pending.toString()));
        String newEntryURI = newEntry.getEntryURI().toString();
        Model newEntryGraph = newEntry.getGraph();
        newEntryGraph.add((Resource)vf.createIRI(newEntryURI), RepositoryProperties.pipeline, (Value)vf.createIRI(pipelineURI), new Resource[0]);
        if (sourceEntry != null) {
            String sourceURI = sourceEntry.getEntryURI().toString();
            newEntryGraph.add((Resource)vf.createIRI(newEntryURI), RepositoryProperties.pipelineData, (Value)vf.createIRI(sourceURI), new Resource[0]);
        }
        newEntry.setGraph(newEntryGraph);
        Model pipelineMd = pipeline.getEntry().getMetadataGraph();
        LinkedHashModel pipelineResultMd = new LinkedHashModel();
        for (Statement titleStmnt : pipelineMd.filter(null, vf.createIRI(NS.dcterms + "title"), null, new Resource[0])) {
            pipelineResultMd.add((Resource)vf.createIRI(newEntry.getResourceURI().toString()), titleStmnt.getPredicate(), titleStmnt.getObject(), new Resource[0]);
        }
        for (Statement tagStmnt : pipelineMd.filter(null, vf.createIRI(NS.dcterms + "subject"), null, new Resource[0])) {
            pipelineResultMd.add((Resource)vf.createIRI(newEntry.getResourceURI().toString()), tagStmnt.getPredicate(), tagStmnt.getObject(), new Resource[0]);
        }
        if (!pipelineResultMd.isEmpty()) {
            newEntry.getLocalMetadata().setGraph((Model)pipelineResultMd);
        }
        return newEntry;
    }
}

