/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.transforms.rowstore;

import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.entrystore.Data;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.ResourceType;
import org.entrystore.config.Config;
import org.entrystore.impl.RepositoryProperties;
import org.entrystore.repository.config.Settings;
import org.entrystore.transforms.Pipeline;
import org.entrystore.transforms.Transform;
import org.entrystore.transforms.TransformParameters;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformParameters(type="rowstore", extensions={"csv"})
public class CSV2RowStoreTransform
extends Transform {
    private static Logger log = LoggerFactory.getLogger(CSV2RowStoreTransform.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object transform(Pipeline pipeline, Entry sourceEntry) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        Config conf = pipeline.getEntry().getRepositoryManager().getConfiguration();
        String action = this.getArguments().getOrDefault("action", "create").toLowerCase();
        String pipelineURI = pipeline.getEntry().getEntryURI().toString();
        InputStream data = null;
        String sourceURI = null;
        if (sourceEntry == null && !"setalias".equalsIgnoreCase(action)) {
            throw new IllegalStateException("CSV2RowStoreTransform requires a sourceEntry for action " + action);
        }
        if (!"setalias".equalsIgnoreCase(action)) {
            data = ((Data)sourceEntry.getResource()).getData();
            sourceURI = sourceEntry.getEntryURI().toString();
        }
        Entry result = null;
        Response httpResponse = null;
        try {
            if ("create".equalsIgnoreCase(action)) {
                Object datasetsUrl = conf.getString(Settings.ROWSTORE_URL);
                if (!((String)datasetsUrl).endsWith("/")) {
                    datasetsUrl = (String)datasetsUrl + "/";
                }
                if (!Status.SUCCESS_ACCEPTED.equals((Object)(httpResponse = this.sendData(Method.POST, (String)(datasetsUrl = (String)datasetsUrl + "datasets"), data, MediaType.TEXT_CSV)).getStatus())) {
                    log.error("Dataset could not be created in RowStore");
                    Object var12_13 = null;
                    return var12_13;
                }
                String datasetURL = httpResponse.getLocationRef().toString();
                String datasetInfoURL = datasetURL + "/info";
                Entry newEntry = pipeline.getEntry().getContext().createReference(null, URI.create(datasetURL), URI.create(datasetInfoURL), null);
                newEntry.setGraphType(GraphType.PipelineResult);
                newEntry.setResourceType(ResourceType.InformationResource);
                String newEntryURI = newEntry.getEntryURI().toString();
                Model newEntryGraph = newEntry.getGraph();
                newEntryGraph.add((Resource)vf.createIRI(newEntryURI), RepositoryProperties.pipeline, (Value)vf.createIRI(pipelineURI), new Resource[0]);
                newEntryGraph.add((Resource)vf.createIRI(newEntryURI), RepositoryProperties.pipelineData, (Value)vf.createIRI(sourceURI), new Resource[0]);
                newEntry.setGraph(newEntryGraph);
                result = newEntry;
            } else if ("replace".equalsIgnoreCase(action) || "append".equalsIgnoreCase(action) || "setalias".equalsIgnoreCase(action)) {
                String datasetAliasURL;
                String datasetURL = (String)this.getArguments().get("dataseturl");
                if (datasetURL == null) {
                    throw new IllegalStateException("CSV2RowStoreTransform action " + action + " requires a datasetURL parameter");
                }
                Set datasetEntries = pipeline.getEntry().getContext().getByResourceURI(URI.create(datasetURL));
                Entry datasetEntry = null;
                if (datasetEntries.size() != 1) {
                    throw new IllegalStateException("Found multiple result entries for same dataset, aborting update");
                }
                datasetEntry = (Entry)datasetEntries.iterator().next();
                LinkedHashModel datasetEntryGraph = new LinkedHashModel(datasetEntry.getGraph());
                if ("replace".equalsIgnoreCase(action)) {
                    httpResponse = this.sendData(Method.PUT, datasetURL, data, MediaType.TEXT_CSV);
                    datasetEntryGraph.remove(null, RepositoryProperties.pipelineData, null, new Resource[0]);
                    datasetEntryGraph.add((Resource)vf.createIRI(datasetEntry.getEntryURI().toString()), RepositoryProperties.pipelineData, (Value)vf.createIRI(sourceURI), new Resource[0]);
                    datasetEntry.setGraph((Model)datasetEntryGraph);
                } else if ("append".equalsIgnoreCase(action)) {
                    httpResponse = this.sendData(Method.POST, datasetURL, data, MediaType.TEXT_CSV);
                    datasetEntryGraph.add((Resource)vf.createIRI(datasetEntry.getEntryURI().toString()), RepositoryProperties.pipelineData, (Value)vf.createIRI(sourceURI), new Resource[0]);
                    datasetEntry.setGraph((Model)datasetEntryGraph);
                } else if ("setalias".equalsIgnoreCase(action)) {
                    datasetAliasURL = datasetURL + (datasetURL.endsWith("/") ? "" : "/") + "aliases";
                    String alias = (String)this.getArguments().get("alias");
                    if (alias == null || alias.length() == 0) {
                        httpResponse = this.sendData(Method.DELETE, datasetAliasURL, null, null);
                    } else {
                        String jsonArray = "[\"" + alias + "\"]";
                        httpResponse = this.sendData(Method.PUT, datasetAliasURL, IOUtils.toInputStream((String)jsonArray), MediaType.APPLICATION_JSON);
                    }
                }
                if (!Status.isSuccess((int)httpResponse.getStatus().getCode())) {
                    log.error("Dataset could not be modified");
                    datasetAliasURL = null;
                    return datasetAliasURL;
                }
                Set resultEntries = pipeline.getEntry().getContext().getByResourceURI(URI.create(datasetURL));
                if (resultEntries.size() == 0) {
                    log.warn("No existing result entry found after updating RowStore dataset");
                } else if (resultEntries.size() > 1) {
                    log.warn("Multiple result entries found after updating RowStore dataset, only returning one");
                }
                result = (Entry)resultEntries.iterator().next();
            } else {
                log.warn("Unable to process unknown action " + action);
            }
        }
        finally {
            if (httpResponse != null) {
                httpResponse.release();
            }
        }
        return result;
    }

    private Response sendData(Method method, String url, InputStream data, MediaType mediaType) {
        if (method == null || url == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        Client client = new Client(Protocol.HTTP);
        client.setContext(new Context());
        client.getContext().getParameters().add("connectTimeout", "10000");
        client.getContext().getParameters().add("readTimeout", "10000");
        client.getContext().getParameters().set("socketTimeout", "10000");
        client.getContext().getParameters().set("socketConnectTimeoutMs", "10000");
        log.info("Initialized HTTP client for RowStore Transform");
        Request request = new Request(method, url);
        if (data != null) {
            request.setEntity((Representation)new InputRepresentation(data, mediaType));
        }
        return client.handle(request);
    }
}

