/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.auth;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.PrincipalManager;
import org.entrystore.User;
import org.entrystore.config.Config;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.security.Password;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.Status;
import org.restlet.security.Verifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicVerifier
implements Verifier {
    private static final Logger log = LoggerFactory.getLogger(BasicVerifier.class);
    private final PrincipalManager pm;
    private final Map<String, Long> loginCache = new ConcurrentHashMap<String, Long>();
    private final List<String> passwordLoginWhitelist;

    public BasicVerifier(PrincipalManager pm, Config config) {
        this.pm = pm;
        this.passwordLoginWhitelist = "whitelist".equalsIgnoreCase(config.getString(Settings.AUTH_PASSWORD)) ? config.getStringList(Settings.AUTH_PASSWORD_WHITELIST, new ArrayList()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSaltedHashedSecret(PrincipalManager pm, String identifier) {
        URI authUser = pm.getAuthenticatedUserURI();
        try {
            pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
            Entry userEntry = pm.getPrincipalEntry(identifier);
            if (userEntry != null && GraphType.User.equals((Object)userEntry.getGraphType())) {
                User user = (User)userEntry.getResource();
                if (user.getSaltedHashedSecret() != null) {
                    String string = user.getSaltedHashedSecret();
                    return string;
                }
                log.error("No secret found for principal: " + identifier);
            }
        }
        finally {
            pm.setAuthenticatedUserURI(authUser);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean userExists(PrincipalManager pm, String userName) {
        if (userName == null) {
            return false;
        }
        URI currentUser = pm.getAuthenticatedUserURI();
        try {
            pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
            Entry userEntry = pm.getPrincipalEntry(userName);
            if (userEntry != null) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            pm.setAuthenticatedUserURI(currentUser);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUserDisabled(PrincipalManager pm, String userName) {
        URI currentUser = pm.getAuthenticatedUserURI();
        try {
            pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
            Entry userEntry = pm.getPrincipalEntry(userName);
            if (userEntry != null) {
                boolean bl = ((User)userEntry.getResource()).isDisabled();
                return bl;
            }
        }
        finally {
            pm.setAuthenticatedUserURI(currentUser);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int verify(Request request, Response response) {
        URI userURI;
        block26: {
            boolean challenge;
            block25: {
                Entry userEntry;
                String secret;
                String identifier;
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            block16: {
                                                block17: {
                                                    int n;
                                                    URI authUser = this.pm.getAuthenticatedUserURI();
                                                    if (authUser != null && !this.pm.getGuestUser().getURI().equals(authUser)) {
                                                        return 4;
                                                    }
                                                    userURI = null;
                                                    challenge = !"false".equalsIgnoreCase(response.getRequest().getResourceRef().getQueryAsForm().getFirstValue("auth_challenge"));
                                                    try {
                                                        if (request.getChallengeResponse() != null || !"basic".equals(request.getResourceRef().getLastSegment())) break block16;
                                                        if (!challenge) break block17;
                                                        n = 0;
                                                    }
                                                    catch (Throwable throwable) {
                                                        this.pm.setAuthenticatedUserURI(userURI);
                                                        throw throwable;
                                                    }
                                                    this.pm.setAuthenticatedUserURI(userURI);
                                                    return n;
                                                }
                                                userURI = this.pm.getGuestUser().getURI();
                                                response.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
                                                int n = 4;
                                                this.pm.setAuthenticatedUserURI(userURI);
                                                return n;
                                            }
                                            identifier = null;
                                            secret = null;
                                            ChallengeResponse cr = request.getChallengeResponse();
                                            if (cr == null) {
                                                identifier = "_guest";
                                            } else {
                                                identifier = request.getChallengeResponse().getIdentifier();
                                                secret = String.valueOf(request.getChallengeResponse().getSecret());
                                            }
                                            this.pm.setAuthenticatedUserURI(this.pm.getAdminUser().getURI());
                                            if (identifier != null) break block18;
                                            int n = 0;
                                            this.pm.setAuthenticatedUserURI(userURI);
                                            return n;
                                        }
                                        if (!"_guest".equals(identifier)) break block19;
                                        userURI = this.pm.getGuestUser().getURI();
                                        int n = 4;
                                        this.pm.setAuthenticatedUserURI(userURI);
                                        return n;
                                    }
                                    if (secret != null) break block20;
                                    int n = 0;
                                    this.pm.setAuthenticatedUserURI(userURI);
                                    return n;
                                }
                                if (secret.length() <= 2048) break block21;
                                int n = 3;
                                this.pm.setAuthenticatedUserURI(userURI);
                                return n;
                            }
                            identifier = identifier.toLowerCase();
                            if (this.passwordLoginWhitelist == null || this.passwordLoginWhitelist.contains(identifier)) break block22;
                            response.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
                            int n = -1;
                            this.pm.setAuthenticatedUserURI(userURI);
                            return n;
                        }
                        userEntry = this.pm.getPrincipalEntry(identifier);
                        if (userEntry != null) break block23;
                        int n = 5;
                        this.pm.setAuthenticatedUserURI(userURI);
                        return n;
                    }
                    if (!this.isLoginCached(userEntry.getEntryURI().toString(), secret, 3600L)) break block24;
                    userURI = userEntry.getResourceURI();
                    int n = 4;
                    this.pm.setAuthenticatedUserURI(userURI);
                    return n;
                }
                if (BasicVerifier.isUserDisabled(this.pm, identifier) || !Password.check((String)secret, (String)BasicVerifier.getSaltedHashedSecret(this.pm, identifier))) break block25;
                userURI = userEntry.getResourceURI();
                this.addLoginToCache(userEntry.getEntryURI().toString(), secret);
                int n = 4;
                this.pm.setAuthenticatedUserURI(userURI);
                return n;
            }
            if (challenge) break block26;
            userURI = this.pm.getGuestUser().getURI();
            response.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            int n = 4;
            this.pm.setAuthenticatedUserURI(userURI);
            return n;
        }
        int n = -1;
        this.pm.setAuthenticatedUserURI(userURI);
        return n;
    }

    private boolean addLoginToCache(String user, String password) {
        String hash = Password.sha256((String)(user + password));
        if (hash != null) {
            this.loginCache.put(hash, new Date().getTime());
            return true;
        }
        return false;
    }

    private boolean isLoginCached(String user, String password, long seconds) {
        long expirationTime;
        String hash = Password.sha256((String)(user + password));
        if (hash == null || !this.loginCache.containsKey(hash)) {
            return false;
        }
        long loginTime = this.loginCache.get(hash);
        if (loginTime < (expirationTime = new Date().getTime() - seconds * 1000L)) {
            log.info("Login has expired for user " + user);
            this.loginCache.remove(hash);
            return false;
        }
        return true;
    }
}

