/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.auth;

import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;
import org.apache.commons.lang3.RandomStringUtils;
import org.entrystore.Entry;
import org.entrystore.PrincipalManager;
import org.entrystore.config.Config;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.rest.EntryStoreApplication;
import org.entrystore.rest.auth.CustomCookieSettings;
import org.entrystore.rest.auth.LoginTokenCache;
import org.entrystore.rest.auth.UserInfo;
import org.entrystore.rest.filter.CORSFilter;
import org.entrystore.rest.util.HttpUtil;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.security.Verifier;
import org.restlet.util.Series;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieVerifier
implements Verifier {
    private static final Logger log = LoggerFactory.getLogger(CookieVerifier.class);
    private static CustomCookieSettings cookieSettings;
    private final PrincipalManager pm;
    private final RepositoryManager rm;
    private final CORSFilter corsFilter;
    private final boolean configInvalidTokenError;
    private final LoginTokenCache loginTokenCache;

    public CookieVerifier(EntryStoreApplication app, RepositoryManager rm) {
        this(app, rm, null);
    }

    public CookieVerifier(EntryStoreApplication app, RepositoryManager rm, CORSFilter corsFilter) {
        this.rm = rm;
        this.pm = rm.getPrincipalManager();
        this.corsFilter = corsFilter;
        Config config = rm.getConfiguration();
        this.configInvalidTokenError = config.getBoolean(Settings.AUTH_COOKIE_INVALID_TOKEN_ERROR, true);
        this.loginTokenCache = app.getLoginTokenCache();
        if (cookieSettings == null) {
            CustomCookieSettings.SameSite sameSite = CustomCookieSettings.SameSite.Strict;
            try {
                Object sameSiteStr = config.getString(Settings.AUTH_COOKIE_SAMESITE, CustomCookieSettings.SameSite.Strict.name()).toLowerCase();
                if (((String)sameSiteStr).length() > 1) {
                    sameSiteStr = ((String)sameSiteStr).substring(0, 1).toUpperCase() + ((String)sameSiteStr).substring(1);
                }
                sameSite = CustomCookieSettings.SameSite.valueOf((String)sameSiteStr);
            }
            catch (IllegalArgumentException iae) {
                log.warn("Invalid value for setting " + Settings.AUTH_COOKIE_SAMESITE + ": " + iae.getMessage());
            }
            cookieSettings = new CustomCookieSettings(config.getBoolean(Settings.AUTH_COOKIE_SECURE, true), config.getBoolean(Settings.AUTH_COOKIE_HTTPONLY, true), sameSite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int verify(Request request, Response response) {
        URI userURI;
        block10: {
            block9: {
                int n;
                URI authUser = this.pm.getAuthenticatedUserURI();
                if (authUser != null && !this.pm.getGuestUser().getURI().equals(authUser)) {
                    return 4;
                }
                userURI = null;
                try {
                    this.pm.setAuthenticatedUserURI(this.pm.getAdminUser().getURI());
                    String authToken = CookieVerifier.getAuthToken(request);
                    if (authToken == null) break block9;
                    UserInfo ui = this.loginTokenCache.registerUserInteraction(authToken, request);
                    if (ui != null) {
                        String userName = ui.getUserName();
                        Entry userEntry = this.pm.getPrincipalEntry(userName);
                        if (userEntry != null) {
                            userURI = userEntry.getResourceURI();
                        } else {
                            log.error("Auth token maps to non-existing user, removing token");
                            this.loginTokenCache.removeToken(authToken);
                            CookieVerifier.cleanCookies(this.rm, "auth_token", request, response);
                        }
                        break block9;
                    }
                    log.debug("Auth token not found in token cache");
                    CookieVerifier.cleanCookies(this.rm, "auth_token", request, response);
                    if (this.corsFilter != null) {
                        this.corsFilter.addCorsHeader(request, response);
                    }
                    if (!this.configInvalidTokenError) break block9;
                    n = -1;
                }
                catch (Throwable throwable) {
                    this.pm.setAuthenticatedUserURI(userURI);
                    throw throwable;
                }
                this.pm.setAuthenticatedUserURI(userURI);
                return n;
            }
            if (userURI != null) break block10;
            userURI = this.pm.getGuestUser().getURI();
            int n = 4;
            this.pm.setAuthenticatedUserURI(userURI);
            return n;
        }
        int n = 4;
        this.pm.setAuthenticatedUserURI(userURI);
        return n;
    }

    public static void cleanCookies(RepositoryManager rm, String cookieName, Request request, Response response) {
        response.getCookieSettings().removeAll(cookieName);
        Series cookies = request.getCookies();
        for (Cookie c : cookies) {
            if (!c.getName().equals(cookieName)) continue;
            Object value = c.getValue();
            value = (String)value + "; Max-Age=0; ";
            value = (String)value + cookieSettings.toString();
            CookieSetting cs = new CookieSetting(c.getVersion(), c.getName(), (String)value, CookieVerifier.getCookiePath(rm), null);
            cs.setMaxAge(0);
            response.getCookieSettings().add((Object)cs);
        }
    }

    public void createAuthToken(String userName, String maxAgeStr, Request request, Response response) {
        Object token = RandomStringUtils.random((int)128, (boolean)true, (boolean)true);
        Config config = this.rm.getConfiguration();
        int maxAge = this.loginTokenCache.MAX_AGE_IN_SECONDS;
        if (maxAgeStr != null) {
            try {
                maxAge = Math.min(maxAge, Integer.parseInt(maxAgeStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        UserInfo userInfo = new UserInfo(userName, LocalDateTime.now(), maxAge);
        userInfo.setLastAccessTime(userInfo.getLoginTime());
        userInfo.setLoginExpiration(userInfo.getLoginTime().plusSeconds(maxAge));
        userInfo.setLastUsedUserAgent(request.getClientInfo().getAgent());
        userInfo.setLastUsedIpAddress(HttpUtil.getClientIpAddress(request));
        this.loginTokenCache.putToken(token, userInfo);
        log.debug("User [{}] receives authentication token [{}]", (Object)userName, (Object)userInfo);
        if (maxAge >= 0) {
            if (this.loginTokenCache.isTokenUpdateExpiry()) {
                maxAge = (int)Duration.ofDays(365L).toSeconds();
            }
            token = (String)token + "; Max-Age=" + maxAge;
        }
        token = (String)token + "; " + String.valueOf(cookieSettings);
        CookieSetting tokenCookieSetting = new CookieSetting(0, "auth_token", (String)token);
        tokenCookieSetting.setPath(CookieVerifier.getCookiePath(this.rm));
        response.getCookieSettings().add((Object)tokenCookieSetting);
    }

    private static String getCookiePath(RepositoryManager rm) {
        String cookiePath = rm.getConfiguration().getString(Settings.AUTH_COOKIE_PATH, "auto");
        if ("auto".equalsIgnoreCase(cookiePath)) {
            return rm.getRepositoryURL().getPath();
        }
        return cookiePath;
    }

    public static String getAuthToken(Request request) {
        Cookie authTokenCookie = (Cookie)request.getCookies().getFirst("auth_token");
        if (authTokenCookie != null) {
            return authTokenCookie.getValue();
        }
        return null;
    }
}

