/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.auth;

public class CustomCookieSettings {
    private final boolean secure;
    private final boolean httpOnly;
    private final SameSite sameSite;
    private String stringValue;

    public CustomCookieSettings(boolean secure, boolean httpOnly, SameSite sameSite) {
        this.httpOnly = httpOnly;
        this.secure = secure;
        this.sameSite = sameSite;
        this.buildStringValue();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public SameSite getSameSite() {
        return this.sameSite;
    }

    public void buildStringValue() {
        StringBuilder sb = new StringBuilder();
        sb.append("SameSite=").append(this.sameSite.name());
        if (this.httpOnly) {
            sb.append("; HttpOnly");
        }
        if (this.secure || this.sameSite == SameSite.None) {
            sb.append("; Secure");
        }
        this.stringValue = sb.toString();
    }

    public String toString() {
        return this.stringValue;
    }

    public static enum SameSite {
        None,
        Lax,
        Strict;

    }
}

