/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.auth;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class TokenCache<K, V> {
    protected final Map<K, V> tokenCache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putToken(K token, V value) {
        Map<K, V> map = this.tokenCache;
        synchronized (map) {
            this.tokenCache.put(token, value);
        }
    }

    public V getTokenValue(K token) {
        this.cleanup();
        return this.tokenCache.get(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToken(K token) {
        this.cleanup();
        Map<K, V> map = this.tokenCache;
        synchronized (map) {
            this.tokenCache.remove(token);
        }
    }

    public boolean hasToken(K token) {
        this.cleanup();
        return this.tokenCache.containsKey(token);
    }

    abstract void cleanup();

    public int size() {
        this.cleanup();
        return this.tokenCache.size();
    }
}

