/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.filter;

import org.entrystore.repository.RepositoryManager;
import org.entrystore.rest.EntryStoreApplication;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.routing.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModificationLockOutFilter
extends Filter {
    private static Logger log = LoggerFactory.getLogger(ModificationLockOutFilter.class);
    private static RepositoryManager rm = null;

    protected int beforeHandle(Request request, Response response) {
        String path = request.getResourceRef().getRemainingPart();
        if (request.getMethod().equals((Object)Method.GET)) {
            return 0;
        }
        if (path != null && (path.startsWith("/auth/login") || path.startsWith("/auth/cookie") || path.startsWith("/auth/logout"))) {
            return 0;
        }
        if (rm == null) {
            rm = ((EntryStoreApplication)((Object)this.getContext().getAttributes().get(EntryStoreApplication.KEY))).getRM();
        }
        if (rm.hasModificationLockOut()) {
            String maintMsg = "The service is being maintained and does not accept modification requests right now, please check back later";
            response.setStatus(Status.SERVER_ERROR_SERVICE_UNAVAILABLE, maintMsg);
            return 2;
        }
        return 0;
    }
}

