/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.filter;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.search.Search;
import java.util.Arrays;
import java.util.List;
import org.entrystore.config.Config;
import org.entrystore.repository.config.Settings;
import org.entrystore.rest.EntryStoreApplication;
import org.entrystore.rest.micrometer.EntryStoreSimpleMeterRegistry;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.routing.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceMetricsFilter
extends Filter {
    private static final List<String> allowedTypes = List.of("resource", "entry", "metadata", "search");
    private static final Logger log = LoggerFactory.getLogger(PerformanceMetricsFilter.class);

    public PerformanceMetricsFilter() {
        EntryStoreSimpleMeterRegistry registry = new EntryStoreSimpleMeterRegistry();
        Metrics.addRegistry((MeterRegistry)registry);
    }

    protected int doHandle(Request request, Response response) {
        EntryStoreApplication app = this.getEntryStoreApplication();
        Config config = app.getRM().getConfiguration();
        boolean configEnableMetrics = config.getBoolean(Settings.METRICS, false);
        if (!configEnableMetrics) {
            return super.doHandle(request, response);
        }
        Timer.Sample sample = this.startTimer();
        int returnStatus = super.doHandle(request, response);
        this.stopTimerAndRegisterMetrics(request, response, sample);
        return returnStatus;
    }

    protected Timer.Sample startTimer() {
        Timer.Sample sample = Timer.start((MeterRegistry)Metrics.globalRegistry);
        return sample;
    }

    protected void stopTimerAndRegisterMetrics(Request request, Response response, Timer.Sample sample) {
        String type = this.extractType(request.getResourceRef().getPath());
        if (type == null) {
            return;
        }
        String method = request.getMethod().getName();
        int statusCode = response.getStatus().getCode();
        String mediaSubType = response.getEntity() != null ? response.getEntity().getMediaType().getSubType() : "none";
        String metricName = String.format("%s-%s-%s-%d", method, type, mediaSubType, statusCode);
        Search search = Metrics.globalRegistry.find(metricName);
        if (search == null) {
            Timer.builder((String)metricName).register((MeterRegistry)Metrics.globalRegistry);
        }
        sample.stop(Metrics.globalRegistry.timer(metricName, new String[0]));
    }

    private EntryStoreApplication getEntryStoreApplication() {
        EntryStoreApplication app = (EntryStoreApplication)this.getApplication();
        return app;
    }

    private String extractType(String requestPath) {
        Object[] split;
        String resourceType;
        if (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        String string = resourceType = (split = requestPath.split("/")).length == 1 ? split[0] : split[1];
        if (log.isDebugEnabled()) {
            log.debug("URI split into [{}] parts, choosing [{}] as type - {}", new Object[]{split.length, resourceType, Arrays.toString(split)});
        }
        return allowedTypes.contains(resourceType) ? resourceType : null;
    }
}

