/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.entrystore.Context;
import org.entrystore.ContextManager;
import org.entrystore.Entry;
import org.entrystore.PrincipalManager;
import org.entrystore.harvester.Harvester;
import org.entrystore.impl.RepositoryManagerImpl;
import org.entrystore.repository.config.Settings;
import org.entrystore.rest.EntryStoreApplication;
import org.entrystore.rest.auth.UserTempLockoutCache;
import org.entrystore.rest.util.CORSUtil;
import org.entrystore.rest.util.JSONErrorMessages;
import org.entrystore.rest.util.Util;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.ServerInfo;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Options;
import org.restlet.resource.ServerResource;
import org.restlet.util.Series;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResource
extends ServerResource {
    protected HashMap<String, String> parameters;
    MediaType format;
    protected String contextId;
    protected String entryId;
    protected Context context;
    protected Entry entry;
    private static final Logger log = LoggerFactory.getLogger(BaseResource.class);
    private static ServerInfo serverInfo;

    public void init(org.restlet.Context c, Request request, Response response) {
        String format;
        this.parameters = Util.parseRequest(request.getResourceRef().getRemainingPart());
        super.init(c, request, response);
        this.setServerInfo(this.getServerInfo());
        this.contextId = (String)request.getAttributes().get("context-id");
        if (this.getCM() != null && this.contextId != null) {
            if (this.getReservedNames().contains(this.contextId.toLowerCase())) {
                log.error("Context ID is a reserved term and must not be used: \"{}\". This error is likely to be caused by an error in the REST routing.", (Object)this.contextId);
            } else {
                this.context = this.getCM().getContext(this.contextId);
                if (this.context == null) {
                    log.info("There is no context {}", (Object)this.contextId);
                }
            }
        }
        this.entryId = (String)request.getAttributes().get("entry-id");
        if (this.context != null && this.entryId != null) {
            this.entry = this.context.get(this.entryId);
            if (this.entry == null) {
                log.info("There is no entry {} in context {}", (Object)this.entryId, (Object)this.contextId);
            }
        }
        if ((format = this.parameters.get("format")) != null) {
            format = format.replace(' ', '+');
            this.format = new MediaType(format);
        }
        Util.handleIfUnmodifiedSince(this.entry, this.getRequest());
    }

    public ServerInfo getServerInfo() {
        if (serverInfo == null) {
            ServerInfo si = super.getServerInfo();
            si.setAgent(this.getRM().getConfiguration().getString(Settings.HTTP_HEADER_SERVER, "EntryStore/" + EntryStoreApplication.getVersion()));
            serverInfo = si;
        }
        return serverInfo;
    }

    @Options
    public Representation preflightCORS() {
        if ("off".equalsIgnoreCase(this.getRM().getConfiguration().getString(Settings.CORS, "off"))) {
            log.info("Received CORS preflight request but CORS support is disabled");
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            return null;
        }
        this.getResponse().setEntity((Representation)new EmptyRepresentation());
        Series reqHeaders = (Series)this.getRequest().getAttributes().get("org.restlet.http.headers");
        String origin = reqHeaders.getFirstValue("Origin", true);
        if (origin != null) {
            CORSUtil cors = CORSUtil.getInstance(this.getRM().getConfiguration());
            if (!cors.isValidOrigin(origin)) {
                log.info("Received CORS preflight request with disallowed origin");
                return new EmptyRepresentation();
            }
            this.getResponse().setAccessControlAllowOrigin(origin);
            this.getResponse().setAccessControlAllowMethods((Set)Sets.newHashSet((Object[])new Method[]{Method.HEAD, Method.GET, Method.PUT, Method.POST, Method.DELETE, Method.OPTIONS}));
            this.getResponse().setAccessControlAllowCredentials(Boolean.valueOf(true));
            if (cors.getAllowedHeaders() != null) {
                this.getResponse().setAccessControlAllowHeaders(cors.getAllowedHeaders());
                this.getResponse().setAccessControlExposeHeaders(cors.getAllowedHeaders());
            }
            if (cors.getMaxAge() > -1) {
                this.getResponse().setAccessControlMaxAge(cors.getMaxAge());
            }
        }
        return this.getResponse().getEntity();
    }

    public ContextManager getCM() {
        return this.getEntryStoreApplication().getCM();
    }

    public PrincipalManager getPM() {
        return this.getEntryStoreApplication().getPM();
    }

    public RepositoryManagerImpl getRM() {
        return this.getEntryStoreApplication().getRM();
    }

    public ArrayList<Harvester> getHarvesters() {
        return this.getEntryStoreApplication().getHarvesters();
    }

    public Set<String> getReservedNames() {
        return this.getEntryStoreApplication().getReservedNames();
    }

    public UserTempLockoutCache getUserTempLockoutCache() {
        return this.getEntryStoreApplication().getUserTempLockoutCache();
    }

    public EntryStoreApplication getEntryStoreApplication() {
        return (EntryStoreApplication)((Object)this.getContext().getAttributes().get(EntryStoreApplication.KEY));
    }

    public Representation unauthorizedHEAD() {
        log.info("Unauthorized HEAD");
        this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
        return new EmptyRepresentation();
    }

    public Representation unauthorizedGET() {
        log.info("Unauthorized GET");
        this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        MediaType preferredMediaType = this.getRequest().getClientInfo().getPreferredMediaType(supportedMediaTypes);
        if (MediaType.APPLICATION_JSON.equals((Object)preferredMediaType)) {
            return new JsonRepresentation(JSONErrorMessages.unauthorizedGET);
        }
        return new EmptyRepresentation();
    }

    public void unauthorizedDELETE() {
        log.info("Unauthorized DELETE");
        this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
        if (MediaType.APPLICATION_JSON.equals((Object)this.getRequest().getEntity().getMediaType())) {
            this.getResponse().setEntity((Representation)new JsonRepresentation(JSONErrorMessages.unauthorizedDELETE));
        }
    }

    public void unauthorizedPOST() {
        log.info("Unauthorized POST");
        this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
        if (MediaType.APPLICATION_JSON.equals((Object)this.getRequest().getEntity().getMediaType())) {
            this.getResponse().setEntity((Representation)new JsonRepresentation(JSONErrorMessages.unauthorizedPOST));
        }
    }

    public void unauthorizedPUT() {
        log.info("Unauthorized PUT");
        this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
        if (MediaType.APPLICATION_JSON.equals((Object)this.getRequest().getEntity().getMediaType())) {
            this.getResponse().setEntity((Representation)new JsonRepresentation(JSONErrorMessages.unauthorizedPUT));
        }
    }

    protected Representation createEmptyRepresentationWithLastModified(Date modificationDate) {
        EmptyRepresentation result = new EmptyRepresentation();
        if (modificationDate != null) {
            result.setModificationDate(modificationDate);
            result.setTag(Util.createTag(modificationDate));
        } else {
            log.warn("Last-Modified header could not be set because the entry does not have a modification date: {}", (Object)this.entry.getEntryURI());
        }
        return result;
    }

    protected String getMandatoryParameter(String parameter) throws JsonErrorException {
        return Optional.ofNullable(this.parameters.get(parameter)).orElseThrow(() -> {
            String msg = "Mandatory parameter '" + parameter + "' is missing";
            log.info(msg);
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return new JsonErrorException(msg);
        });
    }

    protected String getOptionalParameter(String parameter, String defaultValue) {
        return this.parameters.getOrDefault(parameter, defaultValue);
    }

    protected Integer getOptionalParameterAsInteger(String parameter, int defaultValue) {
        String val = this.parameters.get(parameter);
        if (StringUtils.isEmpty((CharSequence)val)) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(val);
        }
        catch (NumberFormatException e) {
            log.info(e.getMessage());
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return defaultValue;
        }
    }

    protected Boolean getOptionalParameterAsBoolean(String parameter, boolean defaultValue) {
        String val = this.parameters.get(parameter);
        if (StringUtils.isEmpty((CharSequence)val)) {
            return defaultValue;
        }
        return Boolean.valueOf(val);
    }

    public static class JsonErrorException
    extends Throwable {
        private final JsonRepresentation representation;

        public JsonErrorException() {
            this.representation = new JsonRepresentation("{\"error\":\"An error has occurred\"}");
        }

        public JsonErrorException(String error) {
            this.representation = new JsonRepresentation("{\"error\":\"" + error + "\"}");
        }

        public JsonErrorException(JsonRepresentation jsonErrorRepresentation) {
            this.representation = jsonErrorRepresentation;
        }

        @Generated
        public JsonRepresentation getRepresentation() {
            return this.representation;
        }
    }
}

