/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.Group;
import org.entrystore.List;
import org.entrystore.PrincipalManager;
import org.entrystore.ResourceType;
import org.entrystore.User;
import org.entrystore.impl.ContextImpl;
import org.entrystore.impl.EntryNamesContext;
import org.entrystore.impl.RDFResource;
import org.entrystore.impl.StringResource;
import org.entrystore.repository.util.NS;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.JSONErrorMessages;
import org.entrystore.rest.util.RDFJSON;
import org.entrystore.rest.util.Util;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(ContextResource.class);
    private String requestText = null;

    public void doInit() {
        try {
            this.requestText = this.getRequest().getEntity().getText();
        }
        catch (IOException e) {
            this.requestText = null;
        }
    }

    @Get
    public Representation represent() throws ResourceException {
        JSONArray array;
        block6: {
            block7: {
                block5: {
                    if (this.context == null) {
                        log.debug("The given context id does not exist.");
                        this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                        return new JsonRepresentation(JSONErrorMessages.errorWrongContextIDmsg);
                    }
                    if (!this.getPM().isUserAdminOrAdminGroup(null)) {
                        return this.unauthorizedGET();
                    }
                    array = new JSONArray();
                    if (!this.parameters.containsKey("deleted")) break block5;
                    Set deletedURIs = this.context.getDeletedEntries().keySet();
                    for (URI uri : deletedURIs) {
                        String delURI = uri.toString();
                        String delID = delURI.substring(delURI.lastIndexOf("/") + 1);
                        array.put((Object)delID);
                    }
                    break block6;
                }
                if (!(this.context instanceof EntryNamesContext) || !this.parameters.containsKey("entryname")) break block7;
                Entry matchedEntry = ((EntryNamesContext)this.context).getEntryByName((String)this.parameters.get("entryname"));
                if (matchedEntry == null) break block6;
                array.put((Object)matchedEntry.getId());
                break block6;
            }
            Set entriesURI = this.context.getEntries();
            for (URI u : entriesURI) {
                Entry entry = this.context.getByEntryURI(u);
                if (entry == null) {
                    log.warn("No entry found for this referenced URI: " + String.valueOf(u));
                    continue;
                }
                String entryId = entry.getId();
                array.put((Object)entryId);
            }
        }
        return new JsonRepresentation(array.toString());
    }

    @Post
    public void acceptRepresentation(Representation r) throws ResourceException {
        try {
            if (this.context == null) {
                log.debug("The given context ID does not exist");
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                this.getResponse().setEntity(JSONErrorMessages.errorWrongContextIDmsg, MediaType.APPLICATION_JSON);
                return;
            }
            String entryId = (String)this.parameters.get("id");
            if (entryId != null) {
                if (!this.isEntryIdValid(entryId)) {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                    return;
                }
                Entry preExistingEntry = this.context.get(entryId);
                if (preExistingEntry != null) {
                    log.debug("Entry with that ID already exists");
                    this.getResponse().setStatus(Status.CLIENT_ERROR_CONFLICT);
                    this.getResponse().setLocationRef(this.context.get((String)this.parameters.get("id")).getEntryURI().toString());
                    this.getResponse().setEntity(JSONErrorMessages.errorEntryWithGivenIDExists, MediaType.APPLICATION_JSON);
                    return;
                }
            }
            Entry entry = null;
            try {
                if (!this.parameters.containsKey("entrytype") || ((String)this.parameters.get("entrytype")).equalsIgnoreCase("local")) {
                    entry = this.createLocalEntry(entry);
                } else {
                    String lT = (String)this.parameters.get("entrytype");
                    if (lT.equalsIgnoreCase("link") && this.parameters.containsKey("resource")) {
                        entry = this.createLinkEntry(entry);
                    } else if (lT.equalsIgnoreCase("reference") && this.parameters.containsKey("resource") && this.parameters.containsKey("cached-external-metadata")) {
                        entry = this.createReferenceEntry(entry);
                    } else if (lT.equalsIgnoreCase("linkreference") && this.parameters.containsKey("resource") && this.parameters.containsKey("cached-external-metadata")) {
                        entry = this.createLinkReferenceEntry(entry);
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                log.debug(iae.getMessage());
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                this.getResponse().setEntity((Representation)new JsonRepresentation(new JSONObject().put("error", (Object)iae.getMessage())));
                return;
            }
            if (entry != null) {
                ResourceType rt = this.getResourceType((String)this.parameters.get("informationresource"));
                entry.setResourceType(rt);
                String template = (String)this.parameters.get("template");
                if (template != null) {
                    URI templateEntryURI = null;
                    try {
                        templateEntryURI = new URI(template);
                    }
                    catch (URISyntaxException e) {
                        log.warn("Ignoring template, got invalid template URI: {}", (Object)e.getMessage());
                    }
                    Entry templateEntry = null;
                    if (templateEntryURI != null) {
                        templateEntry = this.context.getByEntryURI(templateEntryURI);
                    }
                    if (templateEntry != null && templateEntry.getLocalMetadata() != null) {
                        Model templateMD = templateEntry.getLocalMetadata().getGraph();
                        LinkedHashModel inheritedMD = new LinkedHashModel();
                        if (templateMD != null) {
                            ValueFactory vf = this.getRM().getValueFactory();
                            IRI oldResURI = vf.createIRI(templateEntry.getResourceURI().toString());
                            IRI newResURI = vf.createIRI(entry.getResourceURI().toString());
                            ArrayList<IRI> predicateBlackList = new ArrayList<IRI>();
                            predicateBlackList.add(vf.createIRI(NS.dc, "title"));
                            predicateBlackList.add(vf.createIRI(NS.dcterms, "title"));
                            predicateBlackList.add(vf.createIRI(NS.dc, "description"));
                            predicateBlackList.add(vf.createIRI(NS.dcterms, "description"));
                            ArrayList<Value> subjectBlackList = new ArrayList<Value>();
                            for (Statement statement : templateMD) {
                                if (predicateBlackList.contains(statement.getPredicate())) {
                                    subjectBlackList.add(statement.getObject());
                                    continue;
                                }
                                if (subjectBlackList.contains(statement.getSubject())) continue;
                                if (statement.getSubject().equals((Object)oldResURI)) {
                                    inheritedMD.add((Resource)newResURI, statement.getPredicate(), statement.getObject(), new Resource[]{statement.getContext()});
                                    continue;
                                }
                                inheritedMD.add((Object)statement);
                            }
                        }
                        if (!inheritedMD.isEmpty() && entry.getLocalMetadata() != null) {
                            LinkedHashModel mergedGraph = new LinkedHashModel();
                            mergedGraph.addAll((Collection)entry.getLocalMetadata().getGraph());
                            mergedGraph.addAll((Collection)inheritedMD);
                            entry.getLocalMetadata().setGraph((Model)mergedGraph);
                        }
                    }
                }
            }
            if (entry == null) {
                log.debug("Cannot create an entry with provided JSON");
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                this.getResponse().setEntity(JSONErrorMessages.errorCantCreateEntry, MediaType.APPLICATION_JSON);
            } else {
                this.getResponse().setStatus(Status.SUCCESS_CREATED);
                this.getResponse().setLocationRef(entry.getEntryURI().toString());
                this.getResponse().setEntity((Representation)new JsonRepresentation("{\"entryId\":\"" + entry.getId() + "\"}"));
                this.getResponse().getEntity().setModificationDate(entry.getModifiedDate());
                this.getResponse().getEntity().setTag(Util.createTag(entry.getModifiedDate()));
            }
        }
        catch (AuthorizationException e) {
            this.unauthorizedPOST();
        }
    }

    private Entry createLinkReferenceEntry(Entry entry) {
        block8: {
            if (this.isGraphTypeForbidden()) {
                return null;
            }
            try {
                if (this.parameters.get("resource") == null || !"linkreference".equalsIgnoreCase((String)this.parameters.get("entrytype"))) break block8;
                URI resourceURI = URI.create((String)this.parameters.get("resource"));
                URI metadataURI = URI.create((String)this.parameters.get("cached-external-metadata"));
                entry = this.parameters.containsKey("list") ? this.context.createLinkReference((String)this.parameters.get("id"), resourceURI, metadataURI, new URI((String)this.parameters.get("list"))) : this.context.createLinkReference((String)this.parameters.get("id"), resourceURI, metadataURI, null);
                if (entry != null) {
                    this.setLocalMetadataGraph(entry);
                    this.setCachedMetadataGraph(entry);
                    this.setEntryGraph(entry);
                    if (this.parameters.containsKey("graphtype")) {
                        GraphType gt = this.getGraphType((String)this.parameters.get("graphtype"));
                        entry.setGraphType(gt);
                    }
                    if (this.parameters.containsKey("list")) {
                        try {
                            URI listURI = new URI((String)this.parameters.get("list"));
                            ((ContextImpl)this.context).copyACL(listURI, entry);
                        }
                        catch (URISyntaxException e) {
                            log.warn(e.getMessage());
                        }
                    }
                }
                return entry;
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        return null;
    }

    private Entry createReferenceEntry(Entry entry) {
        block7: {
            if (this.isGraphTypeForbidden()) {
                return null;
            }
            try {
                if (this.parameters.get("resource") == null || this.parameters.get("cached-external-metadata") == null || !"reference".equalsIgnoreCase((String)this.parameters.get("entrytype"))) break block7;
                URI resourceURI = URI.create((String)this.parameters.get("resource"));
                URI metadataURI = URI.create((String)this.parameters.get("cached-external-metadata"));
                entry = this.parameters.containsKey("list") ? this.context.createReference((String)this.parameters.get("id"), resourceURI, metadataURI, new URI((String)this.parameters.get("list"))) : this.context.createReference((String)this.parameters.get("id"), resourceURI, metadataURI, null);
                ResourceType rt = this.getResourceType((String)this.parameters.get("informationresource"));
                entry.setResourceType(rt);
                this.setCachedMetadataGraph(entry);
                this.setEntryGraph(entry);
                if (this.parameters.containsKey("graphtype")) {
                    GraphType bt = this.getGraphType((String)this.parameters.get("graphtype"));
                    entry.setGraphType(bt);
                }
                if (this.parameters.containsKey("list")) {
                    try {
                        URI listURI = new URI((String)this.parameters.get("list"));
                        ((ContextImpl)this.context).copyACL(listURI, entry);
                    }
                    catch (URISyntaxException e) {
                        log.warn(e.getMessage());
                    }
                }
                return entry;
            }
            catch (URISyntaxException e) {
                log.warn(e.getMessage());
            }
        }
        return null;
    }

    private ResourceType getResourceType(String rt) {
        if (rt == null || !rt.equals("false")) {
            return ResourceType.InformationResource;
        }
        return ResourceType.NamedResource;
    }

    private GraphType getGraphType(String gt) {
        if (gt == null || gt.isEmpty()) {
            return GraphType.None;
        }
        if (gt.equalsIgnoreCase("list")) {
            return GraphType.List;
        }
        if (gt.equalsIgnoreCase("resultlist")) {
            return GraphType.ResultList;
        }
        if (gt.equalsIgnoreCase("context")) {
            return GraphType.Context;
        }
        if (gt.equalsIgnoreCase("user")) {
            return GraphType.User;
        }
        if (gt.equalsIgnoreCase("group")) {
            return GraphType.Group;
        }
        if (gt.equalsIgnoreCase("systemcontext")) {
            return GraphType.SystemContext;
        }
        if (gt.equalsIgnoreCase("string")) {
            return GraphType.String;
        }
        if (gt.equalsIgnoreCase("graph")) {
            return GraphType.Graph;
        }
        if (gt.equalsIgnoreCase("pipeline")) {
            return GraphType.Pipeline;
        }
        if (gt.equalsIgnoreCase("pipelineresult")) {
            return GraphType.PipelineResult;
        }
        return GraphType.None;
    }

    private Entry createLocalEntry(Entry entry) {
        if (this.isGraphTypeForbidden()) {
            return null;
        }
        URI listURI = null;
        if (this.parameters.containsKey("list")) {
            try {
                listURI = new URI((String)this.parameters.get("list"));
            }
            catch (URISyntaxException e) {
                log.warn(e.getMessage());
            }
        }
        GraphType bt = this.getGraphType((String)this.parameters.get("graphtype"));
        entry = this.context.createResource((String)this.parameters.get("id"), bt, null, listURI);
        try {
            if (this.setResource(entry)) {
                this.setLocalMetadataGraph(entry);
                this.setEntryGraph(entry);
                if (listURI != null) {
                    ((ContextImpl)this.context).copyACL(listURI, entry);
                }
                return entry;
            }
            this.context.remove(entry.getEntryURI());
            return null;
        }
        catch (JSONException e) {
            return null;
        }
    }

    private boolean setResource(Entry entry) throws JSONException {
        JSONObject jsonObj = new JSONObject();
        if (this.requestText != null && !this.requestText.isEmpty()) {
            jsonObj = new JSONObject(this.requestText.replaceAll("_newId", entry.getId()));
        }
        if (!jsonObj.has("resource")) {
            return true;
        }
        switch (entry.getGraphType()) {
            case User: {
                Entry homeContextEntry;
                jsonObj = jsonObj.getJSONObject("resource");
                User user = (User)entry.getResource();
                if (jsonObj.has("name")) {
                    if (!user.setName(jsonObj.getString("name"))) {
                        return false;
                    }
                } else {
                    return false;
                }
                if (jsonObj.has("homecontext") && (homeContextEntry = this.getCM().get(jsonObj.getString("homecontext"))) != null) {
                    user.setHomeContext((Context)homeContextEntry.getResource());
                }
                if (!this.parameters.containsKey("groupURI")) break;
                try {
                    Entry groupEntry = this.getCM().getEntry(new URI((String)this.parameters.get("groupURI")));
                    Group group = (Group)groupEntry.getResource();
                    group.addMember(user);
                }
                catch (URISyntaxException e) {
                    log.warn(e.getMessage());
                }
                break;
            }
            case Group: {
                jsonObj = jsonObj.getJSONObject("resource");
                Group group = (Group)entry.getResource();
                if (!jsonObj.has("name")) break;
                group.setName(jsonObj.getString("name"));
                break;
            }
            case List: {
                JSONArray childrenArray = (JSONArray)jsonObj.get("resource");
                List list = (List)entry.getResource();
                if (childrenArray == null) break;
                for (int i = 0; i < childrenArray.length(); ++i) {
                    Entry child = this.context.get(childrenArray.getString(i));
                    if (child == null) continue;
                    list.addChild(child.getEntryURI());
                }
                break;
            }
            case Context: {
                jsonObj = jsonObj.getJSONObject("resource");
                Context cont = (Context)entry.getResource();
                if (jsonObj.has("name")) {
                    this.getCM().setName(cont.getURI(), jsonObj.getString("name"));
                }
                if (!jsonObj.has("quota")) break;
                try {
                    cont.setQuota(jsonObj.getLong("quota"));
                }
                catch (JSONException jsone) {
                    log.warn("Unable to parse new quota value: {}", (Object)jsone.getMessage());
                }
                break;
            }
            case String: {
                StringResource stringRes = (StringResource)entry.getResource();
                stringRes.setString(jsonObj.getString("resource"));
                break;
            }
            case Graph: 
            case Pipeline: {
                RDFResource RDFRes = (RDFResource)entry.getResource();
                Model g = RDFJSON.rdfJsonToGraph((JSONObject)jsonObj.get("resource"));
                RDFRes.setGraph(g);
                break;
            }
        }
        return true;
    }

    private Entry createLinkEntry(Entry entry) {
        if (this.isGraphTypeForbidden()) {
            return null;
        }
        URI resourceURI = URI.create((String)this.parameters.get("resource"));
        entry = this.parameters.containsKey("list") ? this.context.createLink((String)this.parameters.get("id"), resourceURI, URI.create((String)this.parameters.get("list"))) : this.context.createLink((String)this.parameters.get("id"), resourceURI, null);
        if (entry != null) {
            this.setLocalMetadataGraph(entry);
            this.setEntryGraph(entry);
            if (this.parameters.containsKey("graphtype")) {
                GraphType gt = this.getGraphType((String)this.parameters.get("graphtype"));
                entry.setGraphType(gt);
            }
            if (this.parameters.containsKey("list")) {
                try {
                    URI listURI = new URI((String)this.parameters.get("list"));
                    ((ContextImpl)this.context).copyACL(listURI, entry);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return entry;
    }

    private void setLocalMetadataGraph(Entry entry) {
        if (this.requestText == null) {
            return;
        }
        if (EntryType.Reference.equals((Object)entry.getEntryType())) {
            return;
        }
        try {
            JSONObject obj;
            Model graph;
            JSONObject mdObj = new JSONObject(this.requestText.replaceAll("_newId", entry.getId()));
            if (mdObj.has("metadata") && (graph = RDFJSON.rdfJsonToGraph(obj = (JSONObject)mdObj.get("metadata"))) != null) {
                entry.getLocalMetadata().setGraph(graph);
            }
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
        }
    }

    private void setCachedMetadataGraph(Entry entry) {
        if (this.requestText == null) {
            return;
        }
        if (EntryType.Reference.equals((Object)entry.getEntryType()) || EntryType.LinkReference.equals((Object)entry.getEntryType())) {
            try {
                JSONObject obj;
                Model graph;
                JSONObject mdObj = new JSONObject(this.requestText.replaceAll("_newId", entry.getId()));
                if (mdObj.has("cached-external-metadata") && (graph = RDFJSON.rdfJsonToGraph(obj = (JSONObject)mdObj.get("cached-external-metadata"))) != null) {
                    entry.getCachedExternalMetadata().setGraph(graph);
                }
            }
            catch (JSONException e) {
                log.warn(e.getMessage());
            }
        }
    }

    private void setEntryGraph(Entry entry) {
        if (this.requestText == null) {
            return;
        }
        try {
            JSONObject obj;
            Model graph;
            JSONObject mdObj = new JSONObject(this.requestText.replaceAll("_newId", entry.getId()));
            if (mdObj.has("info") && (graph = RDFJSON.rdfJsonToGraph(obj = (JSONObject)mdObj.get("info"))) != null) {
                entry.setGraph(graph);
            }
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
        }
    }

    @Delete
    public void removeRepresentations() throws ResourceException {
        try {
            if (this.context == null) {
                log.debug("Unable to find context with ID " + this.contextId);
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return;
            }
            this.getPM().checkAuthenticatedUserAuthorized(this.context.getEntry(), PrincipalManager.AccessProperty.Administer);
            this.getResponse().setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        catch (AuthorizationException e) {
            this.unauthorizedDELETE();
        }
    }

    private boolean isGraphTypeForbidden() {
        if (GraphType.PipelineResult.equals((Object)this.getGraphType((String)this.parameters.get("graphtype")))) {
            log.debug("Pipeline results may only be created by Pipelines");
            return true;
        }
        return false;
    }

    private boolean isEntryIdValid(String id) {
        return Pattern.compile("^[\\w\\-]+$").matcher(id).matches();
    }
}

