/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.util.Arrays;
import java.util.List;
import org.entrystore.config.Config;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.security.Password;
import org.entrystore.rest.EntryStoreApplication;
import org.entrystore.rest.auth.BasicVerifier;
import org.entrystore.rest.auth.CookieVerifier;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.HttpUtil;
import org.entrystore.rest.util.SimpleHTML;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieLoginResource
extends BaseResource {
    private static final Logger log = LoggerFactory.getLogger(CookieLoginResource.class);
    private static List<String> passwordLoginWhitelist;
    private static List<String> passwordLoginBlacklist;

    @Override
    public void init(Context c, Request request, Response response) {
        super.init(c, request, response);
        Config config = this.getRM().getConfiguration();
        if ("whitelist".equalsIgnoreCase(config.getString(Settings.AUTH_PASSWORD))) {
            passwordLoginWhitelist = config.getStringList(Settings.AUTH_PASSWORD_WHITELIST);
        }
        passwordLoginBlacklist = config.getStringList(Settings.AUTH_PASSWORD_BLACKLIST);
    }

    @Post
    public void acceptRepresentation(Representation r) {
        Form query;
        if (HttpUtil.isLargerThan(r, 32768L)) {
            log.warn("The size of the representation is larger than 32KB or unknown, request blocked");
            this.getResponse().setStatus(Status.CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE);
            return;
        }
        boolean html = MediaType.TEXT_HTML.equals((Object)this.getRequest().getClientInfo().getPreferredMediaType(Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_ALL)));
        try {
            query = new Form(r);
        }
        catch (IllegalArgumentException iae) {
            log.warn(iae.getMessage());
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return;
        }
        String userName = query.getFirstValue("auth_username");
        String password = query.getFirstValue("auth_password");
        String maxAgeStr = query.getFirstValue("auth_maxage");
        if (userName == null || password == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return;
        }
        if (password.length() > 2048) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return;
        }
        String lowerCaseUserName = userName.toLowerCase();
        if (passwordLoginBlacklist != null && passwordLoginBlacklist.stream().anyMatch(s -> s.equalsIgnoreCase(lowerCaseUserName)) || passwordLoginWhitelist != null && passwordLoginWhitelist.stream().noneMatch(s -> s.equalsIgnoreCase(lowerCaseUserName))) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            if (html) {
                this.getResponse().setEntity(new SimpleHTML("Login").representation("Login failed."));
            }
            return;
        }
        if (this.getUserTempLockoutCache().userIsLockedOut(lowerCaseUserName)) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_TOO_MANY_REQUESTS);
            if (html) {
                this.getResponse().setEntity(new SimpleHTML("Login").representation("User account is temporarily disabled. Too many failed logins."));
            }
            return;
        }
        String saltedHashedSecret = BasicVerifier.getSaltedHashedSecret(this.getPM(), lowerCaseUserName);
        boolean userIsEnabled = !BasicVerifier.isUserDisabled(this.getPM(), lowerCaseUserName);
        try {
            if (saltedHashedSecret != null && Password.check((String)password, (String)saltedHashedSecret)) {
                if (userIsEnabled) {
                    EntryStoreApplication app = (EntryStoreApplication)this.getApplication();
                    new CookieVerifier(app, (RepositoryManager)this.getRM()).createAuthToken(lowerCaseUserName, maxAgeStr, this.getRequest(), this.getResponse());
                    this.getResponse().setStatus(Status.SUCCESS_OK);
                    this.getUserTempLockoutCache().succeedLogin(lowerCaseUserName);
                    if (html) {
                        this.getResponse().setEntity(new SimpleHTML("Login").representation("Login successful."));
                    }
                    return;
                }
                this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                if (html) {
                    this.getResponse().setEntity(new SimpleHTML("Login").representation("Login failed. The account is disabled."));
                }
                return;
            }
        }
        catch (IllegalArgumentException iae) {
            log.warn(iae.getMessage());
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            if (html) {
                this.getResponse().setEntity(new SimpleHTML("Login").representation(iae.getMessage()));
            }
            return;
        }
        this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
        this.getUserTempLockoutCache().failLogin(lowerCaseUserName);
        if (html) {
            this.getResponse().setEntity(new SimpleHTML("Login").representation("Login failed."));
        }
    }
}

