/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.lang.StringEscapeUtils;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.Util;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(EchoResource.class);
    public static long MAX_ENTITY_SIZE = 0xA00000L;

    @Post
    public void acceptRepresentation(Representation r) {
        block9: {
            if (this.getPM().getGuestUser().getURI().equals(this.getPM().getAuthenticatedUserURI())) {
                this.respondWith(Status.CLIENT_ERROR_FORBIDDEN);
                return;
            }
            if (MediaType.MULTIPART_FORM_DATA.equals((Object)this.getRequest().getEntity().getMediaType(), true)) {
                try {
                    String payload;
                    if (this.getRequest().getEntity().getSize() > MAX_ENTITY_SIZE) {
                        this.respondWith(Status.CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE);
                        return;
                    }
                    List items = Util.createRestletFileUpload(this.getContext()).parseRepresentation(this.getRequest().getEntity());
                    Iterator iter = items.iterator();
                    if (!iter.hasNext()) break block9;
                    FileItem item = (FileItem)iter.next();
                    if (item.getSize() > MAX_ENTITY_SIZE) {
                        this.respondWith(Status.CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE);
                        return;
                    }
                    StringBuilder escapedContent = new StringBuilder();
                    escapedContent.append("<textarea>");
                    try {
                        payload = item.getString("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error(e.getMessage());
                        this.respondWith(Status.SERVER_ERROR_INTERNAL);
                        return;
                    }
                    escapedContent.append("status:");
                    escapedContent.append(Status.SUCCESS_OK.getCode());
                    escapedContent.append("\n");
                    escapedContent.append(StringEscapeUtils.escapeHtml((String)payload));
                    escapedContent.append("</textarea>");
                    this.getResponse().setEntity(escapedContent.toString(), MediaType.TEXT_HTML);
                }
                catch (FileUploadException e) {
                    this.respondWith(Status.CLIENT_ERROR_BAD_REQUEST);
                }
            } else {
                this.respondWith(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE);
            }
        }
    }

    private void respondWith(Status status) {
        Response resp = this.getResponse();
        resp.setStatus(status);
        resp.setEntity("<textarea>status:" + status.getCode() + "\n</textarea>", MediaType.TEXT_HTML);
    }
}

