/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.IOException;
import java.util.Date;
import java.util.Optional;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.List;
import org.entrystore.Metadata;
import org.entrystore.Resource;
import org.entrystore.exception.EntryMissingException;
import org.entrystore.rest.auth.UserTempLockoutCache;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.serializer.ResourceJsonSerializer;
import org.entrystore.rest.util.GraphUtil;
import org.entrystore.rest.util.JSONErrorMessages;
import org.entrystore.rest.util.RDFJSON;
import org.entrystore.rest.util.Util;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryResource
extends BaseResource {
    private final Logger log = LoggerFactory.getLogger(EntryResource.class);
    private final java.util.List<MediaType> supportedMediaTypes = java.util.List.of(MediaType.APPLICATION_RDF_XML, MediaType.APPLICATION_JSON, MediaType.TEXT_RDF_N3, new MediaType(RDFFormat.TURTLE.getDefaultMIMEType()), new MediaType(RDFFormat.TRIX.getDefaultMIMEType()), new MediaType(RDFFormat.NTRIPLES.getDefaultMIMEType()), new MediaType(RDFFormat.TRIG.getDefaultMIMEType()), new MediaType(RDFFormat.JSONLD.getDefaultMIMEType()), new MediaType(RDFFormat.RDFJSON.getDefaultMIMEType()));
    private UserTempLockoutCache userTempLockoutCache;
    private ResourceJsonSerializer resourceSerializer;

    public void doInit() {
        this.userTempLockoutCache = this.getUserTempLockoutCache();
        this.resourceSerializer = new ResourceJsonSerializer(this.getPM(), this.getCM(), this.userTempLockoutCache);
    }

    public Representation head() {
        return this.head(null);
    }

    public Representation head(Variant v) {
        try {
            if (this.entry == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return new EmptyRepresentation();
            }
            return this.createEmptyRepresentationWithLastModified(this.entry.getModifiedDate());
        }
        catch (AuthorizationException e) {
            return this.unauthorizedHEAD();
        }
    }

    @Get
    public Representation represent() {
        try {
            if (this.entry == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return new JsonRepresentation(JSONErrorMessages.errorEntryNotFound);
            }
            Optional<MediaType> preferredMediaType = Optional.ofNullable(this.getRequest().getClientInfo().getPreferredMediaType(this.supportedMediaTypes));
            MediaType rdfFormat = MediaType.APPLICATION_JSON;
            if (RDFFormat.JSONLD.getDefaultMIMEType().equals(this.parameters.get("rdfFormat"))) {
                rdfFormat = new MediaType(RDFFormat.JSONLD.getDefaultMIMEType());
            }
            EmptyRepresentation result = switch (this.getRequest().getMethod().getName()) {
                case "GET" -> this.getEntry(this.format != null ? this.format : preferredMediaType.orElse(MediaType.APPLICATION_RDF_XML), rdfFormat);
                default -> new EmptyRepresentation();
            };
            Date lastMod = this.entry.getModifiedDate();
            if (lastMod != null) {
                result.setModificationDate(lastMod);
                result.setTag(Util.createTag(lastMod));
            }
            return result;
        }
        catch (AuthorizationException e) {
            return this.unauthorizedGET();
        }
    }

    @Put
    public void storeRepresentation(Representation r) {
        try {
            if (this.getRequest().getEntity().isEmpty()) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return;
            }
            this.modifyEntry(this.format != null ? this.format : this.getRequestEntity().getMediaType());
            this.getResponse().setEntity(this.createEmptyRepresentationWithLastModified(this.entry.getModifiedDate()));
        }
        catch (AuthorizationException e) {
            this.unauthorizedPUT();
        }
    }

    @Delete
    public void removeRepresentations() {
        try {
            if (this.entry != null && this.context != null) {
                if (GraphType.List.equals((Object)this.entry.getGraphType()) && this.parameters.containsKey("recursive")) {
                    List l = (List)this.entry.getResource();
                    if (l != null) {
                        l.removeTree();
                    } else {
                        this.log.warn("Resource of the following list is null: " + String.valueOf(this.entry.getEntryURI()));
                    }
                } else {
                    this.context.remove(this.entry.getEntryURI());
                }
            } else {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        catch (AuthorizationException e) {
            this.unauthorizedDELETE();
        }
        catch (EntryMissingException e) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }

    private Representation getEntry(MediaType mediaType, MediaType rdfFormat) {
        if (MediaType.APPLICATION_JSON.equals((Object)mediaType)) {
            return this.getEntryInJSON(rdfFormat);
        }
        Model graph = this.entry.getGraph();
        String serializedGraph = GraphUtil.serializeGraph(graph, mediaType);
        if (serializedGraph != null) {
            this.getResponse().setStatus(Status.SUCCESS_OK);
            return new StringRepresentation((CharSequence)serializedGraph, mediaType);
        }
        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        return new EmptyRepresentation();
    }

    private Representation getEntryInJSON(MediaType rdfFormat) {
        try {
            JSONObject jobj = this.getEntryAsJSONObject(rdfFormat);
            return new JsonRepresentation(jobj.toString(2));
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
            return new JsonRepresentation(new JSONObject().put("error", (Object)e.getMessage()));
        }
        this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        return new JsonRepresentation(JSONErrorMessages.errorEntryNotFound);
    }

    private JSONObject getEntryAsJSONObject(MediaType rdfFormat) throws JSONException {
        Model relations;
        JSONObject mainJsonObject = new JSONObject();
        GraphType graphType = this.entry.getGraphType();
        EntryType entryType = this.entry.getEntryType();
        mainJsonObject.put("entryId", (Object)this.entry.getId());
        if ((graphType == GraphType.Context || graphType == GraphType.SystemContext) && entryType == EntryType.Local) {
            mainJsonObject.put("name", (Object)this.getCM().getName(this.entry.getResourceURI()));
            if (this.entry.getRepositoryManager().hasQuotas()) {
                JSONObject quotaObj = new JSONObject();
                Context c = this.getCM().getContext(this.entryId);
                if (c != null) {
                    quotaObj.put("quota", c.getQuota());
                    quotaObj.put("fillLevel", c.getQuotaFillLevel());
                }
                quotaObj.put("hasDefaultQuota", c.hasDefaultQuota());
                mainJsonObject.put("quota", (Object)quotaObj);
            }
        }
        Model entryGraph = this.entry.getGraph();
        JSONObject entryObj = GraphUtil.serializeGraphToJson(entryGraph, rdfFormat);
        mainJsonObject.accumulate("info", (Object)entryObj);
        if (this.parameters == null || !this.parameters.containsKey("includeAll")) {
            return mainJsonObject;
        }
        if (entryType == EntryType.LinkReference || entryType == EntryType.Reference) {
            try {
                Metadata cachedExternalMetadata = this.entry.getCachedExternalMetadata();
                Model cachedMetadataGraph = cachedExternalMetadata.getGraph();
                if (cachedMetadataGraph != null) {
                    JSONObject cachedExternalMetadataJsonObject = GraphUtil.serializeGraphToJson(cachedMetadataGraph, rdfFormat);
                    mainJsonObject.accumulate("cached-external-metadata", (Object)cachedExternalMetadataJsonObject);
                }
            }
            catch (AuthorizationException cachedExternalMetadata) {
                // empty catch block
            }
        }
        if (entryType == EntryType.Local || entryType == EntryType.Link || entryType == EntryType.LinkReference) {
            try {
                Metadata localMetadata = this.entry.getLocalMetadata();
                Model localMetadataGraph = localMetadata.getGraph();
                if (localMetadataGraph != null) {
                    JSONObject localMetaDataJsonObject = GraphUtil.serializeGraphToJson(localMetadataGraph, rdfFormat);
                    mainJsonObject.accumulate("metadata", (Object)localMetaDataJsonObject);
                }
            }
            catch (AuthorizationException localMetadata) {
                // empty catch block
            }
        }
        if ((relations = this.entry.getRelations()) != null) {
            JSONObject relationsJsonObject = GraphUtil.serializeGraphToJson(relations, rdfFormat);
            mainJsonObject.accumulate("relations", (Object)relationsJsonObject);
        }
        JSONArray rights = this.resourceSerializer.serializeRights(this.entry);
        mainJsonObject.put("rights", (Object)rights);
        if (entryType == EntryType.Local) {
            Object object;
            Resource resource = this.entry.getResource();
            if (graphType == null) {
                object = ResourceJsonSerializer.IMMUTABLE_EMPTY_JSONOBJECT;
            } else {
                switch (graphType) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case List: {
                        object = this.resourceSerializer.serializeResourceList(resource, new ResourceJsonSerializer.ListParams(this.parameters), rdfFormat);
                        break;
                    }
                    case User: {
                        object = this.resourceSerializer.serializeResourceUser(resource);
                        break;
                    }
                    case Group: {
                        object = this.resourceSerializer.serializeResourceGroup(resource, rdfFormat);
                        break;
                    }
                    case None: {
                        object = this.resourceSerializer.serializeResourceNone(resource);
                        break;
                    }
                    case String: {
                        object = this.resourceSerializer.serializeResourceString(resource);
                        break;
                    }
                    case Graph: {
                        object = this.resourceSerializer.serializeResourceGraph(resource, rdfFormat);
                        break;
                    }
                    case Pipeline: {
                        object = this.resourceSerializer.serializeResourcePipeline(resource, rdfFormat);
                        break;
                    }
                    case ResultList: 
                    case PipelineResult: 
                    case Context: 
                    case SystemContext: {
                        object = ResourceJsonSerializer.IMMUTABLE_EMPTY_JSONOBJECT;
                    }
                }
            }
            JSONObject resourceObject = object;
            mainJsonObject.accumulate("resource", (Object)resourceObject);
        }
        return mainJsonObject;
    }

    private void modifyEntry(MediaType mediaType) throws AuthorizationException {
        Model deserializedGraph;
        String graphString;
        try {
            graphString = this.getRequest().getEntity().getText();
        }
        catch (IOException e) {
            this.log.info(e.getMessage());
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return;
        }
        if (MediaType.APPLICATION_JSON.equals((Object)mediaType)) {
            try {
                JSONObject rdfJSON = new JSONObject(graphString);
                deserializedGraph = RDFJSON.rdfJsonToGraph(rdfJSON);
            }
            catch (JSONException e) {
                this.log.info(e.getMessage());
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return;
            }
        } else {
            deserializedGraph = GraphUtil.deserializeGraph(graphString, mediaType);
        }
        if (deserializedGraph == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        } else {
            this.entry.setGraph(deserializedGraph);
            if (this.parameters.containsKey("applyACLtoChildren") && GraphType.List.equals((Object)this.entry.getGraphType()) && EntryType.Local.equals((Object)this.entry.getEntryType())) {
                ((List)this.entry.getResource()).applyACLtoChildren(true);
            }
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
    }
}

