/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.entrystore.AuthorizationException;
import org.entrystore.Data;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.PrincipalManager;
import org.entrystore.ResourceType;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.transforms.Pipeline;
import org.entrystore.transforms.TransformException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(ExecutionResource.class);
    List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();

    public void doInit() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_JSON);
    }

    @Post
    public void acceptRepresentation(Representation r) {
        block24: {
            String pipeline;
            if (this.context == null) {
                this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                return;
            }
            MediaType preferredMediaType = this.getRequest().getClientInfo().getPreferredMediaType(this.supportedMediaTypes);
            if (!MediaType.APPLICATION_JSON.equals((Object)preferredMediaType)) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE);
                return;
            }
            JSONObject request = null;
            try {
                request = new JSONObject(this.getRequest().getEntity().getText());
            }
            catch (Exception e) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY);
                log.error(e.getMessage());
                return;
            }
            String source = null;
            try {
                pipeline = request.getString("pipeline");
                if (request.has("source")) {
                    source = request.getString("source");
                }
            }
            catch (JSONException e) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY);
                return;
            }
            if (pipeline == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return;
            }
            String contextResUri = this.context.getEntry().getResourceURI().toString();
            if (!pipeline.startsWith(contextResUri)) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return;
            }
            if (source != null && !source.startsWith(contextResUri)) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return;
            }
            try {
                this.getPM().checkAuthenticatedUserAuthorized(this.context.getEntry(), PrincipalManager.AccessProperty.WriteResource);
                Entry pipelineEntry = this.context.getByEntryURI(URI.create(pipeline));
                if (pipelineEntry == null) {
                    this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                    return;
                }
                Entry sourceEntry = null;
                URI listURI = null;
                String sourceMimeType = null;
                Data data = null;
                if (source != null) {
                    sourceEntry = this.context.getByEntryURI(URI.create(source));
                    if (sourceEntry == null) {
                        this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                        return;
                    }
                    Set lists = sourceEntry.getReferringListsInSameContext();
                    if (lists.size() == 1) {
                        listURI = (URI)lists.iterator().next();
                    }
                    sourceMimeType = sourceEntry.getMimetype();
                    data = (Data)sourceEntry.getResource();
                    if (!EntryType.Local.equals((Object)sourceEntry.getEntryType()) || !ResourceType.InformationResource.equals((Object)sourceEntry.getResourceType()) || sourceMimeType == null || data == null) {
                        this.getResponse().setStatus(Status.CLIENT_ERROR_CONFLICT);
                        return;
                    }
                }
                if (!GraphType.Pipeline.equals((Object)pipelineEntry.getGraphType())) {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_CONFLICT);
                    return;
                }
                Set processedEntries = null;
                try {
                    processedEntries = new Pipeline(pipelineEntry).run(sourceEntry, listURI);
                }
                catch (IllegalStateException iae) {
                    log.error(iae.getMessage());
                    this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                    return;
                }
                catch (TransformException te) {
                    log.error(te.getMessage());
                    this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                    return;
                }
                if (processedEntries == null || processedEntries.size() <= 0) break block24;
                JSONObject result = new JSONObject();
                JSONArray processedEntriesArr = new JSONArray();
                for (Entry e : processedEntries) {
                    processedEntriesArr.put((Object)e.getEntryURI().toString());
                }
                try {
                    result.put("result", (Object)processedEntriesArr);
                }
                catch (JSONException e) {
                    log.error(e.getMessage());
                }
                this.getResponse().setEntity((Representation)new JsonRepresentation(result));
                this.getResponse().setStatus(Status.SUCCESS_CREATED);
            }
            catch (AuthorizationException e) {
                log.debug("Unauthorized POST");
                this.unauthorizedPOST();
            }
        }
    }
}

