/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.n3.N3Writer;
import org.eclipse.rdf4j.rio.ntriples.NTriplesWriter;
import org.eclipse.rdf4j.rio.rdfxml.util.RDFXMLPrettyWriter;
import org.eclipse.rdf4j.rio.trig.TriGWriter;
import org.eclipse.rdf4j.rio.trix.TriXWriter;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;
import org.entrystore.AuthorizationException;
import org.entrystore.PrincipalManager;
import org.entrystore.User;
import org.entrystore.repository.config.Settings;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.JSONErrorMessages;
import org.jetbrains.annotations.NotNull;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(ExportResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Get
    public Representation represent() {
        User authenticatedUser = this.getPM().getUser(this.getPM().getAuthenticatedUserURI());
        try {
            if (authenticatedUser == null || this.getPM().getGuestUser().getURI().equals(authenticatedUser.getURI())) {
                throw new AuthorizationException(authenticatedUser, this.context != null ? this.context.getEntry() : null, PrincipalManager.AccessProperty.Administer);
            }
            this.getPM().setAuthenticatedUserURI(this.getPM().getAdminUser().getURI());
            if (!this.getPM().getAdminUser().getURI().equals(authenticatedUser.getURI()) && !this.getPM().getAdminGroup().isMember(authenticatedUser)) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                EmptyRepresentation emptyRepresentation = new EmptyRepresentation();
                return emptyRepresentation;
            }
            if (this.context == null) {
                log.error("Unable to find context with that ID");
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                JsonRepresentation jsonRepresentation = new JsonRepresentation(JSONErrorMessages.errorEntryNotFound);
                return jsonRepresentation;
            }
            boolean metadataOnly = this.parameters.containsKey("metadataOnly");
            String format = null;
            if (this.parameters.containsKey("rdfFormat")) {
                format = (String)this.parameters.get("rdfFormat");
            }
            Class<? extends RDFWriter> writer = ExportResource.determineWriter(format);
            Representation representation = this.getExport(metadataOnly, writer);
            return representation;
        }
        catch (AuthorizationException e) {
            log.error("unauthorizedGET");
            Representation representation = this.unauthorizedGET();
            return representation;
        }
        finally {
            this.getPM().setAuthenticatedUserURI(authenticatedUser.getURI());
        }
    }

    @NotNull
    private static Class<? extends RDFWriter> determineWriter(String format) {
        Class writer = format == null || RDFFormat.TRIG.getDefaultMIMEType().equals(format) ? TriGWriter.class : (RDFFormat.RDFXML.getDefaultMIMEType().equals(format) ? RDFXMLPrettyWriter.class : (RDFFormat.N3.getDefaultMIMEType().equals(format) ? N3Writer.class : (RDFFormat.TURTLE.getDefaultMIMEType().equals(format) ? TurtleWriter.class : (RDFFormat.TRIX.getDefaultMIMEType().equals(format) ? TriXWriter.class : (RDFFormat.NTRIPLES.getDefaultMIMEType().equals(format) ? NTriplesWriter.class : TriGWriter.class)))));
        return writer;
    }

    private Representation getExport(boolean metadataOnly, Class<? extends RDFWriter> writer) throws AuthorizationException {
        ExportFileRepresentation result = null;
        String tmpPrefix = "entrystore_context_" + this.contextId + "_export_";
        try {
            int bytesRead;
            HashSet users = new HashSet();
            File tmpExport = File.createTempFile(tmpPrefix, ".zip");
            tmpExport.deleteOnExit();
            File tmpTriples = File.createTempFile(tmpPrefix + "triples_", ".rdf");
            tmpTriples.deleteOnExit();
            File tmpProperties = File.createTempFile(tmpPrefix + "info_", ".properties");
            tmpProperties.deleteOnExit();
            log.info("Exporting triples of context {}", (Object)this.context.getURI());
            this.getCM().exportContext(this.context.getEntry(), tmpTriples, users, metadataOnly, writer);
            Properties exportProps = new Properties();
            exportProps.put("contextEntryURI", this.context.getEntry().getEntryURI().toString());
            exportProps.put("contextResourceURI", this.context.getEntry().getResourceURI().toString());
            exportProps.put("contextMetadataURI", this.context.getEntry().getLocalMetadataURI().toString());
            exportProps.put("contextRelationURI", this.context.getEntry().getRelationURI().toString());
            exportProps.put("baseURI", this.getRM().getRepositoryURL().toString());
            exportProps.put("exportDate", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date()));
            exportProps.put("exportingUser", this.getPM().getAuthenticatedUserURI().toString());
            if (!users.isEmpty()) {
                StringBuffer userList = new StringBuffer();
                for (URI uri : users) {
                    String alias;
                    String uriStr = uri.toString();
                    String userID = uriStr.substring(uriStr.lastIndexOf("/") + 1);
                    userList.append(userID);
                    User u = this.getPM().getUser(uri);
                    if (u != null && (alias = u.getName()) != null) {
                        userList.append(":").append(alias);
                    }
                    userList.append(",");
                }
                userList.deleteCharAt(userList.length() - 1);
                exportProps.put("containedUsers", userList.toString());
            }
            OutputStream fos = Files.newOutputStream(tmpProperties.toPath(), new OpenOption[0]);
            exportProps.store(fos, "EntryStore export information");
            fos.close();
            ZipOutputStream zipOS = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(tmpExport.toPath(), new OpenOption[0])));
            ZipEntry zeTriples = new ZipEntry("triples.rdf");
            zeTriples.setSize(tmpTriples.length());
            zeTriples.setTime(tmpTriples.lastModified());
            zeTriples.setMethod(8);
            zipOS.putNextEntry(zeTriples);
            byte[] buffer = new byte[8192];
            InputStream is = new BufferedInputStream(Files.newInputStream(tmpTriples.toPath(), new OpenOption[0]), 8192);
            while ((bytesRead = is.read(buffer)) != -1) {
                zipOS.write(buffer, 0, bytesRead);
            }
            is.close();
            ZipEntry zeProperties = new ZipEntry("export.properties");
            zeProperties.setSize(tmpProperties.length());
            zeProperties.setTime(tmpProperties.lastModified());
            zeProperties.setMethod(8);
            zipOS.putNextEntry(zeProperties);
            is = Files.newInputStream(tmpProperties.toPath(), new OpenOption[0]);
            while ((bytesRead = is.read(buffer)) != -1) {
                zipOS.write(buffer, 0, bytesRead);
            }
            is.close();
            String contextPath = this.getRM().getConfiguration().getString(Settings.DATA_FOLDER);
            if (contextPath != null) {
                File contextPathFile = new File(contextPath);
                File contextFolder = new File(contextPathFile, this.contextId);
                File[] contextFiles = contextFolder.listFiles();
                if (contextFiles != null) {
                    for (int i = 0; i < contextFiles.length; ++i) {
                        ZipEntry zeResource = new ZipEntry("resources/" + contextFiles[i].getName());
                        zeResource.setMethod(8);
                        zeResource.setSize(contextFiles[i].length());
                        zeResource.setTime(contextFiles[i].lastModified());
                        zipOS.putNextEntry(zeResource);
                        is = new BufferedInputStream(Files.newInputStream(contextFiles[i].toPath(), new OpenOption[0]), 8192);
                        while ((bytesRead = is.read(buffer)) != -1) {
                            zipOS.write(buffer, 0, bytesRead);
                        }
                    }
                } else {
                    log.warn("The data path of context {} is not a folder: {}", (Object)this.contextId, (Object)contextFolder);
                }
            } else {
                log.error("No EntryStore data folder configured");
            }
            zipOS.flush();
            zipOS.close();
            tmpTriples.delete();
            tmpProperties.delete();
            result = new ExportFileRepresentation(this, tmpExport, MediaType.APPLICATION_ZIP);
            result.getDisposition().setType("attachment");
            result.getDisposition().setFilename("context_" + this.contextId + "_export.zip");
            result.setSize(tmpExport.length());
        }
        catch (IOException | RepositoryException ex) {
            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL, ex.getMessage());
            log.error("Exception in getExport(): {}", (Object)ex.getMessage(), (Object)ex);
        }
        return result;
    }

    private class ExportFileRepresentation
    extends FileRepresentation {
        public ExportFileRepresentation(ExportResource exportResource, File file, MediaType mediaType) {
            super(file, mediaType);
        }

        public void release() {
            File file = this.getFile();
            if (file.exists() && file.isFile() && file.canWrite()) {
                log.info("Removing temporary export file: {}", (Object)file);
                file.delete();
            }
            super.release();
        }
    }
}

