/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.solr.common.SolrDocument;
import org.entrystore.AuthorizationException;
import org.entrystore.PrincipalManager;
import org.entrystore.repository.util.SolrSearchIndex;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.JSONErrorMessages;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(IndexResource.class);
    List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();

    public void doInit() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_JSON);
    }

    @Get
    public Representation represent() {
        try {
            if (this.entry == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return new JsonRepresentation(JSONErrorMessages.errorEntryNotFound);
            }
            this.getPM().checkAuthenticatedUserAuthorized(this.entry, PrincipalManager.AccessProperty.Administer);
            SolrDocument doc = ((SolrSearchIndex)this.getRM().getIndex()).fetchDocument(this.entry.getEntryURI().toString());
            if (doc == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return new EmptyRepresentation();
            }
            JSONObject result = new JSONObject();
            for (String field : doc.getFieldValuesMap().keySet()) {
                Collection values = doc.getFieldValues(field);
                if (values.size() > 1) {
                    result.put(field, values);
                    continue;
                }
                if (values.size() != 1) continue;
                result.put(field, values.iterator().next());
            }
            return new JsonRepresentation(result);
        }
        catch (AuthorizationException e) {
            return this.unauthorizedGET();
        }
    }
}

