/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import com.coveo.saml.SamlClient;
import com.coveo.saml.SamlException;
import com.coveo.saml.SamlResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.PrincipalManager;
import org.entrystore.User;
import org.entrystore.config.Config;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.rest.EntryStoreApplication;
import org.entrystore.rest.auth.BasicVerifier;
import org.entrystore.rest.auth.CookieVerifier;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.HttpUtil;
import org.entrystore.rest.util.SimpleHTML;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CacheDirective;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacySamlLoginResource
extends BaseResource {
    private static final Logger log = LoggerFactory.getLogger(LegacySamlLoginResource.class);
    private static SamlClient samlClient;
    private static String relyingPartyId;
    private static String assertionConsumerService;
    private static String idpMetadataUrl;
    private static String redirSuccess;
    private static String redirFailure;
    private static Date metadataLoaded;
    private static long metadataMaxAge;

    @Override
    public void init(Context c, Request request, Response response) {
        super.init(c, request, response);
        if (samlClient == null) {
            Config config = this.getRM().getConfiguration();
            relyingPartyId = config.getString(Settings.AUTH_SAML_LEGACY_RELYING_PARTY_ID);
            if (relyingPartyId == null) {
                log.warn("No SAML Relying Party Identifier configured");
            } else {
                log.info("SAML Relying Party Identifier: " + relyingPartyId);
            }
            assertionConsumerService = config.getString(Settings.AUTH_SAML_LEGACY_ASSERTION_CONSUMER_SERVICE_URL);
            if (assertionConsumerService == null) {
                log.warn("No SAML Assertion Consumer Service URL configured");
            } else {
                log.info("SAML Assertion Consumer Service URL: " + assertionConsumerService);
            }
            idpMetadataUrl = config.getString(Settings.AUTH_SAML_LEGACY_IDP_METADATA_URL);
            if (idpMetadataUrl == null) {
                log.warn("No SAML IDP Metadata URL configured");
            } else {
                log.info("SAML IDP Metadata URL: " + idpMetadataUrl);
            }
            metadataMaxAge = config.getLong(Settings.AUTH_SAML_LEGACY_IDP_METADATA_MAXAGE, 604800L) * 1000L;
            redirSuccess = config.getString(Settings.AUTH_SAML_LEGACY_REDIRECT_SUCCESS_URL);
            redirFailure = config.getString(Settings.AUTH_SAML_LEGACY_REDIRECT_FAILURE_URL);
            if (relyingPartyId != null && assertionConsumerService != null && idpMetadataUrl != null) {
                this.loadMetadataAndInitSamlClient();
            } else {
                log.error("SAML authentication could not be initialized properly");
            }
        }
    }

    private void loadMetadataAndInitSamlClient() {
        try {
            BufferedReader idpMetadataReader = new BufferedReader(new InputStreamReader(new URL(idpMetadataUrl).openStream(), StandardCharsets.UTF_8));
            samlClient = SamlClient.fromMetadata((String)relyingPartyId, (String)assertionConsumerService, (Reader)idpMetadataReader);
            metadataLoaded = new Date();
            log.info("Reloaded SAML metadata from " + idpMetadataUrl);
        }
        catch (SamlException | IOException e) {
            log.error(e.getMessage());
        }
    }

    private void checkAndInitSamlClient() {
        if (new Date().getTime() - metadataLoaded.getTime() > metadataMaxAge) {
            log.info("Reloading SAML metadata");
            this.loadMetadataAndInitSamlClient();
        }
    }

    @Get
    public Representation represent() {
        this.checkAndInitSamlClient();
        try {
            this.redirectToIdentityProvider(this.getResponse());
        }
        catch (SamlException e) {
            log.error(e.getMessage());
            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
            return new StringRepresentation((CharSequence)e.getMessage());
        }
        return this.getResponseEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Post
    public void store(Representation r) {
        if (HttpUtil.isLargerThan(r, 524288L)) {
            log.warn("The size of the representation is larger than 512KB or unknown, similar requests may be blocked in future versions");
        }
        this.checkAndInitSamlClient();
        boolean html = MediaType.TEXT_HTML.equals((Object)this.getRequest().getClientInfo().getPreferredMediaType(Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_ALL)));
        boolean authSuccess = false;
        String encodedResponse = new Form(r).getFirstValue("SAMLResponse");
        if (encodedResponse != null) {
            String userName = null;
            try {
                SamlResponse samlResponse = samlClient.decodeAndValidateSamlResponse(encodedResponse, "POST");
                userName = samlResponse.getNameID();
                log.info("Successfully authenticated via SAML: " + userName);
            }
            catch (SamlException e) {
                log.error(e.getMessage());
            }
            if ("admin".equalsIgnoreCase(userName)) {
                userName = null;
            }
            boolean autoProvisioning = "on".equalsIgnoreCase(this.getRM().getConfiguration().getString(Settings.AUTH_SAML_LEGACY_USER_AUTO_PROVISIONING, "off"));
            if (userName != null && !BasicVerifier.userExists(this.getPM(), userName)) {
                if (!autoProvisioning) {
                    log.warn("User auto-provisioning is deactivated");
                } else {
                    PrincipalManager pm = this.getPM();
                    URI authUser = pm.getAuthenticatedUserURI();
                    try {
                        pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
                        Entry entry = pm.createResource(null, GraphType.User, null, null);
                        if (entry != null) {
                            User u = (User)entry.getResource();
                            log.info("Created user " + String.valueOf(u.getURI()));
                            pm.setPrincipalName(entry.getResourceURI(), userName);
                        } else {
                            log.error("An error occured when creating the new user");
                        }
                    }
                    finally {
                        pm.setAuthenticatedUserURI(authUser);
                    }
                }
            }
            if (userName != null && BasicVerifier.userExists(this.getPM(), userName) && !BasicVerifier.isUserDisabled(this.getPM(), userName)) {
                EntryStoreApplication app = (EntryStoreApplication)this.getApplication();
                new CookieVerifier(app, (RepositoryManager)this.getRM()).createAuthToken(userName, null, this.getRequest(), this.getResponse());
                if (redirSuccess != null) {
                    this.getResponse().redirectTemporary(URLDecoder.decode(redirSuccess, StandardCharsets.UTF_8));
                } else {
                    this.getResponse().setStatus(Status.SUCCESS_OK);
                    if (html) {
                        this.getResponse().setEntity(new SimpleHTML("Login").representation("Login successful."));
                    }
                }
                authSuccess = true;
            }
            if (!authSuccess) {
                log.info("Login failed with username {}", (Object)userName);
                if (redirFailure != null) {
                    this.getResponse().redirectTemporary(URLDecoder.decode(redirFailure, StandardCharsets.UTF_8));
                } else {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
                    if (html) {
                        this.getResponse().setEntity(new SimpleHTML("Login").representation("Login failed."));
                    }
                }
            }
        } else {
            try {
                this.redirectToIdentityProvider(this.getResponse());
            }
            catch (SamlException e) {
                log.error(e.getMessage());
            }
        }
    }

    private void redirectToIdentityProvider(Response response) throws SamlException {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("SAMLRequest", samlClient.getSamlRequest());
        if ("post".equalsIgnoreCase(this.getRM().getConfiguration().getString(Settings.AUTH_SAML_LEGACY_REDIRECT_METHOD, "get"))) {
            this.redirectWithPost(samlClient.getIdentityProviderUrl(), response, values);
        } else {
            this.redirectWithGet(samlClient.getIdentityProviderUrl(), response, values);
        }
    }

    private void redirectWithPost(String url, Response response, Map<String, String> values) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head></head><body><form id='TheForm' action='");
        sb.append(StringEscapeUtils.escapeHtml((String)url));
        sb.append("' method='POST'>");
        for (String key : values.keySet()) {
            String encodedKey = StringEscapeUtils.escapeHtml((String)key);
            String encodedValue = StringEscapeUtils.escapeHtml((String)values.get(key));
            sb.append("<input type='hidden' id='").append(encodedKey).append("' name='").append(encodedKey).append("' value='").append(encodedValue).append("'/>");
        }
        sb.append("</form><script type='text/javascript'>document.getElementById('TheForm').submit();</script></body></html>");
        StringRepresentation rep = new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_HTML);
        ArrayList<CacheDirective> cacheDirs = new ArrayList<CacheDirective>();
        cacheDirs.add(CacheDirective.noCache());
        cacheDirs.add(CacheDirective.noStore());
        response.setCacheDirectives(cacheDirs);
        response.setEntity((Representation)rep);
    }

    private void redirectWithGet(String url, Response response, Map<String, String> values) {
        Object targetUrl = url;
        if (values.containsKey("SAMLRequest")) {
            targetUrl = ((String)targetUrl).contains("?") ? (String)targetUrl + "&" : (String)targetUrl + "?";
            targetUrl = (String)targetUrl + "SAMLRequest=" + URLEncoder.encode(values.get("SAMLRequest"), StandardCharsets.UTF_8);
        }
        ArrayList<CacheDirective> cacheDirs = new ArrayList<CacheDirective>();
        cacheDirs.add(CacheDirective.noCache());
        cacheDirs.add(CacheDirective.noStore());
        response.setCacheDirectives(cacheDirs);
        response.redirectTemporary((String)targetUrl);
    }

    static {
        metadataLoaded = new Date();
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

