/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.entrystore.AuthorizationException;
import org.entrystore.rest.resources.BaseResource;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Put;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(LoggingResource.class);
    List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();

    public void doInit() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_JSON);
    }

    @Put(value="application/json")
    public void acceptRepresentation(Representation r) {
        try {
            URI currentUser = this.getPM().getAuthenticatedUserURI();
            if (!this.getPM().getAdminUser().getURI().equals(currentUser) && !this.getPM().getAdminGroup().isMember(this.getPM().getUser(currentUser))) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                return;
            }
        }
        catch (AuthorizationException ae) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            return;
        }
        try {
            JSONObject body = new JSONObject(r.getText());
            if (body.has("level")) {
                Level l = Level.toLevel((String)body.getString("level"), (Level)Level.INFO);
                log.info("Setting log root level to {}", (Object)l);
                Configurator.setRootLevel((Level)l);
            }
            if (body.has("packages")) {
                JSONObject packages = body.getJSONObject("packages");
                for (String p : packages.keySet()) {
                    Level pL = Level.toLevel((String)packages.getString(p), (Level)Level.INFO);
                    log.info("Setting log level of package {} to {}", (Object)p, (Object)pL);
                    Configurator.setLevel((String)p, (Level)pL);
                }
            }
            this.getResponse().setStatus(Status.SUCCESS_ACCEPTED);
        }
        catch (IOException e) {
            log.warn(e.getMessage());
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        }
    }
}

