/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.util.Arrays;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.rest.EntryStoreApplication;
import org.entrystore.rest.auth.CookieVerifier;
import org.entrystore.rest.auth.LoginTokenCache;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.SimpleHTML;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutResource
extends BaseResource {
    private static final Logger log = LoggerFactory.getLogger(LogoutResource.class);

    @Get
    public Representation represent() {
        String[] tokens = this.getRequest().getCookies().getValuesArray("auth_token");
        LoginTokenCache loginTokenCache = ((EntryStoreApplication)this.getApplication()).getLoginTokenCache();
        for (String t : tokens) {
            loginTokenCache.removeToken(t);
        }
        CookieVerifier.cleanCookies((RepositoryManager)this.getRM(), "auth_token", this.getRequest(), this.getResponse());
        this.getResponse().setStatus(Status.SUCCESS_OK);
        boolean html = MediaType.TEXT_HTML.equals((Object)this.getRequest().getClientInfo().getPreferredMediaType(Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_ALL)));
        if (html) {
            return new SimpleHTML("Logout").representation("Logout successful.");
        }
        return null;
    }
}

