/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.IOException;
import org.eclipse.rdf4j.model.Model;
import org.entrystore.AuthorizationException;
import org.entrystore.PrincipalManager;
import org.entrystore.impl.converters.Graph2Entries;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.GraphUtil;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(MergeResource.class);

    @Post
    public void acceptRepresentation(Representation r) {
        try {
            if (this.context == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return;
            }
            if (!this.getPM().getAdminUser().getURI().equals(this.getPM().getAuthenticatedUserURI())) {
                throw new AuthorizationException(this.getPM().getUser(this.getPM().getAuthenticatedUserURI()), this.context.getEntry(), PrincipalManager.AccessProperty.Administer);
            }
            String graphString = null;
            try {
                graphString = this.getRequest().getEntity().getText();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            if (graphString != null) {
                MediaType mediaType = this.format != null ? this.format : this.getRequestEntity().getMediaType();
                Model deserializedGraph = GraphUtil.deserializeGraph(graphString, mediaType);
                if (deserializedGraph != null) {
                    Graph2Entries g2e = new Graph2Entries(this.context);
                    g2e.merge(deserializedGraph, (String)this.parameters.get("resourceId"), null);
                    this.getResponse().setStatus(Status.SUCCESS_OK);
                    return;
                }
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return;
            }
        }
        catch (AuthorizationException e) {
            this.unauthorizedPOST();
        }
    }
}

