/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.IOException;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.Email;
import org.json.JSONObject;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageResource
extends BaseResource {
    private static final Logger log = LoggerFactory.getLogger(MessageResource.class);

    @Post
    public void sendMessage(Representation representation) throws ResourceException {
        String replyTo;
        String body;
        String to;
        String subject;
        String transportType;
        if (this.getPM().currentUserIsGuest()) {
            this.unauthorizedPOST();
            return;
        }
        try {
            JSONObject json = new JSONObject(representation.getText());
            transportType = json.getString("transport");
            subject = json.getString("subject");
            to = json.getString("to");
            body = json.getString("body");
            if (this.getPM().getPrincipalEntry(to) == null) {
                log.info("User tried to send message to unknown email address [{}]", (Object)to);
                this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                return;
            }
            replyTo = this.getPM().getPrincipalName(this.getPM().getAuthenticatedUserURI());
            if (replyTo != null && !replyTo.contains("@")) {
                replyTo = null;
            }
        }
        catch (IOException e) {
            log.debug("Error when parsing request", (Throwable)e);
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return;
        }
        if ("email".equalsIgnoreCase(transportType)) {
            Email.sendMessage(this.getRM().getConfiguration(), to, subject, body, null, replyTo);
        } else {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        }
    }
}

