/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Random;
import net.tanesha.recaptcha.ReCaptchaImpl;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.entrystore.Entry;
import org.entrystore.PrincipalManager;
import org.entrystore.User;
import org.entrystore.config.Config;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.security.Password;
import org.entrystore.rest.EntryStoreApplication;
import org.entrystore.rest.auth.LoginTokenCache;
import org.entrystore.rest.auth.SignupInfo;
import org.entrystore.rest.auth.SignupTokenCache;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.Email;
import org.entrystore.rest.util.EmailValidator;
import org.entrystore.rest.util.HttpUtil;
import org.entrystore.rest.util.RecaptchaVerifier;
import org.entrystore.rest.util.SimpleHTML;
import org.json.JSONObject;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordResetResource
extends BaseResource {
    private static final Logger log = LoggerFactory.getLogger(PasswordResetResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Get
    public Representation represent() throws ResourceException {
        SignupInfo ci;
        SimpleHTML html;
        block15: {
            html = new SimpleHTML("Password reset");
            String token = (String)this.parameters.get("confirm");
            if (token == null) {
                boolean reCaptcha = "on".equalsIgnoreCase(this.getRM().getConfiguration().getString(Settings.AUTH_RECAPTCHA, "off"));
                return new StringRepresentation((CharSequence)this.constructHtmlForm(reCaptcha), MediaType.TEXT_HTML, Language.ENGLISH);
            }
            SignupTokenCache tc = SignupTokenCache.getInstance();
            ci = (SignupInfo)tc.getTokenValue(token);
            if (ci == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return html.representation("The confirmation token is invalid or has been used already.");
            }
            tc.removeToken(token);
            PrincipalManager pm = this.getPM();
            URI authUser = pm.getAuthenticatedUserURI();
            try {
                User u;
                pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
                Entry userEntry = pm.getPrincipalEntry(ci.getEmail());
                if (userEntry != null) {
                    log.debug("Loaded user entry via email adress");
                    u = (User)userEntry.getResource();
                } else {
                    log.debug("Trying to load user entry via external ID");
                    u = pm.getUserByExternalID(ci.getEmail());
                }
                if (u == null) {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                    if (ci.getUrlFailure() != null) {
                        this.getResponse().redirectTemporary(URLDecoder.decode(ci.getUrlFailure(), StandardCharsets.UTF_8));
                        EmptyRepresentation emptyRepresentation = new EmptyRepresentation();
                        return emptyRepresentation;
                    }
                    Representation representation = html.representation("User with provided email address does not exist.");
                    return representation;
                }
                if (u.setSaltedHashedSecret(ci.getSaltedHashedPassword())) {
                    LoginTokenCache loginTokenCache = ((EntryStoreApplication)this.getApplication()).getLoginTokenCache();
                    loginTokenCache.removeTokens(ci.getEmail());
                    tc.removeAllTokens(ci.getEmail());
                    log.debug("Removed any authentication tokens belonging to user {}", (Object)u.getURI());
                    Email.sendPasswordChangeConfirmation(this.getRM().getConfiguration(), u.getEntry());
                    log.info("Reset password for user {}", (Object)u.getURI());
                    break block15;
                }
                log.error("Error when resetting password for user {}", (Object)u.getURI());
                this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                if (ci.getUrlFailure() != null) {
                    this.getResponse().redirectTemporary(URLDecoder.decode(ci.getUrlFailure(), StandardCharsets.UTF_8));
                    EmptyRepresentation emptyRepresentation = new EmptyRepresentation();
                    return emptyRepresentation;
                }
                Representation representation = html.representation("Unable to reset password due to internal error.");
                return representation;
            }
            finally {
                pm.setAuthenticatedUserURI(authUser);
            }
        }
        if (ci.getUrlSuccess() != null) {
            this.getResponse().redirectTemporary(URLDecoder.decode(ci.getUrlSuccess(), StandardCharsets.UTF_8));
            return new EmptyRepresentation();
        }
        return html.representation("Password reset was successful.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Post
    public void acceptRepresentation(Representation r) {
        html = new SimpleHTML("Password reset");
        if (HttpUtil.isLargerThan(r, 32768L)) {
            PasswordResetResource.log.warn("The size of the representation is larger than 32KB or unknown, request blocked");
            this.getResponse().setStatus(Status.CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE);
            return;
        }
        ci = new SignupInfo((RepositoryManager)this.getRM());
        ci.setExpirationDate(Instant.now().plus(1L, ChronoUnit.DAYS));
        rcChallenge = null;
        rcResponse = null;
        rcResponseV2 = null;
        password = null;
        if (MediaType.APPLICATION_JSON.equals((Object)r.getMediaType())) {
            try {
                siJson = new JSONObject(r.getText());
                if (siJson.has("email")) {
                    ci.setEmail(siJson.getString("email"));
                }
                if (siJson.has("password")) {
                    password = siJson.getString("password");
                }
                if (siJson.has("recaptcha_challenge_field")) {
                    rcChallenge = siJson.getString("recaptcha_challenge_field");
                }
                if (siJson.has("recaptcha_response_field")) {
                    rcResponse = siJson.getString("recaptcha_response_field");
                }
                if (siJson.has("grecaptcharesponse")) {
                    rcResponseV2 = siJson.getString("grecaptcharesponse");
                }
                if (siJson.has("urlfailure")) {
                    ci.setUrlFailure(siJson.getString("urlfailure"));
                }
                if (!siJson.has("urlsuccess")) ** GOTO lbl42
                ci.setUrlSuccess(siJson.getString("urlsuccess"));
            }
            catch (Exception e) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return;
            }
        } else {
            form = new Form(this.getRequest().getEntity());
            if (StringUtils.isNotEmpty((String)form.getFirstValue("email", true))) {
                ci.setEmail(form.getFirstValue("email", true));
            }
            password = form.getFirstValue("password", true);
            rcChallenge = form.getFirstValue("recaptcha_challenge_field", true);
            rcResponse = form.getFirstValue("recaptcha_response_field", true);
            rcResponseV2 = form.getFirstValue("g-recaptcha-response", true);
            ci.setUrlFailure(form.getFirstValue("urlfailure", true));
            ci.setUrlSuccess(form.getFirstValue("urlsuccess", true));
        }
lbl42:
        // 3 sources

        if (ci.getEmail() == null || password == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            this.getResponse().setEntity(html.representation("One or more parameters are missing."));
            return;
        }
        if ((password = password.trim()).length() < 8) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            this.getResponse().setEntity(html.representation("The password has to consist of at least 8 characters."));
            return;
        }
        if (!EmailValidator.getInstance().isValid(ci.getEmail())) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            this.getResponse().setEntity(html.representation("Invalid email address: " + ci.getEmail() + "."));
            return;
        }
        config = this.getRM().getConfiguration();
        PasswordResetResource.log.info("Received password reset request for {}", (Object)ci.getEmail());
        if ("on".equalsIgnoreCase(config.getString(Settings.AUTH_RECAPTCHA, "off")) && config.getString(Settings.AUTH_RECAPTCHA_PRIVATE_KEY) != null) {
            if ((rcChallenge == null || rcResponse == null) && rcResponseV2 == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                this.getResponse().setEntity(html.representation("reCaptcha information missing."));
                return;
            }
            PasswordResetResource.log.info("Checking reCaptcha for {}", (Object)ci.getEmail());
            remoteAddr = this.getRequest().getClientInfo().getUpstreamAddress();
            if (rcResponseV2 != null) {
                rcVerifier = new RecaptchaVerifier(config.getString(Settings.AUTH_RECAPTCHA_PRIVATE_KEY));
                reCaptchaIsValid = rcVerifier.verify(rcResponseV2, remoteAddr);
            } else {
                captcha = new ReCaptchaImpl();
                captcha.setPrivateKey(config.getString(Settings.AUTH_RECAPTCHA_PRIVATE_KEY));
                reCaptchaResponse = captcha.checkAnswer(remoteAddr, rcChallenge, rcResponse);
                reCaptchaIsValid = reCaptchaResponse.isValid();
            }
            if (reCaptchaIsValid) {
                PasswordResetResource.log.info("Valid reCaptcha for {}", (Object)ci.getEmail());
            } else {
                PasswordResetResource.log.info("Invalid reCaptcha for {}", (Object)ci.getEmail());
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                this.getResponse().setEntity(html.representation("Invalid reCaptcha received."));
                return;
            }
        }
        pm = this.getPM();
        authUser = pm.getAuthenticatedUserURI();
        try {
            pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
            userEntry = pm.getPrincipalEntry(ci.getEmail());
            if (userEntry != null) {
                PasswordResetResource.log.debug("Loaded user entry via email adress");
                u = (User)userEntry.getResource();
            } else {
                PasswordResetResource.log.debug("Trying to load user entry via external ID");
                u = pm.getUserByExternalID(ci.getEmail());
            }
            if (u != null) {
                if (u.isDisabled()) {
                    PasswordResetResource.log.info("User {} is disabled, not allowing password reset", (Object)ci.getEmail());
                    this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                    return;
                }
                token = RandomStringUtils.random((int)16, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new SecureRandom());
                confirmationLink = this.getRM().getRepositoryURL().toExternalForm() + "auth/pwreset?confirm=" + token;
                PasswordResetResource.log.info("Generated password reset token for {}", (Object)ci.getEmail());
                sendSuccessful = Email.sendPasswordResetConfirmation(this.getRM().getConfiguration(), ci.getEmail(), confirmationLink);
                if (!sendSuccessful) {
                    PasswordResetResource.log.info("Failed to send confirmation request to {}", (Object)ci.getEmail());
                    this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                    return;
                }
                ci.setSaltedHashedPassword(Password.getSaltedHash((String)password));
                SignupTokenCache.getInstance().putToken(token, ci);
                PasswordResetResource.log.info("Sent confirmation request to {}", (Object)ci.getEmail());
            } else {
                PasswordResetResource.log.info("Ignoring password reset attempt for non-existing user {}", (Object)ci.getEmail());
            }
        }
        finally {
            pm.setAuthenticatedUserURI(authUser);
        }
        this.getResponse().setStatus(Status.SUCCESS_OK);
        this.getResponse().setEntity(html.representation("A confirmation message was sent to " + ci.getEmail() + ", if the user exists."));
    }

    private String constructHtmlForm(boolean reCaptcha) {
        Config config = this.getRM().getConfiguration();
        SimpleHTML html = new SimpleHTML("Password reset");
        StringBuilder sb = new StringBuilder();
        sb.append(html.header());
        sb.append("<form action=\"\" method=\"post\">\n");
        sb.append("E-Mail address<br/><input type=\"text\" name=\"email\"><br/>\n");
        sb.append("New password<br/><input type=\"password\" name=\"password\"><br/>\n");
        if (reCaptcha) {
            String siteKey = config.getString(Settings.AUTH_RECAPTCHA_PUBLIC_KEY);
            if (siteKey == null) {
                log.warn("reCaptcha site key must be configured; rendering form without reCaptcha");
            } else {
                sb.append("<script src=\"https://www.google.com/recaptcha/api.js\" async defer></script>\n");
                sb.append("<p>\n<div class=\"g-recaptcha\" data-sitekey=\"").append(siteKey).append("\"></div>\n</p>\n");
            }
        }
        sb.append("<br/>\n<input type=\"submit\" value=\"Reset password\" />\n");
        sb.append("</form>\n");
        sb.append(html.footer());
        return sb.toString();
    }
}

