/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import com.google.common.base.Joiner;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.entrystore.AuthorizationException;
import org.entrystore.Entry;
import org.entrystore.PrincipalManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.rest.resources.BaseResource;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(ProxyResource.class);
    private Client client;
    private Response clientResponse;
    private static List<String> whitelistAnon;
    private static List<String> whitelistLocal;
    private static final List<Pattern> blacklistRegEx;

    public void doInit() {
        if (whitelistAnon == null) {
            whitelistAnon = new ArrayList<String>();
            List tmpWhitelistAnon = this.getRM().getConfiguration().getStringList(Settings.PROXY_WHITELIST_ANONYMOUS);
            for (String domain : tmpWhitelistAnon) {
                if (domain == null) continue;
                whitelistAnon.add(domain.toLowerCase());
            }
            if (!whitelistAnon.isEmpty()) {
                log.info("Proxy whitelist for guest users initialized with following domains: " + Joiner.on((String)", ").join(whitelistAnon) + "; Requests to other domains require authentication");
            } else {
                log.info("No domains provided for proxy whitelist; only authenticated users are allowed to perform proxy requests");
            }
        }
        if (whitelistLocal == null) {
            whitelistLocal = new ArrayList<String>();
            List tmpWhitelistLocal = this.getRM().getConfiguration().getStringList(Settings.PROXY_WHITELIST_LOCAL);
            for (String domain : tmpWhitelistLocal) {
                if (domain == null) continue;
                whitelistLocal.add(domain.toLowerCase());
            }
            if (!whitelistLocal.isEmpty()) {
                log.info("Proxy whitelist for authenticated requests against local domains initialized with following domains (to bypass built-in proxy blacklist): " + Joiner.on((String)", ").join(whitelistLocal) + "; Requests to other local domains will be blocked");
            } else {
                log.info("No domains provided for local proxy whitelist; no requests against local hosts will be allowed");
            }
        }
    }

    @Get
    public Representation represent() {
        String extResourceURL = (String)this.parameters.get("url");
        if (extResourceURL == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return null;
        }
        if (this.contextId != null && this.context == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return null;
        }
        if (this.context != null && !this.canReadContextResource(this.context.getEntry())) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            return null;
        }
        String host = null;
        try {
            host = new URI(extResourceURL).getHost().toLowerCase();
        }
        catch (NullPointerException | URISyntaxException e) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return null;
        }
        if (!whitelistAnon.contains(host) && this.getPM().getGuestUser().getURI().equals(this.getPM().getAuthenticatedUserURI())) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            return null;
        }
        log.info("Received proxy request for " + extResourceURL);
        this.clientResponse = this.getResourceFromURL(extResourceURL, 0);
        Representation representation = null;
        if (this.clientResponse != null && this.clientResponse.getStatus().isSuccess()) {
            representation = this.clientResponse.getEntity();
            this.getResponse().getHeaders().set("Content-Security-Policy", "script-src 'none'; form-action 'none';");
            this.getResponse().setOnSent((request, response) -> {
                try {
                    this.clientResponse.release();
                    this.client.stop();
                    this.client = null;
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            });
            if (Status.isConnectorError((int)this.clientResponse.getStatus().getCode())) {
                log.debug("Proxy request to " + extResourceURL + " timed out");
                this.getResponse().setStatus(Status.SERVER_ERROR_GATEWAY_TIMEOUT);
                return null;
            }
            this.getResponse().setStatus(this.clientResponse.getStatus());
            if (representation != null) {
                return representation;
            }
        }
        if (this.clientResponse == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        } else {
            this.getResponse().setStatus(this.clientResponse.getStatus());
        }
        return null;
    }

    private boolean canReadContextResource(Entry contextEntry) {
        try {
            this.getPM().checkAuthenticatedUserAuthorized(contextEntry, PrincipalManager.AccessProperty.ReadResource);
        }
        catch (AuthorizationException ae) {
            return false;
        }
        return true;
    }

    private Response getResourceFromURL(String url, int loopCount) {
        String host;
        try {
            host = new URI(url).getHost();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            Response errorResponse = new Response(new Request());
            errorResponse.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return errorResponse;
        }
        if (!this.isWhitelisted(host) && this.isBlacklisted(host)) {
            Response errorResponse = new Response(new Request());
            errorResponse.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            return errorResponse;
        }
        if (loopCount > 15) {
            log.warn("More than 15 redirect loops detected, aborting");
            return null;
        }
        if (this.client == null) {
            this.client = new Client(Arrays.asList(Protocol.HTTP, Protocol.HTTPS));
            this.client.setContext(new Context());
            this.client.getContext().getParameters().set("connectTimeout", "30000");
            this.client.getContext().getParameters().set("socketConnectTimeoutMs", "30000");
            this.client.getContext().getParameters().set("socketTimeout", "60000");
            this.client.getContext().getParameters().set("readTimeout", "60000");
            log.info("Initialized HTTP client for proxy requests");
        }
        Request request = new Request(Method.GET, url);
        request.getClientInfo().setAcceptedMediaTypes(this.getRequest().getClientInfo().getAcceptedMediaTypes());
        Response response = this.client.handle(request);
        if (response.getStatus().isRedirection()) {
            Reference ref = response.getLocationRef();
            response.getEntity().release();
            if (ref != null) {
                String refURL = ref.getIdentifier();
                log.debug("Request redirected to " + refURL);
                return this.getResourceFromURL(refURL, ++loopCount);
            }
        }
        if (response.getEntity() != null && response.getEntity().getLocationRef() != null && response.getEntity().getLocationRef().getBaseRef() == null) {
            response.getEntity().getLocationRef().setBaseRef(url.substring(0, url.lastIndexOf("/") + 1));
        }
        return response;
    }

    private String getTitle(String htmlString) {
        htmlString = htmlString.replaceAll("\\s+", " ");
        Pattern p = Pattern.compile("<title>(.*?)</title>", 2);
        Matcher m = p.matcher(htmlString);
        if (m.find()) {
            return StringEscapeUtils.unescapeHtml((String)m.group(1)).trim();
        }
        return null;
    }

    private String getMetaValue(String metaName, String htmlString) {
        htmlString = htmlString.replaceAll("\\s+", " ");
        Pattern p = Pattern.compile("<meta name=\"" + metaName + "\" content=\"(.*?)\" />", 2);
        Matcher m = p.matcher(htmlString);
        if (m.find()) {
            return StringEscapeUtils.unescapeHtml((String)m.group(1)).trim();
        }
        return null;
    }

    private String getDescription(String htmlString) {
        String[] lines;
        for (String s : lines = htmlString.split("\\r?\\n")) {
            String description = this.getMetaValue("description", s);
            if (description == null) continue;
            return description;
        }
        return null;
    }

    private Set<String> getKeywords(String htmlString) {
        String[] lines;
        HashSet<String> result = new HashSet<String>();
        for (String s : lines = htmlString.split("\\r?\\n")) {
            String keywords = this.getMetaValue("keywords", s);
            if (keywords == null) continue;
            for (String st : keywords.split(",")) {
                result.add(st.trim());
            }
        }
        return result;
    }

    private boolean isWhitelisted(String host) {
        return whitelistLocal.contains(host.toLowerCase());
    }

    private boolean isBlacklisted(String host) {
        host = host.toLowerCase();
        for (Pattern p : blacklistRegEx) {
            if (!p.matcher(host).find()) continue;
            return true;
        }
        try {
            InetAddress ia = InetAddress.getByName(host);
            if (ia.isAnyLocalAddress() || ia.isSiteLocalAddress() || ia.isLoopbackAddress() || ia.isLinkLocalAddress() || ia.isMulticastAddress()) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            log.warn(e.getMessage());
            return true;
        }
        return false;
    }

    static {
        blacklistRegEx = Arrays.asList(Pattern.compile("localhost"), Pattern.compile("(.+)\\.local"), Pattern.compile("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$"), Pattern.compile("^\\d$"), Pattern.compile(":"));
        log.info("Proxy blacklist consists of following regular expressions: " + Joiner.on((String)", ").join(blacklistRegEx));
    }
}

