/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import org.entrystore.rest.resources.BaseResource;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(QuotaResource.class);

    public void doInit() {
    }

    @Get
    public Representation represent() {
        if (this.context != null) {
            if (this.context.getEntry().getRepositoryManager().hasQuotas()) {
                JSONObject result = new JSONObject();
                try {
                    result.put("quota", this.context.getQuota());
                    result.put("fillLevel", this.context.getQuotaFillLevel());
                    result.put("hasDefaultQuota", this.context.hasDefaultQuota());
                    return new JsonRepresentation(result);
                }
                catch (JSONException e) {
                    log.error(e.getMessage());
                }
            } else {
                this.getResponse().setStatus(Status.SERVER_ERROR_NOT_IMPLEMENTED);
                return new JsonRepresentation("{\"error\":\"Quotas are not supported by this installation\"}");
            }
        }
        this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        return new JsonRepresentation("{\"error\":\"Cannot find that context or entry\"}");
    }

    @Put
    public void storeRepresentation(Representation r) {
        if (this.getPM().getAdminUser().getURI().equals(this.getPM().getAuthenticatedUserURI()) || this.getPM().getAdminGroup().isMember(this.getPM().getUser(this.getPM().getAuthenticatedUserURI()))) {
            if (this.context != null) {
                try {
                    JSONObject quotaObj = new JSONObject(this.getRequest().getEntity().getText());
                    long quota = -2L;
                    if (quotaObj.has("quota")) {
                        quota = quotaObj.getLong("quota");
                    }
                    if (this.context != null && quota != -2L) {
                        this.context.setQuota(quota);
                    }
                    this.getResponse().setEntity(this.createEmptyRepresentationWithLastModified(this.context.getEntry().getModifiedDate()));
                }
                catch (Exception e) {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                }
            } else {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        } else {
            this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
        }
    }

    @Delete
    public void removeRepresentations() {
        if (this.getPM().getAdminUser().getURI().equals(this.getPM().getAuthenticatedUserURI()) || this.getPM().getAdminGroup().isMember(this.getPM().getUser(this.getPM().getAuthenticatedUserURI()))) {
            if (this.context != null) {
                this.context.removeQuota();
            } else {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        } else {
            this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
        }
    }
}

