/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import com.coveo.saml.SamlClient;
import com.coveo.saml.SamlException;
import com.coveo.saml.SamlResponse;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.PrincipalManager;
import org.entrystore.User;
import org.entrystore.config.Config;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.rest.EntryStoreApplication;
import org.entrystore.rest.auth.BasicVerifier;
import org.entrystore.rest.auth.CookieVerifier;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.HttpUtil;
import org.entrystore.rest.util.SimpleHTML;
import org.entrystore.rest.util.Util;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CacheDirective;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlLoginResource
extends BaseResource {
    private static final Logger log = LoggerFactory.getLogger(SamlLoginResource.class);
    private static Map<String, SamlIdpInfo> samlIDPs;
    private static String redirSuccess;
    private static String redirFailure;
    private static final Object mutex;
    private static Config config;
    private static List<String> redirectDomainWhitelist;
    private static final Cache<String, Map<String, String>> relayStateCache;
    private static String defaultIdp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Context c, Request request, Response response) {
        super.init(c, request, response);
        Object object = mutex;
        synchronized (object) {
            if (config == null) {
                config = this.getRM().getConfiguration();
            }
            if (samlIDPs == null) {
                String assertionConsumerServiceBaseUrl = config.getString(Settings.AUTH_SAML_ASSERTION_CONSUMER_SERVICE_URL);
                if (assertionConsumerServiceBaseUrl == null) {
                    log.error("No SAML Assertion Consumer Service Base URL configured");
                    return;
                }
                log.info("SAML Assertion Consumer Service Base URL: {}", (Object)assertionConsumerServiceBaseUrl);
                redirectDomainWhitelist = config.getStringList(Settings.AUTH_SAML_REDIRECT_DOMAIN_WHITELIST, new ArrayList());
                for (String domain : redirectDomainWhitelist) {
                    log.info("Allowed domain for redirects: {}", (Object)domain);
                }
                List idps = config.getStringList(Settings.AUTH_SAML_IDPS);
                if (idps == null) {
                    return;
                }
                samlIDPs = new HashMap<String, SamlIdpInfo>();
                for (String idp : idps) {
                    SamlIdpInfo idpInfo = new SamlIdpInfo();
                    idpInfo.setId(idp);
                    idpInfo.setDomains(config.getStringList(this.idpSetting(Settings.AUTH_SAML_IDP_DOMAINS, idp), List.of("*")));
                    idpInfo.setRelyingPartyId(config.getString(this.idpSetting(Settings.AUTH_SAML_IDP_RELYING_PARTY_ID, idp)));
                    idpInfo.setMetadataUrl(config.getString(this.idpSetting(Settings.AUTH_SAML_IDP_METADATA_URL, idp)));
                    idpInfo.setMetadataMaxAge(config.getLong(this.idpSetting(Settings.AUTH_SAML_IDP_METADATA_MAXAGE, idp), 604800L) * 1000L);
                    idpInfo.setAutoProvisioning(config.getBoolean(this.idpSetting(Settings.AUTH_SAML_IDP_USER_AUTO_PROVISIONING, idp), false));
                    idpInfo.setRedirectMethod(config.getString(this.idpSetting(Settings.AUTH_SAML_IDP_REDIRECT_METHOD, idp), "get"));
                    Object acsWithIdp = assertionConsumerServiceBaseUrl;
                    acsWithIdp = ((String)acsWithIdp).contains("?") ? (String)acsWithIdp + "&" : (String)acsWithIdp + "?";
                    acsWithIdp = (String)acsWithIdp + "idp=" + idpInfo.getId();
                    idpInfo.setAssertionConsumerServiceUrl((String)acsWithIdp);
                    if (idpInfo.getRelyingPartyId() != null && idpInfo.getMetadataUrl() != null && idpInfo.getAssertionConsumerServiceUrl() != null) {
                        samlIDPs.put(idp, idpInfo);
                    } else {
                        log.error("Configuration of SAML IdP \"{}\" is incomplete and its SAML client was therefore not loaded", (Object)idp);
                    }
                    this.logIdpInfo(idpInfo);
                }
                redirSuccess = config.getString(Settings.AUTH_SAML_REDIRECT_SUCCESS_URL);
                redirFailure = config.getString(Settings.AUTH_SAML_REDIRECT_FAILURE_URL);
            }
            if (defaultIdp == null) {
                defaultIdp = config.getString(Settings.AUTH_SAML_DEFAULT_IDP);
                log.info("SAML Default IdP: {}", (Object)defaultIdp);
            }
        }
    }

    private void logIdpInfo(SamlIdpInfo info) {
        String prefix = "SAML IdP \"" + info.getId() + "\" -";
        log.info("{} Domains: {}", (Object)prefix, info.getDomains());
        log.info("{} Relying Party ID: {}", (Object)prefix, (Object)info.getRelyingPartyId());
        log.info("{} Metadata URL: {}", (Object)prefix, (Object)info.getMetadataUrl());
        log.info("{} Metadata Max Age: {} seconds", (Object)prefix, (Object)(info.getMetadataMaxAge() / 1000L));
        log.info("{} Assertion Consumer Service URL: {}", (Object)prefix, (Object)info.getAssertionConsumerServiceUrl());
        log.info("{} Auto Provisioning: {}", (Object)prefix, (Object)info.isAutoProvisioning());
        log.info("{} Redirect Method: {}", (Object)prefix, (Object)info.getRedirectMethod());
        log.info("{} Client: {}", (Object)prefix, (Object)(info.getSamlClient() != null ? "initialized" : "not initialized"));
    }

    private void loadMetadataAndInitSamlClient(SamlIdpInfo samlIdpInfo) throws SamlException {
        try {
            BufferedReader idpMetadataReader = new BufferedReader(new InputStreamReader(URI.create(samlIdpInfo.getMetadataUrl()).toURL().openStream(), StandardCharsets.UTF_8));
            SamlClient.SamlIdpBinding binding = SamlClient.SamlIdpBinding.POST;
            if ("get".equalsIgnoreCase(samlIdpInfo.getRedirectMethod())) {
                binding = SamlClient.SamlIdpBinding.Redirect;
            }
            samlIdpInfo.setSamlClient(SamlClient.fromMetadata((String)samlIdpInfo.getRelyingPartyId(), (String)samlIdpInfo.getAssertionConsumerServiceUrl(), (Reader)idpMetadataReader, (SamlClient.SamlIdpBinding)binding));
            samlIdpInfo.setMetadataLoaded(Instant.now());
            log.info("Loaded SAML metadata for IdP \"{}\" from {}", (Object)samlIdpInfo.getId(), (Object)samlIdpInfo.getMetadataUrl());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndInitSamlClient(SamlIdpInfo info) throws SamlException {
        Object object = mutex;
        synchronized (object) {
            if (info.getMetadataLoaded() == null || ChronoUnit.MILLIS.between(Instant.now(), info.getMetadataLoaded()) > info.getMetadataMaxAge()) {
                log.info("Loading SAML metadata for \"{}\"", (Object)info.getId());
                this.loadMetadataAndInitSamlClient(info);
            }
        }
    }

    @Get
    public Representation represent() {
        SamlIdpInfo idpInfo = this.findIdpForRequest(this.getRequest());
        if (idpInfo == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return new StringRepresentation((CharSequence)"No matching IdP configuration found for request");
        }
        try {
            this.checkAndInitSamlClient(idpInfo);
            this.redirectToIdentityProvider(idpInfo, this.getResponse());
        }
        catch (SamlException e) {
            log.error(e.getMessage());
            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
            return new StringRepresentation((CharSequence)e.getMessage());
        }
        return this.getResponseEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Post
    public void store(Representation r) {
        SamlIdpInfo idpInfo;
        if (HttpUtil.isLargerThan(r, 524288L)) {
            log.warn("The size of the representation is larger than 512KB or unknown, similar requests may be blocked in future versions");
        }
        if ((idpInfo = this.findIdpForRequest(this.getRequest())) == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            this.getResponse().setEntity((Representation)new StringRepresentation((CharSequence)"No matching IdP configuration found for request"));
            return;
        }
        try {
            this.checkAndInitSamlClient(idpInfo);
        }
        catch (SamlException e) {
            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
            this.getResponse().setEntity((Representation)new StringRepresentation((CharSequence)e.getMessage()));
            return;
        }
        boolean html = MediaType.TEXT_HTML.equals((Object)this.getRequest().getClientInfo().getPreferredMediaType(Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_ALL)));
        boolean authSuccess = false;
        Form samlResponseForm = new Form(r);
        String encodedResponse = samlResponseForm.getFirstValue("SAMLResponse");
        if (encodedResponse != null) {
            String redirectSuccessUrlFromRelayState = null;
            String redirectFailureUrlFromRelayState = null;
            String relayStateToken = samlResponseForm.getFirstValue("RelayState");
            if (relayStateToken != null) {
                log.debug("Received token via SAML RelayState: {}", (Object)relayStateToken);
                Map relayStateInfo = (Map)relayStateCache.getIfPresent((Object)relayStateToken);
                if (relayStateInfo != null) {
                    if (relayStateInfo.containsKey("successurl")) {
                        redirectSuccessUrlFromRelayState = (String)relayStateInfo.get("successurl");
                    }
                    if (relayStateInfo.containsKey("failureurl")) {
                        redirectFailureUrlFromRelayState = (String)relayStateInfo.get("failureurl");
                    }
                } else {
                    log.debug("Token {} not found in relay state cache", (Object)relayStateToken);
                }
            }
            String userName = null;
            try {
                SamlResponse samlResponse = idpInfo.getSamlClient().decodeAndValidateSamlResponse(encodedResponse, "POST");
                userName = samlResponse.getNameID();
                log.info("Successfully authenticated via SAML IdP \"{}\": {}", (Object)idpInfo.getId(), (Object)userName);
            }
            catch (SamlException e) {
                log.error(e.getMessage());
            }
            if ("admin".equalsIgnoreCase(userName)) {
                log.warn("Ignoring received username \"admin\" from SAML IdP \"{}\"", (Object)idpInfo.getId());
                userName = null;
            }
            if (userName != null && !BasicVerifier.userExists(this.getPM(), userName)) {
                if (!idpInfo.isAutoProvisioning()) {
                    log.warn("User auto-provisioning is deactivated for IdP \"{}\"", (Object)idpInfo.getId());
                } else {
                    PrincipalManager pm = this.getPM();
                    URI authUser = pm.getAuthenticatedUserURI();
                    try {
                        pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
                        Entry entry = pm.createResource(null, GraphType.User, null, null);
                        if (entry != null) {
                            User u = (User)entry.getResource();
                            log.info("Created user {}", (Object)u.getURI());
                            pm.setPrincipalName(entry.getResourceURI(), userName);
                        } else {
                            log.error("An error occured when creating the new user");
                        }
                    }
                    finally {
                        pm.setAuthenticatedUserURI(authUser);
                    }
                }
            }
            if (userName != null && BasicVerifier.userExists(this.getPM(), userName) && !BasicVerifier.isUserDisabled(this.getPM(), userName)) {
                EntryStoreApplication app = (EntryStoreApplication)this.getApplication();
                new CookieVerifier(app, (RepositoryManager)this.getRM()).createAuthToken(userName, null, this.getRequest(), this.getResponse());
                if (redirectSuccessUrlFromRelayState != null) {
                    log.debug("Redirecting to custom success URL: {}", (Object)redirectSuccessUrlFromRelayState);
                    this.getResponse().redirectTemporary(redirectSuccessUrlFromRelayState);
                } else if (redirSuccess != null) {
                    log.debug("Redirecting to default success URL: {}", (Object)redirSuccess);
                    this.getResponse().redirectTemporary(URLDecoder.decode(redirSuccess, StandardCharsets.UTF_8));
                } else {
                    this.getResponse().setStatus(Status.SUCCESS_OK);
                    if (html) {
                        this.getResponse().setEntity(new SimpleHTML("Login").representation("Login successful."));
                    }
                }
                authSuccess = true;
            }
            if (!authSuccess) {
                log.info("Login failed with username {} via IdP {}", (Object)userName, (Object)idpInfo.getId());
                if (redirectFailureUrlFromRelayState != null) {
                    log.debug("Redirecting to custom failure URL: {}", (Object)redirectFailureUrlFromRelayState);
                    this.getResponse().redirectTemporary(redirectFailureUrlFromRelayState);
                } else if (redirFailure != null) {
                    log.debug("Redirecting to default failure URL: {}", (Object)redirFailure);
                    this.getResponse().redirectTemporary(URLDecoder.decode(redirFailure, StandardCharsets.UTF_8));
                } else {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
                    if (html) {
                        this.getResponse().setEntity(new SimpleHTML("Login").representation("Login failed."));
                    }
                }
            }
        } else {
            try {
                this.redirectToIdentityProvider(idpInfo, this.getResponse());
            }
            catch (SamlException e) {
                log.error(e.getMessage());
            }
        }
    }

    private void redirectToIdentityProvider(SamlIdpInfo idpInfo, Response response) throws SamlException {
        String failureUrl;
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("SAMLRequest", idpInfo.getSamlClient().getSamlRequest());
        HashMap<String, String> relayStateInfo = new HashMap<String, String>();
        String successUrl = (String)this.parameters.get("successurl");
        if (this.isValidRedirectTarget(successUrl)) {
            relayStateInfo.put("successurl", successUrl);
        }
        if (this.isValidRedirectTarget(failureUrl = (String)this.parameters.get("failureurl"))) {
            relayStateInfo.put("failureurl", failureUrl);
        }
        if (!relayStateInfo.isEmpty()) {
            String relayStateToken = RandomStringUtils.secure().nextAlphanumeric(16);
            relayStateCache.put((Object)relayStateToken, relayStateInfo);
            values.put("RelayState", relayStateToken);
            log.debug("Setting RelayState token {} in SAMLRequest, mapped to redirect URL: {}", (Object)relayStateToken, (Object)successUrl);
        }
        log.debug("Redirecting to SAML IdP \"{}\" using {}", (Object)idpInfo.getId(), (Object)idpInfo.getRedirectMethod().toUpperCase());
        if ("post".equalsIgnoreCase(idpInfo.getRedirectMethod())) {
            this.redirectWithPost(idpInfo.getSamlClient().getIdentityProviderUrl(), response, values);
        } else {
            this.redirectWithGet(idpInfo.getSamlClient().getIdentityProviderUrl(), response, values);
        }
    }

    private void redirectWithPost(String url, Response response, Map<String, String> values) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head></head><body><form id='TheForm' action='");
        sb.append(StringEscapeUtils.escapeHtml((String)url));
        sb.append("' method='POST'>");
        for (String key : values.keySet()) {
            String encodedKey = StringEscapeUtils.escapeHtml((String)key);
            String encodedValue = StringEscapeUtils.escapeHtml((String)values.get(key));
            sb.append("<input type='hidden' id='").append(encodedKey).append("' name='").append(encodedKey).append("' value='").append(encodedValue).append("'/>");
        }
        sb.append("</form><script type='text/javascript'>document.getElementById('TheForm').submit();</script></body></html>");
        this.setCacheDirectives(response);
        response.setEntity((Representation)new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_HTML));
    }

    private void redirectWithGet(String url, Response response, Map<String, String> values) {
        StringBuilder targetUrl = new StringBuilder(url);
        for (String key : values.keySet()) {
            String encodedKey = URLEncoder.encode(key, StandardCharsets.UTF_8);
            String encodedValue = URLEncoder.encode(values.get(key), StandardCharsets.UTF_8);
            if (targetUrl.toString().contains("?")) {
                targetUrl.append("&");
            } else {
                targetUrl.append("?");
            }
            targetUrl.append(encodedKey).append("=").append(encodedValue);
        }
        this.setCacheDirectives(response);
        response.redirectTemporary(targetUrl.toString());
    }

    protected String findIdpForDomain(String domain) {
        String wildcardIdp = null;
        for (SamlIdpInfo idpInfo : this.getSamlIDPs().values()) {
            if (idpInfo.getDomains().contains("*")) {
                wildcardIdp = idpInfo.getId();
            }
            if (!idpInfo.getDomains().contains(domain.toLowerCase())) continue;
            return idpInfo.getId();
        }
        return wildcardIdp;
    }

    protected SamlIdpInfo findIdpForRequest(Request request) {
        HashMap<String, String> parameters = Util.parseRequest(request.getResourceRef().getRemainingPart());
        if (parameters.containsKey("username")) {
            String domain = StringUtils.substringAfter((String)((String)parameters.get("username")), (String)"@");
            if (domain != null && !domain.isEmpty()) {
                return this.getSamlIDPs().get(this.findIdpForDomain(domain));
            }
        } else {
            if (parameters.containsKey("idp") && !((String)parameters.get("idp")).isEmpty()) {
                return this.getSamlIDPs().get(parameters.get("idp"));
            }
            if (SamlLoginResource.getDefaultIdp() == null || SamlLoginResource.getDefaultIdp().isEmpty()) {
                log.warn("IdP parameter missing and no default IdP configured, unable to properly initialize SAML request");
            }
            return this.getSamlIDPs().get(SamlLoginResource.getDefaultIdp());
        }
        return null;
    }

    private void setCacheDirectives(Response response) {
        ArrayList<CacheDirective> cacheDirs = new ArrayList<CacheDirective>();
        cacheDirs.add(CacheDirective.noCache());
        cacheDirs.add(CacheDirective.noStore());
        response.setCacheDirectives(cacheDirs);
    }

    protected boolean isValidRedirectTarget(String url) {
        if (url != null) {
            return redirectDomainWhitelist.contains(URI.create(url).getHost());
        }
        return false;
    }

    private String idpSetting(String configKey, String idp) {
        return String.format(configKey, idp);
    }

    protected Map<String, SamlIdpInfo> getSamlIDPs() {
        return samlIDPs;
    }

    @Generated
    public static String getDefaultIdp() {
        return defaultIdp;
    }

    static {
        mutex = new Object();
        Security.addProvider((Provider)new BouncyCastleProvider());
        relayStateCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofSeconds(60L)).build();
    }

    protected static class SamlIdpInfo {
        private String id;
        private SamlClient samlClient;
        private String relyingPartyId;
        private String metadataUrl;
        private String assertionConsumerServiceUrl;
        private Instant metadataLoaded;
        private long metadataMaxAge;
        private List<String> domains;
        private boolean autoProvisioning;
        private String redirectMethod;

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public SamlClient getSamlClient() {
            return this.samlClient;
        }

        @Generated
        public String getRelyingPartyId() {
            return this.relyingPartyId;
        }

        @Generated
        public String getMetadataUrl() {
            return this.metadataUrl;
        }

        @Generated
        public String getAssertionConsumerServiceUrl() {
            return this.assertionConsumerServiceUrl;
        }

        @Generated
        public Instant getMetadataLoaded() {
            return this.metadataLoaded;
        }

        @Generated
        public long getMetadataMaxAge() {
            return this.metadataMaxAge;
        }

        @Generated
        public List<String> getDomains() {
            return this.domains;
        }

        @Generated
        public boolean isAutoProvisioning() {
            return this.autoProvisioning;
        }

        @Generated
        public String getRedirectMethod() {
            return this.redirectMethod;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setSamlClient(SamlClient samlClient) {
            this.samlClient = samlClient;
        }

        @Generated
        public void setRelyingPartyId(String relyingPartyId) {
            this.relyingPartyId = relyingPartyId;
        }

        @Generated
        public void setMetadataUrl(String metadataUrl) {
            this.metadataUrl = metadataUrl;
        }

        @Generated
        public void setAssertionConsumerServiceUrl(String assertionConsumerServiceUrl) {
            this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
        }

        @Generated
        public void setMetadataLoaded(Instant metadataLoaded) {
            this.metadataLoaded = metadataLoaded;
        }

        @Generated
        public void setMetadataMaxAge(long metadataMaxAge) {
            this.metadataMaxAge = metadataMaxAge;
        }

        @Generated
        public void setDomains(List<String> domains) {
            this.domains = domains;
        }

        @Generated
        public void setAutoProvisioning(boolean autoProvisioning) {
            this.autoProvisioning = autoProvisioning;
        }

        @Generated
        public void setRedirectMethod(String redirectMethod) {
            this.redirectMethod = redirectMethod;
        }

        @Generated
        public SamlIdpInfo() {
        }
    }
}

