/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import com.rometools.rome.feed.synd.SyndFeed;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.common.SolrException;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.entrystore.AuthorizationException;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.Group;
import org.entrystore.Metadata;
import org.entrystore.PrincipalManager;
import org.entrystore.Resource;
import org.entrystore.User;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.util.QueryResult;
import org.entrystore.repository.util.SolrSearchIndex;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.GraphUtil;
import org.entrystore.rest.util.Syndication;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(SearchResource.class);
    static int DEFAULT_LIMIT = 50;
    static int DEFAULT_FACET_LIMIT = 100;
    static int MAX_LIMIT = -1;
    static int MAX_FACET_LIMIT = -1;

    public void doInit() {
        if (MAX_LIMIT == -1) {
            MAX_LIMIT = this.getRM().getConfiguration().getInt(Settings.SOLR_MAX_LIMIT, 100);
        }
        if (MAX_FACET_LIMIT == -1) {
            MAX_FACET_LIMIT = this.getRM().getConfiguration().getInt(Settings.SOLR_FACET_MAX_LIMIT, 1000);
        }
    }

    @Get
    public Representation represent() throws ResourceException {
        try {
            int limit;
            String type = this.getMandatoryParameter("type").toLowerCase();
            String queryValue = this.getMandatoryParameter("query");
            if (queryValue.length() < 3) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return new JsonRepresentation("{\"error\":\"Query too short\"}");
            }
            MediaType rdfFormat = MediaType.APPLICATION_JSON;
            if (RDFFormat.JSONLD.getDefaultMIMEType().equals(this.parameters.get("rdfFormat"))) {
                rdfFormat = new MediaType(RDFFormat.JSONLD.getDefaultMIMEType());
            }
            String syndication = this.getOptionalParameter("syndication", null);
            String language = this.getOptionalParameter("lang", "en");
            String sorting = this.getOptionalParameter("sort", null);
            int offset = this.getOptionalParameterAsInteger("offset", 0);
            if (syndication != null && offset > 0) {
                String msg = "Query parameter 'offset' not supported with syndication";
                log.info(msg);
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return new JsonRepresentation("{\"error\":\"" + msg + "\"}");
            }
            if (offset < 0) {
                offset = 0;
            }
            if ((limit = this.getOptionalParameterAsInteger("limit", DEFAULT_LIMIT).intValue()) > MAX_LIMIT) {
                limit = MAX_LIMIT;
            } else if (limit < 0) {
                limit = DEFAULT_LIMIT;
            }
            ArrayList<String> filterQueries = new ArrayList<String>();
            String filterQueriesStr = this.getOptionalParameter("filterQuery", null);
            if (filterQueriesStr != null) {
                for (String fq : filterQueriesStr.split(",")) {
                    filterQueries.add(URLDecoder.decode(fq, StandardCharsets.UTF_8));
                }
            }
            SolrSearchIndex.FacetSettings facetSettings = new SolrSearchIndex.FacetSettings();
            facetSettings.fields = this.getOptionalParameter("facetFields", null);
            facetSettings.minCount = this.getOptionalParameterAsInteger("facetMinCount", 1);
            facetSettings.limit = Math.min(this.getOptionalParameterAsInteger("facetLimit", DEFAULT_FACET_LIMIT), MAX_FACET_LIMIT);
            if (facetSettings.limit < 1) {
                facetSettings.limit = DEFAULT_FACET_LIMIT;
            }
            facetSettings.matches = this.getOptionalParameter("facetMatches", null);
            facetSettings.missing = this.getOptionalParameterAsBoolean("facetMissing", false);
            QueryResults queryResults = new QueryResults(List.of(), -1L, List.of());
            if ("sparql".equalsIgnoreCase(type)) {
                queryResults = this.searchSparql(queryValue);
            } else if ("solr".equalsIgnoreCase(type)) {
                queryResults = this.searchSolr(queryValue, sorting, offset, limit, filterQueries, facetSettings);
            }
            if (syndication != null) {
                return this.generateSyndication(queryResults.entries(), syndication, language, limit);
            }
            return this.generateJson(offset, limit, queryResults, rdfFormat);
        }
        catch (BaseResource.JsonErrorException e) {
            return e.getRepresentation();
        }
        catch (AuthorizationException e) {
            return this.unauthorizedGET();
        }
    }

    public Representation generateSyndication(List<Entry> entries, String feedType, String language, int limit) {
        try {
            SyndFeed feed = Syndication.createFeedFromEntries((RepositoryManager)this.getRM(), entries, language, limit, this.getOptionalParameter("urltemplate", null));
            feed.setTitle(Syndication.sanitizeFeedTitle(this.getOptionalParameter("feedtitle", "Syndication feed of search")));
            feed.setLink(this.getRequest().getResourceRef().getIdentifier());
            feed.setFeedType(feedType);
            String feedXml = Syndication.convertSyndFeedToXml(feed);
            MediaType mediaType = Syndication.convertFeedTypeToMediaType(feedType);
            if (mediaType != null) {
                return new StringRepresentation((CharSequence)feedXml, mediaType);
            }
            return new StringRepresentation((CharSequence)feedXml);
        }
        catch (IllegalArgumentException e) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return new JsonRepresentation(new JSONObject().put("error", (Object)e.getMessage()));
        }
    }

    private JsonRepresentation generateJson(int offset, int limit, QueryResults queryResults, MediaType rdfFormat) {
        Date before = new Date();
        JSONArray children = new JSONArray();
        if (queryResults.entries() != null) {
            for (Entry e : queryResults.entries()) {
                Resource groupResource;
                if (e == null) continue;
                JSONObject childJSON = new JSONObject();
                childJSON.put("entryId", (Object)e.getId());
                childJSON.put("contextId", (Object)e.getContext().getEntry().getId());
                GraphType btChild = e.getGraphType();
                EntryType locChild = e.getEntryType();
                if (btChild == GraphType.Context || btChild == GraphType.SystemContext) {
                    childJSON.put("alias", (Object)this.getCM().getName(e.getResourceURI()));
                } else if (btChild == GraphType.User && locChild == EntryType.Local) {
                    User u = (User)e.getResource();
                    childJSON.put("name", (Object)u.getName());
                    try {
                        if (u.isDisabled()) {
                            childJSON.put("disabled", true);
                        }
                    }
                    catch (AuthorizationException ae) {
                        log.debug("Not allowed to read disabled status of " + String.valueOf(e.getEntryURI()));
                    }
                } else if (btChild == GraphType.Group && locChild == EntryType.Local && (groupResource = e.getResource()) != null) {
                    childJSON.put("name", (Object)((Group)groupResource).getName());
                }
                PrincipalManager PM = this.getPM();
                Set rights = PM.getRights(e);
                if (!rights.isEmpty()) {
                    for (PrincipalManager.AccessProperty ap : rights) {
                        if (ap == PrincipalManager.AccessProperty.Administer) {
                            childJSON.append("rights", (Object)"administer");
                            continue;
                        }
                        if (ap == PrincipalManager.AccessProperty.WriteMetadata) {
                            childJSON.append("rights", (Object)"writemetadata");
                            continue;
                        }
                        if (ap == PrincipalManager.AccessProperty.WriteResource) {
                            childJSON.append("rights", (Object)"writeresource");
                            continue;
                        }
                        if (ap == PrincipalManager.AccessProperty.ReadMetadata) {
                            childJSON.append("rights", (Object)"readmetadata");
                            continue;
                        }
                        if (ap != PrincipalManager.AccessProperty.ReadResource) continue;
                        childJSON.append("rights", (Object)"readresource");
                    }
                }
                try {
                    Model localMDGraph;
                    Metadata localMD;
                    Model cachedExternalMDGraph;
                    Metadata cachedExternalMD;
                    EntryType ltC = e.getEntryType();
                    if ((EntryType.Reference.equals((Object)ltC) || EntryType.LinkReference.equals((Object)ltC)) && (cachedExternalMD = e.getCachedExternalMetadata()) != null && (cachedExternalMDGraph = cachedExternalMD.getGraph()) != null) {
                        JSONObject childCachedExternalMDJSON = GraphUtil.serializeGraphToJson(cachedExternalMDGraph, rdfFormat);
                        childJSON.accumulate("cached-external-metadata", (Object)childCachedExternalMDJSON);
                    }
                    if ((EntryType.Link.equals((Object)ltC) || EntryType.Local.equals((Object)ltC) || EntryType.LinkReference.equals((Object)ltC)) && (localMD = e.getLocalMetadata()) != null && (localMDGraph = localMD.getGraph()) != null) {
                        JSONObject localMDJSON = GraphUtil.serializeGraphToJson(localMDGraph, rdfFormat);
                        childJSON.accumulate("metadata", (Object)localMDJSON);
                    }
                }
                catch (AuthorizationException ae) {
                    childJSON.accumulate("noAccessToMetadata", (Object)true);
                }
                try {
                    JSONObject childInfo = GraphUtil.serializeGraphToJson(e.getGraph(), rdfFormat);
                    childJSON.accumulate("info", (Object)Objects.requireNonNullElseGet(childInfo, JSONObject::new));
                }
                catch (AuthorizationException ae) {
                    childJSON.accumulate("noAccessToEntryInfo", (Object)true);
                }
                try {
                    Model childRelationsGraph = e.getRelations();
                    if (childRelationsGraph != null) {
                        JSONObject childRelationObj = GraphUtil.serializeGraphToJson(childRelationsGraph, rdfFormat);
                        childJSON.accumulate("relations", (Object)childRelationObj);
                    }
                }
                catch (AuthorizationException ae) {
                    childJSON.accumulate("noAccessToRelations", (Object)true);
                }
                children.put((Object)childJSON);
            }
        }
        JSONObject result = new JSONObject();
        JSONObject resource = new JSONObject();
        resource.put("children", (Object)children);
        result.put("resource", (Object)resource);
        result.put("results", queryResults.results());
        result.put("limit", limit);
        result.put("offset", offset);
        JSONArray facetFieldsArr = new JSONArray();
        for (FacetField ff : queryResults.responseFacetFields()) {
            JSONObject ffObj = new JSONObject();
            ffObj.put("name", (Object)ff.getName());
            ffObj.put("valueCount", ff.getValueCount());
            JSONArray ffValArr = new JSONArray();
            for (FacetField.Count ffVal : ff.getValues()) {
                JSONObject ffValObj = new JSONObject();
                ffValObj.put("name", (Object)ffVal.getName());
                ffValObj.put("count", ffVal.getCount());
                ffValArr.put((Object)ffValObj);
            }
            ffObj.put("values", (Object)ffValArr);
            facetFieldsArr.put((Object)ffObj);
        }
        result.put("facetFields", (Object)facetFieldsArr);
        long timeDiff = new Date().getTime() - before.getTime();
        log.debug("Graph fetching and serialization took " + timeDiff + " ms");
        return new JsonRepresentation(result.toString(2));
    }

    private QueryResults searchSolr(String queryValue, String sorting, int offset, int limit, List<String> filterQueries, SolrSearchIndex.FacetSettings facetSettings) throws BaseResource.JsonErrorException {
        try {
            List responseFacetFields;
            long results;
            LinkedList<Entry> entries;
            if (this.getRM().getIndex() == null) {
                this.getResponse().setStatus(Status.SERVER_ERROR_SERVICE_UNAVAILABLE, "Solr search deactivated");
                throw new BaseResource.JsonErrorException("Solr search is deactivated");
            }
            SolrQuery q = new SolrQuery(queryValue);
            q.setStart(Integer.valueOf(offset));
            q.setRows(Integer.valueOf(limit));
            if (sorting != null) {
                for (String string : sorting.split(",")) {
                    String[] fieldAndOrder = string.split(" ");
                    if (fieldAndOrder.length != 2) continue;
                    String field = fieldAndOrder[0];
                    if (field.startsWith("title.")) {
                        field = field.replace("title.", "title_sort.");
                    }
                    SolrQuery.ORDER order = SolrQuery.ORDER.asc;
                    try {
                        order = SolrQuery.ORDER.valueOf((String)fieldAndOrder[1].toLowerCase());
                    }
                    catch (IllegalArgumentException iae) {
                        log.warn("Unable to parse sorting value, using ascending by default");
                    }
                    q.addSort(field, order);
                }
            } else {
                q.addSort("score", SolrQuery.ORDER.desc);
                q.addSort("modified", SolrQuery.ORDER.desc);
            }
            if (facetSettings.fields != null) {
                q.setFacet(true);
                q.setFacetMinCount(facetSettings.minCount);
                q.setFacetLimit(facetSettings.limit);
                q.setFacetMissing(Boolean.valueOf(facetSettings.missing));
                if (facetSettings.matches != null) {
                    q.setParam("facet.matches", new String[]{facetSettings.matches});
                }
                for (String ff : facetSettings.fields.split(",")) {
                    q.addFacetField(new String[]{ff.replace("metadata.predicate.literal.", "metadata.predicate.literal_s.")});
                }
            }
            for (String fq : filterQueries) {
                q.addFilterQuery(new String[]{fq});
            }
            try {
                QueryResult qResult = ((SolrSearchIndex)this.getRM().getIndex()).sendQuery(q);
                entries = new LinkedList<Entry>(qResult.getEntries());
                results = qResult.getHits();
                responseFacetFields = qResult.getFacetFields();
            }
            catch (SolrException se) {
                log.warn(se.getMessage());
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                throw new BaseResource.JsonErrorException("Search failed due to wrong parameters");
            }
            return new QueryResults(entries, results, responseFacetFields);
        }
        catch (JSONException e) {
            log.error(e.getMessage());
            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
            throw new BaseResource.JsonErrorException("\"error\"");
        }
    }

    private QueryResults searchSparql(String queryValue) throws BaseResource.JsonErrorException {
        List entries;
        try {
            String query = "PREFIX dc:<http://purl.org/dc/terms/> SELECT ?x WHERE { ?x " + queryValue + " ?y }";
            entries = this.getCM().search(query, null, null);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BaseResource.JsonErrorException(URLEncoder.encode(e.getMessage(), StandardCharsets.UTF_8));
        }
        return new QueryResults(entries, entries.size());
    }

    record QueryResults(List<Entry> entries, long results, List<FacetField> responseFacetFields) {
        public QueryResults(List<Entry> entries, long results) {
            this(entries, results, List.of());
        }
    }
}

