/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.resultio.binary.BinaryQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.sparqljson.SPARQLResultsJSONWriter;
import org.eclipse.rdf4j.query.resultio.sparqlxml.SPARQLResultsXMLWriter;
import org.eclipse.rdf4j.query.resultio.text.csv.SPARQLResultsCSVWriter;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.repository.config.Settings;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.HttpUtil;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(SparqlResource.class);
    List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
    int maxExecutionTime;

    public void doInit() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_XML);
        this.supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        this.supportedMediaTypes.add(MediaType.TEXT_CSV);
        this.supportedMediaTypes.add(MediaType.ALL);
        this.maxExecutionTime = this.getRM().getConfiguration().getInt(Settings.REPOSITORY_PUBLIC_SPARQL_MAX_EXECUTION_TIME, 10);
    }

    @Get
    public Representation represent() throws ResourceException {
        if (this.getRM().getPublicRepository() == null) {
            this.getResponse().setStatus(Status.SERVER_ERROR_NOT_IMPLEMENTED);
            return null;
        }
        if (this.format == null) {
            this.format = this.getRequest().getClientInfo().getPreferredMediaType(this.supportedMediaTypes);
            if (this.format == null) {
                this.format = MediaType.ALL;
            }
        }
        String queryString = null;
        if (!this.parameters.containsKey("query")) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return null;
        }
        queryString = URLDecoder.decode((String)this.parameters.get("query"), StandardCharsets.UTF_8);
        Representation result = this.getSparqlResponse(this.format, queryString);
        if (result != null) {
            return result;
        }
        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        return null;
    }

    @Post
    public void acceptRepresentation(Representation r) {
        if (HttpUtil.isLargerThan(r, 32768L)) {
            log.warn("The size of the representation is larger than 32KB or unknown, request blocked");
            this.getResponse().setStatus(Status.CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE);
            return;
        }
        try {
            String format;
            if (this.getRM().getPublicRepository() == null) {
                this.getResponse().setStatus(Status.SERVER_ERROR_NOT_IMPLEMENTED);
                return;
            }
            Form form = new Form(this.getRequest().getEntity());
            switch (format = form.getFirstValue("output", true, "json")) {
                case "json": {
                    this.format = MediaType.APPLICATION_JSON;
                    break;
                }
                case "xml": {
                    this.format = MediaType.APPLICATION_XML;
                    break;
                }
                case "csv": {
                    this.format = MediaType.TEXT_CSV;
                }
            }
            String query = form.getFirstValue("query", true);
            if (query == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Query must not be empty");
                return;
            }
            Representation result = this.getSparqlResponse(this.format, query);
            if (result == null) {
                this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                return;
            }
            this.getResponse().setEntity(result);
        }
        catch (AuthorizationException ae) {
            this.unauthorizedPOST();
        }
    }

    private Representation getSparqlResponse(MediaType format, String queryString) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean success = false;
        try {
            success = MediaType.APPLICATION_JSON.equals((Object)format) ? this.runSparqlQuery(queryString, this.context, (TupleQueryResultHandler)new SPARQLResultsJSONWriter((OutputStream)baos)) : (MediaType.APPLICATION_XML.equals((Object)format) ? this.runSparqlQuery(queryString, this.context, (TupleQueryResultHandler)new SPARQLResultsXMLWriter((OutputStream)baos)) : (MediaType.TEXT_CSV.equals((Object)format) ? this.runSparqlQuery(queryString, this.context, (TupleQueryResultHandler)new SPARQLResultsCSVWriter((OutputStream)baos)) : this.runSparqlQuery(queryString, this.context, (TupleQueryResultHandler)new BinaryQueryResultWriter((OutputStream)baos))));
            if (success) {
                return new InputRepresentation((InputStream)new ByteArrayInputStream(baos.toByteArray()), format);
            }
            return null;
        }
        catch (Exception e) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
            log.error(e.getMessage());
            return null;
        }
    }

    private boolean runSparqlQuery(String queryString, Context context, TupleQueryResultHandler resultHandler) throws RepositoryException, MalformedQueryException, QueryEvaluationException, TupleQueryResultHandlerException {
        try (RepositoryConnection rc = this.getRM().getPublicRepository().getConnection();){
            if (rc == null) {
                boolean bl = false;
                return bl;
            }
            TupleQuery query = rc.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
            log.debug("Using max execution time of {} seconds", (Object)this.maxExecutionTime);
            query.setMaxExecutionTime(this.maxExecutionTime);
            query.setIncludeInferred(false);
            if (context != null) {
                IRI contextURI = rc.getValueFactory().createIRI(context.getURI().toString());
                log.info("Restricting query to named graph {}", (Object)contextURI);
                SimpleDataset ds = new SimpleDataset();
                ds.addDefaultGraph(contextURI);
                ds.addNamedGraph(contextURI);
                query.setDataset((Dataset)ds);
            }
            log.debug("Executing query: {}", (Object)queryString);
            long before = System.currentTimeMillis();
            query.evaluate(resultHandler);
            log.debug("SPARQL query execution took {} ms", (Object)(System.currentTimeMillis() - before));
        }
        return true;
    }
}

