/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.ContextManager;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.PrincipalManager;
import org.entrystore.User;
import org.entrystore.config.Config;
import org.entrystore.impl.Util;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.ConfigurationManager;
import org.entrystore.repository.util.EntryUtil;
import org.entrystore.repository.util.NS;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.JSONErrorMessages;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(StatisticsResource.class);
    String statType = null;
    String labels = null;
    Config config = null;
    public static String STAT_CONFIG_KEY = "se.kmr.scam.rest.statistics";

    public void doInit() {
        this.statType = (String)this.getRequest().getAttributes().get("stat-type");
        this.labels = (String)this.parameters.get("labels");
        this.config = (Config)this.getContext().getAttributes().get(STAT_CONFIG_KEY);
        if (this.config == null) {
            ConfigurationManager confManager = null;
            try {
                URI confURI = ConfigurationManager.getConfigurationURI((String)"statistics.properties");
                log.info("Attempting to load configuration from " + String.valueOf(confURI));
                confManager = new ConfigurationManager(confURI);
            }
            catch (IOException e) {
                log.error("Unable to load configuration: " + e.getMessage());
                return;
            }
            this.config = confManager.getConfiguration();
            if (this.config != null) {
                this.getContext().getAttributes().put(STAT_CONFIG_KEY, this.config);
            } else {
                log.error("Could not load configuration");
            }
        }
    }

    @Get
    public Representation represent() {
        try {
            if (this.context == null) {
                log.error("Cannot find a context with that ID");
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return new JsonRepresentation(JSONErrorMessages.errorWrongContextIDmsg);
            }
            JSONObject result = new JSONObject();
            try {
                if ("properties".equals(this.statType)) {
                    Date before = new Date();
                    result = this.getPropertyStatistics(this.context);
                    Date after = new Date();
                    log.info("Creation of property statistics took " + (after.getTime() - before.getTime()) + " ms");
                } else if ("ontology".equals(this.statType)) {
                    Date before = new Date();
                    result = this.getOntologyStatistics(this.context);
                    Date after = new Date();
                    log.info("Creation of ontology statistics took " + (after.getTime() - before.getTime()) + " ms");
                } else if ("keywords".equals(this.statType)) {
                    Date before = new Date();
                    result = this.getKeywordStatistics(this.context);
                    Date after = new Date();
                    log.info("Creation of keyword statistics took " + (after.getTime() - before.getTime()) + " ms");
                } else if ("propertiesDetailed".equals(this.statType)) {
                    result.put("error", (Object)"This statistics type is not supported yet");
                } else if ("relations".equals(this.statType)) {
                    result.put("error", (Object)"This statistics type is not supported yet");
                } else if ("competence".equals(this.statType)) {
                    Date before = new Date();
                    result = this.getCompetenceStatistics(this.context);
                    Date after = new Date();
                    log.info("Creation of keyword statistics took " + (after.getTime() - before.getTime()) + " ms");
                } else if ("type".equals(this.statType)) {
                    result.put("error", (Object)"This statistics type is not supported yet");
                } else {
                    result.put("error", (Object)"Unknown statistics type");
                }
                return new StringRepresentation((CharSequence)result.toString(2), MediaType.APPLICATION_JSON);
            }
            catch (JSONException e) {
                log.warn(e.getMessage());
                return new JsonRepresentation("{\"error\":\"" + e.getMessage() + "\"");
            }
        }
        catch (AuthorizationException e) {
            log.error("unauthorizedGET");
            return this.unauthorizedGET();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getPropertyStatistics(Context context) {
        JSONObject result = new JSONObject();
        ValueFactory vf = this.getRM().getValueFactory();
        URI currentUserURI = this.getPM().getAuthenticatedUserURI();
        try {
            this.getPM().setAuthenticatedUserURI(this.getPM().getAdminUser().getURI());
            Set entries = context.getEntries();
            HashMap propertyUsedIn = new HashMap();
            HashMap<String, Integer> propertyUsage = new HashMap<String, Integer>();
            int validatedCount = 0;
            int entryCount = 0;
            int mandatoryCount = 0;
            int recommendedCount = 0;
            Map<String, String> labelMap = this.getLabels(this.labels);
            Set<String> mandatoryProperties = null;
            Set<String> recommendedProperties = null;
            if (this.parameters.containsKey("profile")) {
                mandatoryProperties = this.getPropertyGroup((String)this.parameters.get("profile"), "mandatory");
                recommendedProperties = this.getPropertyGroup((String)this.parameters.get("profile"), "recommended");
            }
            for (URI uri : entries) {
                Entry entry = context.getByEntryURI(uri);
                if (entry == null || !GraphType.None.equals((Object)entry.getGraphType()) || EntryUtil.isDeleted((Entry)entry)) continue;
                ++entryCount;
                HashSet<String> entryProperties = new HashSet<String>();
                String entryID = entry.getId();
                URI resourceURI = entry.getResourceURI();
                Model metadata = entry.getMetadataGraph();
                for (Statement statement : metadata.filter((Resource)vf.createIRI(resourceURI.toString()), null, null, new Resource[0])) {
                    Set<String> usedIn;
                    IRI predicate = statement.getPredicate();
                    String predStr = predicate.toString();
                    if (labelMap != null && labelMap.containsKey(predStr)) {
                        predStr = labelMap.get(predStr);
                    }
                    entryProperties.add(predStr);
                    int count = 0;
                    if (propertyUsage.containsKey(predStr)) {
                        count = (Integer)propertyUsage.get(predStr);
                    }
                    propertyUsage.put(predStr, ++count);
                    if (propertyUsedIn.containsKey(predStr)) {
                        usedIn = (Set)propertyUsedIn.get(predStr);
                        usedIn.add(entryID);
                        propertyUsedIn.put(predStr, usedIn);
                        continue;
                    }
                    usedIn = new HashSet();
                    usedIn.add(entryID);
                    propertyUsedIn.put(predStr, usedIn);
                }
                if (mandatoryProperties != null && this.hasAllPropertiesOfGroup(mandatoryProperties, entryProperties)) {
                    ++mandatoryCount;
                }
                if (recommendedProperties == null || !this.hasAllPropertiesOfGroup(recommendedProperties, entryProperties)) continue;
                ++recommendedCount;
            }
            result.put("entryCount", entryCount);
            result.put("entryCountValidated", validatedCount);
            if (mandatoryProperties != null) {
                result.put("entryCountMandatory", mandatoryCount);
            }
            if (recommendedProperties != null) {
                result.put("entryCountRecommended", recommendedCount);
            }
            JSONArray propertyUsageArray = new JSONArray();
            Set properties = propertyUsage.keySet();
            for (String key : properties) {
                JSONObject propStats = new JSONObject();
                propStats.put("property", (Object)key);
                int statementCount = (Integer)propertyUsage.get(key);
                int usedInCount = ((Set)propertyUsedIn.get(key)).size();
                propStats.put("statements", statementCount);
                propStats.put("usedInCount", usedInCount);
                propertyUsageArray.put((Object)propStats);
            }
            result.put("propertyUsage", (Object)propertyUsageArray);
        }
        catch (JSONException e) {
            log.error(e.getMessage());
        }
        finally {
            this.getPM().setAuthenticatedUserURI(currentUserURI);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getOntologyStatistics(Context context) {
        JSONObject result = new JSONObject();
        ValueFactory vf = this.getRM().getValueFactory();
        URI currentUserURI = this.getPM().getAuthenticatedUserURI();
        try {
            this.getPM().setAuthenticatedUserURI(this.getPM().getAdminUser().getURI());
            Set entries = context.getEntries();
            HashMap<String, Set<String>> predicateUsedIn = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> ontologyTermUsedIn = new HashMap<String, Set<String>>();
            HashMap<String, Integer> ontPredUsage = new HashMap<String, Integer>();
            HashMap<String, Integer> ontTermUsage = new HashMap<String, Integer>();
            int entryCount = 0;
            HashSet<URI> entriesWithOntTerm = new HashSet<URI>();
            for (URI uri : entries) {
                Entry entry = context.getByEntryURI(uri);
                if (entry == null || !GraphType.None.equals((Object)entry.getGraphType()) || EntryUtil.isDeleted((Entry)entry)) continue;
                HashSet<IRI> allowedPredicates = new HashSet<IRI>();
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#Supports"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#ProvidesAlternativeViewOn"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#ProvidesExamplesOn"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#Methodology"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#Summarizes"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#ProvidesDataOn"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#ProvidesBackgroundOn"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#Details"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#IsAbout"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#ProvidesTheoreticalInformationOn"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#ProvidesNewInformationOn"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#CommentsOn"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#Refutes"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#Explains"));
                allowedPredicates.add(vf.createIRI("http://www.cc.uah.es/ie/ont/OE-Predicates#ProvidesExamplesOf"));
                ++entryCount;
                HashSet<String> ontPredicates = new HashSet<String>();
                HashSet<String> ontTerms = new HashSet<String>();
                String entryID = entry.getId();
                URI resourceURI = entry.getResourceURI();
                Model metadata = entry.getMetadataGraph();
                for (Statement stmnt : metadata.filter((Resource)vf.createIRI(resourceURI.toString()), null, null, new Resource[0])) {
                    Set<String> usedIn;
                    IRI predicate = stmnt.getPredicate();
                    if (!allowedPredicates.contains(predicate)) continue;
                    entriesWithOntTerm.add(resourceURI);
                    String predStr = predicate.stringValue().substring(predicate.stringValue().lastIndexOf("#") + 1);
                    Value object = stmnt.getObject();
                    String objStr = object.stringValue().substring(object.stringValue().lastIndexOf("#") + 1);
                    ontPredicates.add(predStr);
                    ontTerms.add(objStr);
                    int ontPredCount = 0;
                    if (ontPredUsage.containsKey(predStr)) {
                        ontPredCount = (Integer)ontPredUsage.get(predStr);
                    }
                    ontPredUsage.put(predStr, ++ontPredCount);
                    int ontTermCount = 0;
                    if (ontTermUsage.containsKey(objStr)) {
                        ontTermCount = (Integer)ontTermUsage.get(objStr);
                    }
                    ontTermUsage.put(objStr, ++ontTermCount);
                    if (predicateUsedIn.containsKey(predStr)) {
                        usedIn = (Set)predicateUsedIn.get(predStr);
                        usedIn.add(entryID);
                        predicateUsedIn.put(predStr, usedIn);
                    } else {
                        usedIn = new HashSet();
                        usedIn.add(entryID);
                        predicateUsedIn.put(predStr, usedIn);
                    }
                    if (ontologyTermUsedIn.containsKey(objStr)) {
                        usedIn = (Set)ontologyTermUsedIn.get(objStr);
                        usedIn.add(entryID);
                        ontologyTermUsedIn.put(objStr, usedIn);
                        continue;
                    }
                    usedIn = new HashSet();
                    usedIn.add(entryID);
                    ontologyTermUsedIn.put(objStr, usedIn);
                }
            }
            result.put("entryCount", entryCount);
            result.put("entryCountWithOntologyTerm", entriesWithOntTerm.size());
            JSONArray ontPredUsageArray = new JSONArray();
            Set predicates = ontPredUsage.keySet();
            for (String key : predicates) {
                JSONObject propStats = new JSONObject();
                propStats.put("title", (Object)key);
                int ontPredCount = (Integer)ontPredUsage.get(key);
                int usedInCount = ((Set)predicateUsedIn.get(key)).size();
                propStats.put("totalCount", ontPredCount);
                propStats.put("usedInCount", usedInCount);
                ontPredUsageArray.put((Object)propStats);
            }
            result.put("predicateUsage", (Object)ontPredUsageArray);
            JSONArray ontTermUsageArray = new JSONArray();
            Set ontologyTerms = ontTermUsage.keySet();
            for (String key : ontologyTerms) {
                JSONObject propStats = new JSONObject();
                propStats.put("title", (Object)key);
                int ontTermCount = (Integer)ontTermUsage.get(key);
                int usedInCount = ((Set)ontologyTermUsedIn.get(key)).size();
                propStats.put("totalCount", ontTermCount);
                propStats.put("usedInCount", usedInCount);
                ontTermUsageArray.put((Object)propStats);
            }
            result.put("ontologyTermUsage", (Object)ontTermUsageArray);
        }
        catch (JSONException e) {
            log.error(e.getMessage());
        }
        finally {
            this.getPM().setAuthenticatedUserURI(currentUserURI);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getKeywordStatistics(Context context) {
        JSONObject result = new JSONObject();
        ValueFactory vf = this.getRM().getValueFactory();
        URI currentUserURI = this.getPM().getAuthenticatedUserURI();
        try {
            this.getPM().setAuthenticatedUserURI(this.getPM().getAdminUser().getURI());
            Set entries = context.getEntries();
            HashMap keywordUsedIn = new HashMap();
            HashMap<String, Integer> keywordUsage = new HashMap<String, Integer>();
            int entryCount = 0;
            HashSet<URI> entriesWithKeyword = new HashSet<URI>();
            for (URI uri : entries) {
                Entry entry = context.getByEntryURI(uri);
                if (entry == null || !GraphType.None.equals((Object)entry.getGraphType()) || EntryUtil.isDeleted((Entry)entry)) continue;
                HashSet<IRI> allowedPredicates = new HashSet<IRI>();
                allowedPredicates.add(vf.createIRI(NS.dc + "subject"));
                allowedPredicates.add(vf.createIRI(NS.dcterms + "subject"));
                ++entryCount;
                HashSet<String> keywords = new HashSet<String>();
                String entryID = entry.getId();
                URI resourceURI = entry.getResourceURI();
                Model metadata = entry.getMetadataGraph();
                for (Statement stmnt : metadata.filter((Resource)vf.createIRI(resourceURI.toString()), null, null, new Resource[0])) {
                    Set<String> usedIn;
                    IRI predicate = stmnt.getPredicate();
                    if (!allowedPredicates.contains(predicate)) continue;
                    entriesWithKeyword.add(resourceURI);
                    Value object = stmnt.getObject();
                    if (object instanceof Resource) {
                        for (Statement statement : metadata.filter((Resource)object, RDF.VALUE, null, new Resource[0])) {
                            Set<String> usedIn2;
                            Value o2 = statement.getObject();
                            if (!(o2 instanceof Literal)) continue;
                            String objStr = o2.stringValue().substring(o2.stringValue().lastIndexOf("#") + 1).toLowerCase();
                            keywords.add(objStr);
                            int keywordCount = 0;
                            if (keywordUsage.containsKey(objStr)) {
                                keywordCount = (Integer)keywordUsage.get(objStr);
                            }
                            keywordUsage.put(objStr, ++keywordCount);
                            if (keywordUsedIn.containsKey(objStr)) {
                                usedIn2 = (Set)keywordUsedIn.get(objStr);
                                usedIn2.add(entryID);
                                keywordUsedIn.put(objStr, usedIn2);
                                continue;
                            }
                            usedIn2 = new HashSet();
                            usedIn2.add(entryID);
                            keywordUsedIn.put(objStr, usedIn2);
                        }
                        continue;
                    }
                    if (!(object instanceof Literal)) continue;
                    String objStr = object.stringValue().substring(object.stringValue().lastIndexOf("#") + 1).toLowerCase();
                    keywords.add(objStr);
                    int keywordCount = 0;
                    if (keywordUsage.containsKey(objStr)) {
                        keywordCount = (Integer)keywordUsage.get(objStr);
                    }
                    keywordUsage.put(objStr, ++keywordCount);
                    if (keywordUsedIn.containsKey(objStr)) {
                        usedIn = (Set)keywordUsedIn.get(objStr);
                        usedIn.add(entryID);
                        keywordUsedIn.put(objStr, usedIn);
                        continue;
                    }
                    usedIn = new HashSet();
                    usedIn.add(entryID);
                    keywordUsedIn.put(objStr, usedIn);
                }
            }
            result.put("entryCount", entryCount);
            result.put("entryCountWithKeyword", entriesWithKeyword.size());
            JSONArray keywordUsageArray = new JSONArray();
            Set keywords = keywordUsage.keySet();
            for (String key : keywords) {
                JSONObject propStats = new JSONObject();
                propStats.put("title", (Object)key);
                int keywordCount = (Integer)keywordUsage.get(key);
                int usedInCount = ((Set)keywordUsedIn.get(key)).size();
                propStats.put("totalCount", keywordCount);
                propStats.put("usedInCount", usedInCount);
                keywordUsageArray.put((Object)propStats);
            }
            result.put("keywordUsage", (Object)keywordUsageArray);
        }
        catch (JSONException e) {
            log.error(e.getMessage());
        }
        finally {
            this.getPM().setAuthenticatedUserURI(currentUserURI);
        }
        return result;
    }

    private boolean hasAllPropertiesOfGroup(Set<String> group, Set<String> entryProperties) {
        if (group == null) {
            return false;
        }
        for (String prop : group) {
            if (entryProperties.contains(prop)) continue;
            return false;
        }
        return true;
    }

    private Set<String> getPropertyGroup(String group, String subgroup) {
        String mProps = this.config.getString("scam.statistics.group." + group + "." + subgroup, new String());
        return new HashSet<String>(Arrays.asList(mProps.split(",")));
    }

    private Map<String, String> getLabels(String label) {
        if (label == null) {
            return null;
        }
        List labelList = this.config.getStringList("scam.statistics.label." + label, new ArrayList());
        HashMap<String, String> labelMap = new HashMap<String, String>();
        for (String labelKeyValue : labelList) {
            String[] keyValue = labelKeyValue.split(",");
            if (keyValue.length != 2) continue;
            labelMap.put(keyValue[0], keyValue[1]);
        }
        return labelMap;
    }

    private JSONObject getCompetenceStatistics(Context context2) {
        HashMap<String, HashMap> CompDefToCount = new HashMap<String, HashMap>();
        PrincipalManager pm = this.getPM();
        ContextManager cm = this.getCM();
        List users = pm.getUsers();
        int nrOfUsers = users.size();
        block2: for (User user : users) {
            Model stats = user.getEntry().getRelations();
            for (Statement s : stats) {
                IRI pred = s.getPredicate();
                if (!"http://scam.sf.net/schema#aboutPerson".equals(pred.toString())) continue;
                URI resourceURI = URI.create(s.getSubject().toString());
                String contextId = Util.getContextIdFromURI((RepositoryManager)this.getRM(), (URI)resourceURI);
                Context context = cm.getContext(contextId);
                Set competenceEntries = context.getByResourceURI(resourceURI);
                Entry competenceEntry = (Entry)competenceEntries.iterator().next();
                Model graph = competenceEntry.getMetadataGraph();
                for (Statement stat : graph.filter(null, Values.iri((String)"http://scam.sf.net/schema#competencyDefinition"), (Value)((Resource)null), new Resource[0])) {
                    Value compLevel = (Value)graph.filter(stat.getSubject(), Values.iri((String)"http://scam.sf.net/schema#competenceLevel"), null, new Resource[0]).objects().iterator().next();
                    HashMap current = CompDefToCount.computeIfAbsent(stat.getObject().toString(), k -> new HashMap());
                    Integer currentInt = (Integer)current.get(compLevel.toString());
                    if (currentInt == null) {
                        currentInt = 0;
                    }
                    Integer n = currentInt;
                    currentInt = currentInt + 1;
                    current.put(compLevel.toString(), currentInt);
                }
                continue block2;
            }
        }
        JSONObject returnObject = new JSONObject(CompDefToCount);
        try {
            returnObject.put("nrOfPersons", nrOfUsers);
        }
        catch (JSONException jsone) {
            return null;
        }
        return returnObject;
    }
}

