/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.IOException;
import java.util.Map;
import org.entrystore.rest.EntryStoreApplication;
import org.entrystore.rest.auth.LoginTokenCache;
import org.entrystore.rest.auth.UserInfo;
import org.entrystore.rest.resources.BaseResource;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.Cookie;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(TokenResource.class);
    final LoginTokenCache loginTokenCache = ((EntryStoreApplication)this.getApplication()).getLoginTokenCache();

    @Get
    public Representation get() {
        if (this.getPM().currentUserIsGuest()) {
            return this.unauthorizedGET();
        }
        Cookie authTokenCookie = (Cookie)this.getRequest().getCookies().getFirst("auth_token");
        if (authTokenCookie == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return new EmptyRepresentation();
        }
        UserInfo userInfo = (UserInfo)this.loginTokenCache.getTokenValue(authTokenCookie.getValue());
        Map<String, UserInfo> loginTokens = this.loginTokenCache.getTokens(userInfo.getUserName());
        JSONObject json = new JSONObject(loginTokens);
        return new JsonRepresentation(json);
    }

    @Delete
    public void delete(Representation representation) {
        if (this.getPM().currentUserIsGuest()) {
            this.unauthorizedDELETE();
        }
        try {
            String json = representation.getText();
            JSONObject jsonObject = new JSONObject(json);
            String authToken = jsonObject.getString("token");
            this.loginTokenCache.removeToken(authToken);
        }
        catch (IOException e) {
            log.debug(e.getMessage(), (Throwable)e);
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        }
        catch (JSONException e) {
            log.debug(e.getMessage(), (Throwable)e);
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        }
    }
}

