/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.ValidatingValueFactory;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.GraphUtil;
import org.json.JSONArray;
import org.json.JSONObject;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(ValidatorResource.class);
    List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
    ValueFactory vf = new ValidatingValueFactory();

    public void doInit() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_RDF_XML);
        this.supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        this.supportedMediaTypes.add(MediaType.TEXT_RDF_N3);
        this.supportedMediaTypes.add(new MediaType(RDFFormat.TURTLE.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.TRIX.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.NTRIPLES.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.TRIG.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.JSONLD.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType("application/rdf+json"));
    }

    @Get
    public Representation represent() throws ResourceException {
        this.getResponse().setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        return new EmptyRepresentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Post
    public void acceptRepresentation(Representation r) {
        if (this.getPM().getGuestUser().getURI().equals(this.getPM().getAuthenticatedUserURI())) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            return;
        }
        MediaType mt = this.format != null ? this.format : this.getRequestEntity().getMediaType();
        String graphString = null;
        try {
            graphString = r.getText();
        }
        catch (IOException e) {
            log.warn(e.getMessage());
            this.setRepresentation(this.getResponse(), Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
            return;
        }
        if (graphString != null) {
            Model deserializedGraph = null;
            try {
                deserializedGraph = GraphUtil.deserializeGraphUnsafe(graphString, mt);
            }
            catch (IOException | RDFHandlerException | RDFParseException e) {
                this.setRepresentation(this.getResponse(), Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
                return;
            }
            if (deserializedGraph == null) {
                this.setRepresentation(this.getResponse(), Status.CLIENT_ERROR_BAD_REQUEST, "An error occured when trying to deserialize the input graph");
                return;
            }
            ArrayList<String> errors = new ArrayList<String>();
            for (Statement s : deserializedGraph) {
                this.testIRI((Value)s.getSubject(), errors);
                this.testIRI((Value)s.getPredicate(), errors);
                this.testIRI(s.getObject(), errors);
                this.testIRI((Value)s.getContext(), errors);
            }
            if (!errors.isEmpty()) {
                this.setRepresentation(this.getResponse(), Status.CLIENT_ERROR_BAD_REQUEST, errors);
                return;
            }
            Path tmpPath = null;
            try {
                tmpPath = Files.createTempDirectory("entrystore", new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error(e.getMessage());
                this.setRepresentation(this.getResponse(), Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
                return;
            }
            SailRepository repo = null;
            RepositoryConnection rc = null;
            try {
                repo = new SailRepository((Sail)new NativeStore(tmpPath.toFile()));
                repo.init();
                rc = repo.getConnection();
                rc.add((Iterable)deserializedGraph, new Resource[0]);
            }
            catch (RepositoryException e) {
                log.warn(e.getMessage());
                this.setRepresentation(this.getResponse(), Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
                return;
            }
            finally {
                try {
                    if (rc != null) {
                        rc.close();
                    }
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
                try {
                    if (repo != null) {
                        repo.shutDown();
                    }
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
                if (tmpPath != null && tmpPath.toFile().isDirectory()) {
                    try {
                        FileUtils.deleteDirectory((File)tmpPath.toFile());
                    }
                    catch (IOException e) {
                        log.error(e.getMessage());
                    }
                }
            }
        }
        this.setRepresentation(this.getResponse(), Status.SUCCESS_OK);
    }

    private void setRepresentation(Response response, Status status, List<String> errors) {
        JSONObject result = new JSONObject();
        result.put("errors", (Object)new JSONArray(errors));
        response.setEntity((Representation)new JsonRepresentation(result));
        response.setStatus(status);
    }

    private void setRepresentation(Response response, Status status, String error) {
        this.setRepresentation(response, status, Collections.singletonList(error));
    }

    private void setRepresentation(Response response, Status status) {
        this.setRepresentation(response, status, new ArrayList<String>());
    }

    private void testIRI(Value value, List<String> errors) {
        if (value != null) {
            try {
                String valStr = value.stringValue();
                if (value instanceof IRI) {
                    this.vf.createIRI(valStr);
                } else if (value instanceof Literal && (valStr.startsWith("http://") || valStr.startsWith("https://"))) {
                    this.vf.createIRI(valStr);
                }
            }
            catch (IllegalArgumentException e) {
                errors.add(e.getMessage());
            }
        }
    }
}

