/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.serializer;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.Model;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.ContextManager;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.Group;
import org.entrystore.List;
import org.entrystore.Metadata;
import org.entrystore.PrincipalManager;
import org.entrystore.Resource;
import org.entrystore.User;
import org.entrystore.impl.DataImpl;
import org.entrystore.impl.RDFResource;
import org.entrystore.impl.StringResource;
import org.entrystore.repository.util.EntryUtil;
import org.entrystore.rest.auth.UserTempLockoutCache;
import org.entrystore.rest.util.GraphUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceJsonSerializer {
    private static final Logger log = LoggerFactory.getLogger(ResourceJsonSerializer.class);
    public static final JSONObject IMMUTABLE_EMPTY_JSONOBJECT = new JSONObject(Collections.EMPTY_MAP);
    private final PrincipalManager pm;
    private final ContextManager cm;
    private final UserTempLockoutCache userTempLockoutCache;

    public ResourceJsonSerializer(PrincipalManager pm, ContextManager cm, UserTempLockoutCache userTempLockoutCache) {
        this.pm = pm;
        this.cm = cm;
        this.userTempLockoutCache = userTempLockoutCache;
    }

    public JSONObject serializeResourceGroup(Resource resource, MediaType rdfFormat) {
        JSONObject resourceObj = new JSONObject();
        if (resource instanceof Group) {
            Group group = (Group)resource;
            try {
                resourceObj.put("name", (Object)group.getName());
                JSONArray userArray = new JSONArray();
                for (User u : group.members()) {
                    JSONObject childJSON = new JSONObject();
                    childJSON.put("entryId", (Object)u.getEntry().getId());
                    childJSON.put("name", (Object)u.getName());
                    try {
                        if (u.isDisabled()) {
                            childJSON.put("disabled", true);
                        }
                    }
                    catch (AuthorizationException ae) {
                        log.debug("Not allowed to read disabled status of [{}]", (Object)u.getEntry().getEntryURI());
                    }
                    JSONObject childInfo = GraphUtil.serializeGraphToJson(u.getEntry().getGraph(), rdfFormat);
                    childJSON.accumulate("info", (Object)childInfo);
                    JSONArray rights = this.serializeRights(u.getEntry());
                    childJSON.put("rights", (Object)rights);
                    try {
                        JSONObject childMd = GraphUtil.serializeGraphToJson(u.getEntry().getLocalMetadata().getGraph(), rdfFormat);
                        childJSON.accumulate("metadata", (Object)childMd);
                    }
                    catch (AuthorizationException childMd) {
                        // empty catch block
                    }
                    Model childRelationsGraph = u.getEntry().getRelations();
                    if (childRelationsGraph != null) {
                        JSONObject childRelationObj = GraphUtil.serializeGraphToJson(childRelationsGraph, rdfFormat);
                        childJSON.accumulate("relations", (Object)childRelationObj);
                    }
                    userArray.put((Object)childJSON);
                }
                resourceObj.put("children", (Object)userArray);
            }
            catch (AuthorizationException authorizationException) {}
        } else {
            throw new IllegalArgumentException("Resource not instance of Group");
        }
        return resourceObj;
    }

    public JSONObject serializeResourceUser(Resource resource) {
        JSONObject resourceObj = new JSONObject();
        if (resource instanceof User) {
            User user = (User)resource;
            try {
                UserTempLockoutCache.UserTemporaryLockout lockedOutUser;
                String prefLang;
                resourceObj.put("name", (Object)user.getName());
                Context homeContext = user.getHomeContext();
                if (homeContext != null) {
                    resourceObj.put("homecontext", (Object)homeContext.getEntry().getId());
                }
                if ((prefLang = user.getLanguage()) != null) {
                    resourceObj.put("language", (Object)prefLang);
                }
                if (user.isDisabled()) {
                    resourceObj.put("disabled", true);
                }
                if ((lockedOutUser = this.userTempLockoutCache.getLockedOutUser(user.getName())) != null) {
                    resourceObj.put("disabledUntil", (Object)lockedOutUser.disableUntil());
                }
                JSONObject customProperties = new JSONObject();
                for (Map.Entry propEntry : user.getCustomProperties().entrySet()) {
                    customProperties.put((String)propEntry.getKey(), propEntry.getValue());
                }
                resourceObj.put("customProperties", (Object)customProperties);
            }
            catch (AuthorizationException authorizationException) {}
        } else {
            throw new IllegalArgumentException("Resource not instance of User");
        }
        return resourceObj;
    }

    public JSONObject serializeResourceList(Resource resource, ListParams params, MediaType rdfFormat) {
        JSONObject resourceObj = new JSONObject();
        if (resource instanceof List) {
            List list = (List)resource;
            int limit = Math.min(params.limit(), 100);
            int offset = Math.max(params.offset(), 0);
            try {
                JSONArray childrenArray = new JSONArray();
                int maxPos = offset + limit;
                if (limit == 0) {
                    maxPos = Integer.MAX_VALUE;
                }
                java.util.List childrenURIs = list.getChildren();
                HashSet<String> childrenIDs = new HashSet<String>();
                ArrayList<Entry> childrenEntries = new ArrayList<Entry>();
                for (URI uri : childrenURIs) {
                    String u = uri.toString();
                    String id = u.substring(u.lastIndexOf(47) + 1);
                    childrenIDs.add(id);
                    Entry childEntry = list.getEntry().getContext().get(id);
                    if (childEntry != null) {
                        childrenEntries.add(childEntry);
                        continue;
                    }
                    log.warn("Child resource [{}] in context [{}] does not exist, but is referenced by a list.", (Object)id, (Object)this.cm.getURI());
                }
                if (params.sort() != null && childrenEntries.size() < 501) {
                    String sortType;
                    Date before = new Date();
                    GraphType prioritizedGraphType = null;
                    if (params.prio() != null) {
                        prioritizedGraphType = GraphType.valueOf((String)params.prio());
                    }
                    if ("title".equalsIgnoreCase(sortType = params.sort())) {
                        EntryUtil.sortAfterTitle(childrenEntries, (String)params.lang(), (boolean)params.ascendingOrder(), (GraphType)prioritizedGraphType);
                    } else if ("modified".equalsIgnoreCase(sortType)) {
                        EntryUtil.sortAfterModificationDate(childrenEntries, (boolean)params.ascendingOrder(), (GraphType)prioritizedGraphType);
                    } else if ("created".equalsIgnoreCase(sortType)) {
                        EntryUtil.sortAfterCreationDate(childrenEntries, (boolean)params.ascendingOrder(), (GraphType)prioritizedGraphType);
                    } else if ("size".equalsIgnoreCase(sortType)) {
                        EntryUtil.sortAfterFileSize(childrenEntries, (boolean)params.ascendingOrder(), (GraphType)prioritizedGraphType);
                    }
                    long sortDuration = new Date().getTime() - before.getTime();
                    log.debug("List resource sorting took " + sortDuration + " ms");
                } else if (params.sort() != null) {
                    log.warn("Ignoring sort parameter for performance reasons because list has more than 500 children");
                }
                for (int i = offset; i < maxPos && i < childrenEntries.size(); ++i) {
                    JSONObject childJSON = new JSONObject();
                    Entry childEntry = (Entry)childrenEntries.get(i);
                    JSONArray rights = this.serializeRights(childEntry);
                    childJSON.put("rights", (Object)rights);
                    String uri = childEntry.getEntryURI().toString();
                    String entryId = uri.substring(uri.lastIndexOf(47) + 1);
                    childJSON.put("entryId", (Object)entryId);
                    GraphType childGraphType = childEntry.getGraphType();
                    EntryType childEntryType = childEntry.getEntryType();
                    if ((childGraphType == GraphType.Context || childGraphType == GraphType.SystemContext) && childEntryType == EntryType.Local) {
                        childJSON.put("name", (Object)this.cm.getName(childEntry.getResourceURI()));
                    } else if (childGraphType == GraphType.List) {
                        Resource childResource = childEntry.getResource();
                        if (childResource instanceof List) {
                            List childList = (List)childResource;
                            try {
                                childJSON.put("size", childList.getChildren().size());
                            }
                            catch (AuthorizationException authorizationException) {}
                        } else {
                            log.warn("Entry has ResourceType.List but the resource is either null or not an instance of List");
                        }
                    } else if (childGraphType == GraphType.User && childEntryType == EntryType.Local) {
                        childJSON.put("name", (Object)((User)childEntry.getResource()).getName());
                    } else if (childGraphType == GraphType.Group && childEntryType == EntryType.Local) {
                        childJSON.put("name", (Object)((Group)childEntry.getResource()).getName());
                    }
                    try {
                        Model localMetadataGraph;
                        Metadata localMetadata;
                        Model cachedExternalMetaDataGraph;
                        Metadata cachedExternalMetaData;
                        EntryType entryType = childEntry.getEntryType();
                        if ((entryType == EntryType.Reference || entryType == EntryType.LinkReference) && (cachedExternalMetaData = childEntry.getCachedExternalMetadata()) != null && (cachedExternalMetaDataGraph = cachedExternalMetaData.getGraph()) != null) {
                            JSONObject childCachedExternalMetaDataJSON = GraphUtil.serializeGraphToJson(cachedExternalMetaDataGraph, rdfFormat);
                            childJSON.accumulate("cached-external-metadata", (Object)childCachedExternalMetaDataJSON);
                        }
                        if ((entryType == EntryType.Local || entryType == EntryType.Link || entryType == EntryType.LinkReference) && (localMetadata = childEntry.getLocalMetadata()) != null && (localMetadataGraph = localMetadata.getGraph()) != null) {
                            JSONObject localMDJSON = GraphUtil.serializeGraphToJson(localMetadataGraph, rdfFormat);
                            childJSON.accumulate("metadata", (Object)localMDJSON);
                        }
                    }
                    catch (AuthorizationException entryType) {
                        // empty catch block
                    }
                    Model childEntryGraph = childEntry.getGraph();
                    JSONObject childInfo = GraphUtil.serializeGraphToJson(childEntryGraph, rdfFormat);
                    childJSON.accumulate("info", (Object)childInfo);
                    Model childRelationsGraph = childEntry.getRelations();
                    if (childRelationsGraph != null) {
                        JSONObject childRelationObj = GraphUtil.serializeGraphToJson(childRelationsGraph, rdfFormat);
                        childJSON.accumulate("relations", (Object)childRelationObj);
                    }
                    childrenArray.put((Object)childJSON);
                }
                resourceObj.put("children", (Object)childrenArray);
                resourceObj.put("size", childrenURIs.size());
                resourceObj.put("limit", limit);
                resourceObj.put("offset", offset);
                JSONArray childrenIDArray = new JSONArray();
                for (String id : childrenIDs) {
                    childrenIDArray.put((Object)id);
                }
                resourceObj.put("allUnsorted", (Object)childrenIDArray);
            }
            catch (AuthorizationException authorizationException) {}
        } else {
            throw new IllegalArgumentException("Resource not instance of List");
        }
        return resourceObj;
    }

    public JSONObject serializeResourceGraph(Resource resource, MediaType rdfFormat) {
        if (resource instanceof RDFResource) {
            RDFResource rdf = (RDFResource)resource;
            if (rdf.getGraph() != null) {
                return GraphUtil.serializeGraphToJson(rdf.getGraph(), rdfFormat);
            }
            throw new IllegalArgumentException("Graph is empty in RDFResource");
        }
        throw new IllegalArgumentException("Resource not instance of RDFResource");
    }

    public JSONObject serializeResourcePipeline(Resource resource, MediaType rdfFormat) {
        return this.serializeResourceGraph(resource, rdfFormat);
    }

    public String serializeResourceString(Resource resource) {
        if (resource instanceof StringResource) {
            StringResource string = (StringResource)resource;
            return string.getString();
        }
        throw new IllegalArgumentException("Resource not instance of StringResource");
    }

    public JSONObject serializeResourceNone(Resource resource) {
        JSONObject resourceObj = new JSONObject();
        DataImpl data = new DataImpl(resource.getEntry());
        String digest = data.readDigest();
        if (digest != null) {
            resourceObj.put("sha256", (Object)digest);
        } else {
            log.debug("Digest does not exist for [{}]", (Object)resource.getURI());
        }
        return resourceObj;
    }

    public JSONArray serializeResourceContext(Resource resource) {
        JSONArray array = new JSONArray();
        if (resource instanceof Context) {
            Context context = (Context)resource;
            Set uris = context.getEntries();
            for (URI u : uris) {
                String entryId = u.toASCIIString().substring(u.toASCIIString().lastIndexOf(47) + 1);
                array.put((Object)entryId);
            }
        } else {
            throw new IllegalArgumentException("Resource not instance of Context");
        }
        return array;
    }

    public JSONArray serializeResourceSystemContext(Resource resource) {
        return this.serializeResourceContext(resource);
    }

    public void accumulateRights(Entry entry, JSONObject jdilObj) throws JSONException {
        Set rights = this.pm.getRights(entry);
        if (rights.size() > 0) {
            for (PrincipalManager.AccessProperty ap : rights) {
                if (ap == PrincipalManager.AccessProperty.Administer) {
                    jdilObj.append("rights", (Object)"administer");
                    continue;
                }
                if (ap == PrincipalManager.AccessProperty.WriteMetadata) {
                    jdilObj.append("rights", (Object)"writemetadata");
                    continue;
                }
                if (ap == PrincipalManager.AccessProperty.WriteResource) {
                    jdilObj.append("rights", (Object)"writeresource");
                    continue;
                }
                if (ap == PrincipalManager.AccessProperty.ReadMetadata) {
                    jdilObj.append("rights", (Object)"readmetadata");
                    continue;
                }
                if (ap != PrincipalManager.AccessProperty.ReadResource) continue;
                jdilObj.append("rights", (Object)"readresource");
            }
        }
    }

    public JSONArray serializeRights(Entry entry) throws JSONException {
        JSONArray resourceObj = new JSONArray();
        Set rights = this.pm.getRights(entry);
        rights.forEach(ap -> {
            switch (ap) {
                case Administer: {
                    resourceObj.put((Object)"administer");
                    break;
                }
                case WriteMetadata: {
                    resourceObj.put((Object)"writemetadata");
                    break;
                }
                case WriteResource: {
                    resourceObj.put((Object)"writeresource");
                    break;
                }
                case ReadMetadata: {
                    resourceObj.put((Object)"readmetadata");
                    break;
                }
                case ReadResource: {
                    resourceObj.put((Object)"readresource");
                }
            }
        });
        return resourceObj;
    }

    public record ListParams(String sort, String lang, String prio, String desc, boolean ascendingOrder, int offset, int limit) {
        public ListParams(Map<String, String> params) {
            this(params.get("sort"), params.get("lang"), params.get("prio"), params.get("desc"), !"desc".equalsIgnoreCase(params.get("order")), Integer.parseInt(params.getOrDefault("offset", "0")), Integer.parseInt(params.getOrDefault("limit", "0")));
        }
    }
}

