/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.util;

import com.google.common.base.Charsets;
import com.google.common.html.HtmlEscapers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Calendar;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.IOUtils;
import org.entrystore.Entry;
import org.entrystore.User;
import org.entrystore.config.Config;
import org.entrystore.repository.config.ConfigurationManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.util.EntryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Email {
    private static final Logger log = LoggerFactory.getLogger(Email.class);
    private static String messageBodySignup;
    private static String messageBodyPasswordReset;
    private static String messageBodyPasswordChanged;

    public static boolean sendMessage(Config config, String msgTo, String msgSubject, String msgBody) {
        return Email.sendMessage(config, msgTo, msgSubject, msgBody, null, null);
    }

    public static boolean sendMessage(Config config, String msgTo, String msgSubject, String msgBody, String msgFrom, String msgReplyTo) {
        Session session;
        String msgBcc;
        if ((msgFrom == null || msgFrom.isEmpty()) && (msgFrom = config.getString(Settings.SMTP_EMAIL_FROM)) == null) {
            msgFrom = config.getString(Settings.AUTH_FROM_EMAIL_DEPRECATED);
        }
        if ((msgBcc = config.getString(Settings.SMTP_EMAIL_BCC)) == null) {
            msgBcc = config.getString(Settings.AUTH_BCC_EMAIL_DEPRECATED);
        }
        if (msgReplyTo == null || msgReplyTo.isEmpty()) {
            msgReplyTo = config.getString(Settings.SMTP_EMAIL_REPLYTO);
        }
        String host = config.getString(Settings.SMTP_HOST);
        int port = config.getInt(Settings.SMTP_PORT, 25);
        boolean ssl = "ssl".equalsIgnoreCase(config.getString(Settings.SMTP_SECURITY));
        boolean starttls = "starttls".equalsIgnoreCase(config.getString(Settings.SMTP_SECURITY));
        final String username = config.getString(Settings.SMTP_USERNAME);
        final String password = config.getString(Settings.SMTP_PASSWORD);
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", (Object)port);
        if (ssl) {
            log.debug("SSL enabled");
            props.put("mail.smtp.ssl.enable", "true");
            props.put("mail.smtp.socketFactory.port", (Object)port);
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.socketFactory.fallback", "false");
        }
        if (starttls) {
            log.debug("StartTLS enabled");
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.starttls.required", "true");
        }
        props.put("mail.smtp.ssl.checkserveridentity", "true");
        props.put("mail.smtp.connectiontimeout", "5000");
        props.put("mail.smtp.timeout", "5000");
        props.put("mail.smtp.writetimeout", "5000");
        if (username != null && password != null) {
            props.put("mail.smtp.auth", "true");
            session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            });
        } else {
            session = Session.getInstance((Properties)props);
        }
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(msgFrom));
            if (msgReplyTo != null) {
                message.setReplyTo((Address[])InternetAddress.parse((String)msgReplyTo));
            }
            if (msgBcc != null) {
                message.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)msgBcc));
            }
            message.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)msgTo));
            if (msgSubject.toLowerCase().startsWith("=?utf-8?")) {
                message.setHeader("Subject", MimeUtility.fold((int)9, (String)msgSubject));
            } else {
                message.setSubject(msgSubject, "UTF-8");
            }
            message.setText(msgBody, "UTF-8", "html");
            for (int failure = 0; failure < 3; ++failure) {
                try {
                    session.getTransport();
                    Transport.send((Message)message);
                    return true;
                }
                catch (MessagingException me) {
                    log.error(me.getMessage());
                    continue;
                }
            }
        }
        catch (MessagingException e) {
            log.error(e.getMessage());
            return false;
        }
        return false;
    }

    public static boolean sendSignupConfirmation(Config config, String recipientName, String recipientEmail, String confirmationLink) {
        String subject = config.getString(Settings.SIGNUP_SUBJECT, "User sign-up request");
        String templatePath = config.getString(Settings.SIGNUP_CONFIRMATION_MESSAGE_TEMPLATE_PATH);
        if (messageBodySignup == null) {
            if (templatePath == null) {
                templatePath = new File(ConfigurationManager.getConfigurationURI((String)"email_signup.html")).getAbsolutePath();
            }
            if (templatePath != null) {
                messageBodySignup = Email.loadTemplate(templatePath);
            }
        }
        if (messageBodySignup == null) {
            log.error("Unable to load email template for sign-up confirmation");
            return false;
        }
        String messageText = messageBodySignup.replaceAll("__YEAR__", Integer.toString(Calendar.getInstance().get(1)));
        messageText = messageText.replaceAll("__DOMAIN__", URI.create(config.getString(Settings.BASE_URL)).getHost());
        if (confirmationLink != null) {
            messageText = messageText.replaceAll("__CONFIRMATION_LINK__", confirmationLink);
        }
        if (recipientName != null) {
            messageText = messageText.replaceAll("__NAME__", HtmlEscapers.htmlEscaper().escape(recipientName));
        }
        if (recipientEmail != null) {
            messageText = messageText.replaceAll("__EMAIL__", HtmlEscapers.htmlEscaper().escape(recipientEmail));
        }
        return Email.sendMessage(config, recipientEmail, subject, messageText);
    }

    public static boolean sendPasswordResetConfirmation(Config config, String recipientEmail, String confirmationLink) {
        String subject = config.getString(Settings.AUTH_PASSWORD_RESET_SUBJECT, "Password reset request");
        if (messageBodyPasswordReset == null) {
            String templatePath = config.getString(Settings.AUTH_PASSWORD_RESET_CONFIRMATION_MESSAGE_TEMPLATE_PATH);
            if (templatePath == null) {
                templatePath = new File(ConfigurationManager.getConfigurationURI((String)"email_pwreset.html")).getAbsolutePath();
            }
            if (templatePath != null) {
                messageBodyPasswordReset = Email.loadTemplate(templatePath);
            }
        }
        if (messageBodyPasswordReset == null) {
            log.error("Unable to load email template for password reset confirmation");
            return false;
        }
        String messageText = messageBodyPasswordReset.replaceAll("__YEAR__", Integer.toString(Calendar.getInstance().get(1)));
        messageText = messageText.replaceAll("__DOMAIN__", URI.create(config.getString(Settings.BASE_URL)).getHost());
        if (confirmationLink != null) {
            messageText = messageText.replaceAll("__CONFIRMATION_LINK__", confirmationLink);
        }
        if (recipientEmail != null) {
            messageText = messageText.replaceAll("__EMAIL__", HtmlEscapers.htmlEscaper().escape(recipientEmail));
        }
        return Email.sendMessage(config, recipientEmail, subject, messageText);
    }

    public static void sendPasswordChangeConfirmation(Config config, Entry userEntry) {
        String msgTo = ((User)userEntry.getResource()).getName();
        if (!msgTo.contains("@")) {
            msgTo = EntryUtil.getEmail((Entry)userEntry);
        }
        if (msgTo == null || !msgTo.contains("@")) {
            log.warn("Unable to send email, invalid email address of recipient: {}", (Object)msgTo);
            return;
        }
        if (messageBodyPasswordChanged == null) {
            String templatePath = config.getString(Settings.AUTH_PASSWORD_CHANGE_CONFIRMATION_MESSAGE_TEMPLATE_PATH);
            if (templatePath == null) {
                templatePath = new File(ConfigurationManager.getConfigurationURI((String)"email_pwchange.html")).getAbsolutePath();
            }
            messageBodyPasswordChanged = Email.loadTemplate(templatePath);
        }
        if (messageBodyPasswordChanged == null) {
            log.error("Unable to load email template for password change confirmation");
            return;
        }
        String messageText = messageBodyPasswordChanged.replaceAll("__YEAR__", Integer.toString(Calendar.getInstance().get(1)));
        messageText = messageText.replaceAll("__DOMAIN__", URI.create(config.getString(Settings.BASE_URL)).getHost());
        String msgSubject = config.getString(Settings.AUTH_PASSWORD_CHANGE_SUBJECT, "Your password has been changed");
        String recipientName = EntryUtil.getName((Entry)userEntry);
        if (recipientName == null) {
            recipientName = "";
        }
        messageText = messageText.replaceAll("__NAME__", HtmlEscapers.htmlEscaper().escape(recipientName));
        Email.sendMessage(config, msgTo, msgSubject, messageText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadTemplate(String url) {
        if (url == null) {
            return null;
        }
        log.debug("Loading template from " + url);
        InputStream is = null;
        try {
            is = url.startsWith("http://") || url.startsWith("https://") ? new URI(url).toURL().openStream() : Files.newInputStream(new File(url).toPath(), new OpenOption[0]);
            String string = IOUtils.toString((InputStream)is, (Charset)Charsets.UTF_8);
            return string;
        }
        catch (IOException | URISyntaxException e) {
            log.error(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.warn(e.getMessage());
                }
            }
        }
        return null;
    }
}

