/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.util;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.entrystore.rest.EntryStoreApplication;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.representation.Representation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    public static final String COOKIE_AUTH_TOKEN = "auth_token";
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final Client client;
    private static final String USERAGENT;

    private HttpUtil() {
    }

    public static Response getResourceFromURL(String url) {
        return HttpUtil.getResourceFromURL(url, 0, 0, 0L, null);
    }

    public static Response getResourceFromURL(String url, int loopCount, int retriesOnError, long timeBetweenRetries, List<MediaType> prefMediaType) {
        if (loopCount > 10) {
            log.warn("More than 10 redirect loops detected, aborting");
            return null;
        }
        Request request = new Request(Method.GET, url);
        if (prefMediaType == null) {
            prefMediaType = new ArrayList<MediaType>();
            prefMediaType.add(MediaType.ALL);
        }
        ArrayList<Preference> accMediaTypes = new ArrayList<Preference>();
        for (MediaType mt : prefMediaType) {
            accMediaTypes.add(new Preference((Metadata)mt));
        }
        request.getClientInfo().setAcceptedMediaTypes(accMediaTypes);
        request.getClientInfo().setAgent(USERAGENT);
        Response response = null;
        int tries = 0;
        do {
            response = client.handle(request);
            ++tries;
            if (retriesOnError <= 0 || !response.getStatus().isError()) break;
            try {
                log.info("Error when fetching <" + url + ">, retrying in " + timeBetweenRetries + " ms");
                Thread.sleep(timeBetweenRetries);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage());
            }
        } while (tries < retriesOnError);
        if (response.getStatus().isRedirection()) {
            Reference ref = response.getLocationRef();
            try {
                response.getEntity().exhaust();
            }
            catch (IOException e) {
                log.warn(e.getMessage());
            }
            response.getEntity().release();
            if (ref != null) {
                String refURL = ref.getIdentifier();
                log.debug("Request redirected from <" + url + "> to <" + refURL + ">");
                return HttpUtil.getResourceFromURL(refURL, loopCount + 1, retriesOnError, timeBetweenRetries, prefMediaType);
            }
        }
        if (response.getEntity() != null && response.getEntity().getLocationRef() != null && response.getEntity().getLocationRef().getBaseRef() == null) {
            response.getEntity().getLocationRef().setBaseRef(url.substring(0, url.lastIndexOf("/") + 1));
        }
        return response;
    }

    public static void setTimeouts(long timeout) {
        String timeoutStr = Long.toString(timeout);
        client.getContext().getParameters().set("connectTimeout", timeoutStr);
        client.getContext().getParameters().set("socketTimeout", timeoutStr);
        client.getContext().getParameters().set("readTimeout", timeoutStr);
        client.getContext().getParameters().set("socketConnectTimeoutMs", timeoutStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFirstLine(URL url) {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            String string = in.readLine();
            return string;
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        return null;
    }

    public static boolean isLargerThan(Representation r, long maxSize) {
        if (r == null || r.isEmpty()) {
            return false;
        }
        long repSize = r.getSize();
        if (repSize == -1L) {
            log.warn("Size of representation is unknown");
            return true;
        }
        return repSize > maxSize;
    }

    public static String getClientIpAddress(Request request) {
        Preconditions.checkArgument((request != null ? 1 : 0) != 0, (Object)"request must not be null");
        String s = request.getHeaders().getFirstValue("X-Forwarded-For", true, request.getClientInfo().getAddress());
        Object[] clientIpArray = StringUtils.split((String)s, (char)',');
        if (ArrayUtils.isNotEmpty((Object[])clientIpArray)) {
            return clientIpArray[0];
        }
        return null;
    }

    static {
        Context clientContext = new Context();
        client = new Client(clientContext, Arrays.asList(Protocol.HTTP, Protocol.HTTPS));
        HttpUtil.setTimeouts(10000L);
        log.debug("Initialized HTTP client");
        USERAGENT = "EntryStore/" + EntryStoreApplication.getVersion().trim() + " (" + System.getProperty("os.arch") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "; Java; " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + ")";
        log.debug("User-Agent for HTTP requests set to \"" + USERAGENT + "\"");
    }
}

