/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.util;

import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONErrorMessages {
    private static Logger log = LoggerFactory.getLogger(JSONErrorMessages.class);
    public static String errorWrongContextIDmsg = new String("{\"error\":\"The requested context ID does not exist\"}");
    public static String errorCantCreateEntry = new String("{\"error\":\"Cannot create entry\"}");
    public static String errorEntryWithGivenIDExists = new String("{\"error\":\"Entry with provided ID already exists\"}");
    public static String errorEntryNotFound = new String("{\"error\":\"Entry not found\"}");
    public static String errorResourceNotFound = new String("{\"error\":\"Resource not found\"}");
    public static String errorMetadataNotFound = new String("{\"error\":\"Metadata not found\"}");
    public static String errorCachedMetadataNotFound = new String("{\"error\":\"Cached external metadata not found\"}");
    public static String errorJSONSyntax = new String("{\"error\":\"Error in JSON syntax\"}");
    public static String errorUnknownKind = new String("{\"error\":\"Unknown kind\"}");
    public static String errorNotAContext = new String("{\"error\":\"Not a context\"}");
    public static String errorCannotSerialize = new String("{\"error\":\"Requested object cannot be serialized\"}");
    public static String errorCannotDeserialize = new String("{\"error\":\"Requested object cannot be deserialized\"}");
    public static String errorUnknownFormat = new String("{\"error\":\"Unknown requested format\"}");
    public static JSONObject errorChildExistsInList = JSONErrorMessages.constructMessage("An entry cannot be added multiple times", "IllegalListMemberDuplicate");
    public static String unauthorizedGETContext = new String("{\"error\":\"Not authorized\"}");
    public static String unauthorizedGET = new String("{\"error\":\"Not authorized\"}");
    public static String unauthorizedDELETE = new String("{\"error\":\"Not authorized\"}");
    public static String unauthorizedPOST = new String("{\"error\":\"Not authorized\"}");
    public static String unauthorizedPUT = new String("{\"error\":\"Not authorized\"}");
    public static String syndicationFormat = new String("{\"error\":\"Syndication format is not supported\"}");

    static JSONObject constructMessage(String error, String code) {
        JSONObject result = new JSONObject();
        try {
            result.put("error", (Object)error);
            result.put("code", (Object)code);
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

