/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.entrystore.repository.util.NS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFJSON {
    private static final Logger log = LoggerFactory.getLogger(RDFJSON.class);
    private static final IRI dtString = Values.iri((String)NS.xsd, (String)"string");
    private static final IRI dtLangString = Values.iri((String)NS.rdf, (String)"langString");
    private static final ValueFactory vf = SimpleValueFactory.getInstance();

    public static Model rdfJsonToGraph(JSONObject json) throws RDFParseException {
        LinkedHashModel result = new LinkedHashModel();
        HashMap<String, BNode> id2bnode = new HashMap<String, BNode>();
        try {
            Iterator subjects = json.keys();
            while (subjects.hasNext()) {
                BNode subject;
                String subjStr = (String)subjects.next();
                try {
                    if (subjStr.startsWith("_:")) {
                        if (id2bnode.containsKey(subjStr)) {
                            subject = (Resource)id2bnode.get(subjStr);
                        } else {
                            subject = vf.createBNode();
                            id2bnode.put(subjStr, subject);
                        }
                    } else {
                        subject = RDFJSON.parseAndValidateIRI(subjStr);
                    }
                }
                catch (IllegalArgumentException iae) {
                    subject = vf.createBNode();
                }
                JSONObject pObj = json.getJSONObject(subjStr);
                Iterator predicates = pObj.keys();
                while (predicates.hasNext()) {
                    String predStr = (String)predicates.next();
                    IRI predicate = RDFJSON.parseAndValidateIRI(predStr);
                    JSONArray predArr = pObj.getJSONArray(predStr);
                    for (int i = 0; i < predArr.length(); ++i) {
                        Literal object = null;
                        JSONObject obj = predArr.getJSONObject(i);
                        if (!obj.has("value")) continue;
                        String value = obj.getString("value");
                        if (!obj.has("type")) continue;
                        String type = obj.getString("type");
                        String lang = null;
                        if (obj.has("lang") && (lang = obj.getString("lang")).trim().isEmpty()) {
                            lang = null;
                        }
                        IRI datatype = null;
                        if (obj.has("datatype")) {
                            datatype = RDFJSON.parseAndValidateIRI(obj.getString("datatype"));
                        }
                        if ("literal".equals(type)) {
                            object = lang != null ? vf.createLiteral(value, lang) : (datatype != null ? vf.createLiteral(value, datatype) : vf.createLiteral(value));
                        } else if ("bnode".equals(type)) {
                            if (id2bnode.containsKey(value)) {
                                object = (Value)id2bnode.get(value);
                            } else {
                                object = vf.createBNode();
                                id2bnode.put(value, (BNode)object);
                            }
                        } else if ("uri".equals(type)) {
                            object = RDFJSON.parseAndValidateIRI(value);
                        }
                        result.add((Resource)subject, predicate, (Value)object, new Resource[0]);
                    }
                }
            }
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return result;
    }

    public static Model rdfJsonToGraph(String json) {
        try {
            return RDFJSON.rdfJsonToGraph(new JSONObject(json));
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static JSONObject getValue(Value v) {
        JSONObject valueObj = new JSONObject();
        if (v instanceof BNode && !v.stringValue().startsWith("_:")) {
            valueObj.put("value", (Object)("_:" + v.stringValue()));
        } else {
            valueObj.put("value", (Object)v.stringValue());
        }
        if (v instanceof Literal) {
            IRI dataType;
            Literal l = (Literal)v;
            valueObj.put("type", (Object)"literal");
            if (l.getLanguage().isPresent()) {
                valueObj.put("lang", l.getLanguage().get());
            } else if (l.getDatatype() != null && !(dataType = l.getDatatype()).equals((Object)dtString) && !dataType.equals((Object)dtLangString)) {
                valueObj.put("datatype", (Object)dataType.stringValue());
            }
        } else if (v instanceof BNode) {
            valueObj.put("type", (Object)"bnode");
        } else if (v instanceof IRI) {
            valueObj.put("type", (Object)"uri");
        }
        return valueObj;
    }

    public static JSONObject graphToRdfJsonObject(Model graph) {
        try {
            HashMap<Resource, HashMap<IRI, JSONArray>> struct = new HashMap<Resource, HashMap<IRI, JSONArray>>();
            for (Statement stmt : graph) {
                JSONArray values;
                Resource subject = stmt.getSubject();
                IRI predicate = stmt.getPredicate();
                Value object = stmt.getObject();
                HashMap<IRI, JSONArray> pred2values = (HashMap<IRI, JSONArray>)struct.get(subject);
                if (pred2values == null) {
                    pred2values = new HashMap<IRI, JSONArray>();
                    struct.put(subject, pred2values);
                    values = new JSONArray();
                    pred2values.put(predicate, values);
                    values.put((Object)RDFJSON.getValue(object));
                    continue;
                }
                values = pred2values.computeIfAbsent(predicate, k -> new JSONArray());
                values.put((Object)RDFJSON.getValue(object));
            }
            JSONObject result = new JSONObject();
            for (Resource subject : struct.keySet()) {
                JSONObject predicateObj = new JSONObject();
                HashMap pred2values = (HashMap)struct.get(subject);
                for (IRI predicate : pred2values.keySet()) {
                    predicateObj.put(predicate.stringValue(), pred2values.get(predicate));
                }
                if (subject instanceof BNode && !subject.stringValue().startsWith("_:")) {
                    result.put("_:" + subject.stringValue(), (Object)predicateObj);
                    continue;
                }
                result.put(subject.stringValue(), (Object)predicateObj);
            }
            return result;
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String graphToRdfJson(Model graph) {
        JSONObject obj = RDFJSON.graphToRdfJsonObject(graph);
        if (obj != null) {
            return obj.toString(2);
        }
        return null;
    }

    public static String graphToRdfJsonJackson(Model graph) {
        JsonGenerator g;
        JsonFactory f = new JsonFactory();
        StringWriter sw = new StringWriter();
        try {
            g = f.createJsonGenerator((Writer)sw);
            g.useDefaultPrettyPrinter();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        try {
            g.writeStartObject();
            HashSet<Resource> subjects = new HashSet<Resource>();
            for (Statement s1 : graph) {
                subjects.add(s1.getSubject());
            }
            for (Resource subject : subjects) {
                if (subject instanceof BNode && !subject.stringValue().startsWith("_:")) {
                    g.writeObjectFieldStart("_:" + subject.stringValue());
                } else {
                    g.writeObjectFieldStart(subject.stringValue());
                }
                HashSet<IRI> predicates = new HashSet<IRI>();
                for (Statement statement : graph.filter(subject, null, null, new Resource[0])) {
                    predicates.add(statement.getPredicate());
                }
                for (IRI predicate : predicates) {
                    g.writeArrayFieldStart(predicate.stringValue());
                    for (Statement statement : graph.filter(subject, predicate, null, new Resource[0])) {
                        Value v = statement.getObject();
                        g.writeStartObject();
                        if (v instanceof BNode && !v.stringValue().startsWith("_:")) {
                            g.writeStringField("value", "_:" + v.stringValue());
                        } else {
                            g.writeStringField("value", v.stringValue());
                        }
                        if (v instanceof Literal) {
                            Literal l = (Literal)v;
                            g.writeStringField("type", "literal");
                            if (l.getLanguage().isPresent()) {
                                g.writeStringField("lang", (String)l.getLanguage().get());
                            } else if (l.getDatatype() != null) {
                                g.writeStringField("datatype", l.getDatatype().stringValue());
                            }
                        } else if (v instanceof BNode) {
                            g.writeStringField("type", "bnode");
                        } else if (v instanceof IRI) {
                            g.writeStringField("type", "uri");
                        }
                        g.writeEndObject();
                    }
                    g.writeEndArray();
                }
                g.writeEndObject();
            }
            g.writeEndObject();
            g.close();
            return sw.toString();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static IRI parseAndValidateIRI(String iri) {
        Objects.requireNonNull(iri);
        try {
            URI uri = new URI(iri);
            if (uri.toString().endsWith(".")) {
                String messageTemplate = "Provided string \"%s\" is not a valid URI. Error: %s";
                throw new RDFParseException(String.format(messageTemplate, iri, "String ends in a period '.'"));
            }
            return vf.createIRI(iri);
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            String messageTemplate = "Provided string \"%s\" is not a valid URI. Error: %s";
            throw new RDFParseException(String.format(messageTemplate, iri, ex.getMessage()));
        }
    }
}

