/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.util;

import com.google.common.html.HtmlEscapers;
import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedOutput;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.entrystore.AuthorizationException;
import org.entrystore.Entry;
import org.entrystore.config.Config;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.util.EntryUtil;
import org.restlet.data.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Syndication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Syndication.class);
    public static final String URL_PARAM_TEMPLATE = "urltemplate";
    private static final String VAR_ENTRYID = "\\{entryid}";
    private static final String VAR_CONTEXTID = "\\{contextid}";
    private static final String VAR_ENTRYURI = "\\{entryuri}";
    private static final String VAR_RESOURCEURI = "\\{resourceuri}";

    public static String convertSyndFeedToXml(SyndFeed feed) {
        try {
            return new SyndFeedOutput().outputString(feed, true);
        }
        catch (FeedException fe) {
            log.error(fe.getMessage());
            return fe.getMessage();
        }
    }

    public static MediaType convertFeedTypeToMediaType(String feedType) {
        if (feedType != null) {
            if (feedType.startsWith("rss_")) {
                return MediaType.APPLICATION_RSS;
            }
            if (feedType.startsWith("atom_")) {
                return MediaType.APPLICATION_ATOM;
            }
        }
        return null;
    }

    public static SyndFeed createFeedFromEntries(RepositoryManager repositoryManager, List<Entry> entries, String language, int limit, String urlTemplate) {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setDescription(String.format("Syndication feed containing max %d items", limit));
        ArrayList<SyndEntryImpl> syndEntries = new ArrayList<SyndEntryImpl>();
        int limitedCount = 0;
        for (Entry entry : entries) {
            try {
                String title = EntryUtil.getTitle((Entry)entry, (String)language);
                String description = EntryUtil.getDescription((Entry)entry, (String)language);
                if (title == null && description == null) {
                    log.debug("Entry has neither title, nor description: {}", (Object)entry.getEntryURI());
                }
                SyndEntryImpl syndEntry = new SyndEntryImpl();
                syndEntry.setTitle(Objects.requireNonNullElse(title, "Missing title"));
                if (description != null) {
                    SyndContentImpl syndContentDescription = new SyndContentImpl();
                    syndContentDescription.setType("text/plain");
                    syndContentDescription.setValue(description);
                    syndEntry.setDescription((SyndContent)syndContentDescription);
                }
                syndEntry.setPublishedDate(entry.getCreationDate());
                syndEntry.setUpdatedDate(entry.getModifiedDate());
                String link = Syndication.constructSyndLinkFromUrlTemplate(repositoryManager.getConfiguration(), Objects.requireNonNullElse(urlTemplate, "default"), entry);
                if (link == null) {
                    link = entry.getResourceURI().toString();
                }
                syndEntry.setLink(link);
                URI creator = entry.getCreator();
                if (creator != null) {
                    try {
                        Entry creatorEntry = repositoryManager.getPrincipalManager().getByEntryURI(creator);
                        String creatorName = EntryUtil.getName((Entry)creatorEntry);
                        if (creatorName != null) {
                            syndEntry.setAuthor(creatorName);
                        }
                    }
                    catch (AuthorizationException ae) {
                        log.debug(ae.getMessage());
                    }
                }
                syndEntries.add(syndEntry);
            }
            catch (AuthorizationException e) {
                log.debug(e.getMessage());
                continue;
            }
            if (limitedCount++ < limit) continue;
            break;
        }
        feed.setEntries(syndEntries);
        return feed;
    }

    private static String constructSyndLinkFromUrlTemplate(Config config, String templateName, Entry entry) {
        String template = config.getString(Settings.SYNDICATION_URL_TEMPLATE + "." + templateName);
        if (template != null) {
            return template.replaceAll(VAR_ENTRYID, URLEncoder.encode(entry.getId(), StandardCharsets.UTF_8)).replaceAll(VAR_CONTEXTID, URLEncoder.encode(entry.getContext().getEntry().getId(), StandardCharsets.UTF_8)).replaceAll(VAR_ENTRYURI, URLEncoder.encode(entry.getEntryURI().toString(), StandardCharsets.UTF_8)).replaceAll(VAR_RESOURCEURI, URLEncoder.encode(entry.getResourceURI().toString(), StandardCharsets.UTF_8));
        }
        return null;
    }

    public static String sanitizeFeedTitle(String feedTitle) {
        String result = feedTitle;
        if (result != null) {
            if (result.length() > 64) {
                result = result.substring(0, 63);
            }
            result = HtmlEscapers.htmlEscaper().escape(result);
        }
        return result;
    }
}

