/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.util.jdil;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.util.Values;
import org.entrystore.rest.util.jdil.JDILParser;
import org.entrystore.rest.util.jdil.Namespaces;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDIL {
    private Namespaces namespaces;
    static Logger log = LoggerFactory.getLogger(JDIL.class);
    HashMap<String, String> globalNamespaces;

    public JDIL(Namespaces namespaces) {
        this.namespaces = namespaces;
    }

    public String getAbbr(String uri) {
        return this.namespaces.abbreviate(uri);
    }

    public Model importJDILtoGraph(JSONObject jsonObject) {
        try {
            LinkedHashModel graph = new LinkedHashModel();
            JDILParser.removeJDILStar(jsonObject);
            this.JDILtoGraph(jsonObject, (Model)graph, null, new HashMap<String, BNode>());
            return graph;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void JDILtoGraph(JSONObject jsonObject, Model graph, Resource subject, Map<String, BNode> bnodeResolver) throws JSONException {
        if (subject == null) {
            subject = Values.iri((String)this.namespaces.expand(jsonObject.getString("@id")));
        }
        Iterator keyIt = jsonObject.keys();
        while (keyIt.hasNext()) {
            String key = keyIt.next().toString();
            if (key.startsWith("@")) continue;
            IRI spred = Values.iri((String)this.namespaces.expand(key));
            Object obj = jsonObject.opt(key);
            if (obj instanceof JSONObject) {
                this.extract(graph, subject, spred, obj, bnodeResolver);
                continue;
            }
            if (obj instanceof JSONArray) {
                JSONArray array = (JSONArray)obj;
                for (int i = 0; i < array.length(); ++i) {
                    obj = array.get(i);
                    this.extract(graph, subject, spred, obj, bnodeResolver);
                }
                continue;
            }
            graph.add(subject, spred, (Value)Values.literal((String)obj.toString()), new Resource[0]);
        }
    }

    private void extract(Model graph, Resource subject, IRI spred, Object obj, Map<String, BNode> bnodeResolver) throws JSONException {
        if (((JSONObject)obj).has("@id") && !((JSONObject)obj).has("@isBlank")) {
            IRI sobj = Values.iri((String)this.namespaces.expand(((JSONObject)obj).getString("@id")));
            graph.add(subject, spred, (Value)sobj, new Resource[0]);
            this.JDILtoGraph((JSONObject)obj, graph, (Resource)sobj, bnodeResolver);
        } else if (((JSONObject)obj).has("@isBlank")) {
            String bid = ((JSONObject)obj).getString("@id");
            BNode sobj = null;
            if (bid == null) {
                sobj = Values.bnode();
            } else if (bnodeResolver.containsKey(bid)) {
                sobj = bnodeResolver.get(bid);
            } else {
                sobj = Values.bnode();
                bnodeResolver.put(bid, sobj);
            }
            graph.add(subject, spred, (Value)sobj, new Resource[0]);
            this.JDILtoGraph((JSONObject)obj, graph, (Resource)sobj, bnodeResolver);
        } else {
            this.exportLiteral((JSONObject)obj, graph, subject, spred);
        }
    }

    private void exportLiteral(JSONObject obj, Model graph, Resource subject, IRI predicate) {
        Object objVal = obj.opt("@value");
        Object objLang = obj.opt("@language");
        Object objType = obj.opt("@datatype");
        if (objLang != null) {
            graph.add(subject, predicate, (Value)Values.literal((String)((String)objVal), (String)((String)objLang)), new Resource[0]);
        } else if (objType != null) {
            graph.add(subject, predicate, (Value)Values.literal((String)((String)objVal), (IRI)Values.iri((String)this.namespaces.expand((String)objType))), new Resource[0]);
        } else {
            graph.add(subject, predicate, (Value)Values.literal((String)((String)objVal)), new Resource[0]);
        }
    }

    public JSONObject exportRelationGraphToJSON(Model graph) {
        JSONObject result = new JSONObject();
        for (Statement statement : graph) {
            String obj = this.namespaces.abbreviate(statement.getObject().stringValue());
            String subj = this.namespaces.abbreviate(statement.getSubject().stringValue());
            String pred = this.namespaces.abbreviate(statement.getPredicate().stringValue());
            JSONObject objJSON = null;
            try {
                objJSON = result.getJSONObject(obj);
            }
            catch (JSONException e) {
                objJSON = new JSONObject();
                try {
                    result.put(obj, (Object)objJSON);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            try {
                objJSON.append(subj, (Object)pred);
            }
            catch (JSONException jSONException) {}
        }
        return result;
    }

    public JSONObject exportGraphToJDIL(Model graph, Resource root) {
        try {
            HashMap<Resource, JSONObject> res2Jdil = new HashMap<Resource, JSONObject>();
            HashSet<Object> notRoots = new HashSet<Object>();
            for (Statement statement : graph) {
                JSONObject subj = this.getOrCreateSubject(statement.getSubject(), res2Jdil);
                String predicate = this.namespaces.abbreviate(statement.getPredicate().stringValue());
                notRoots.add(statement.getPredicate());
                Value value = statement.getObject();
                if (value instanceof Resource) {
                    JSONObject JDILValueObject = this.getOrCreateObject((Resource)value, res2Jdil);
                    subj.accumulate(predicate, (Object)JDILValueObject);
                    notRoots.add((Resource)value);
                    continue;
                }
                Literal lit = (Literal)value;
                String language = lit.getLanguage().orElse(null);
                IRI datatype = lit.getDatatype();
                JSONObject object = new JSONObject();
                object.accumulate("@value", (Object)value.stringValue());
                if (language != null) {
                    object.accumulate("@language", (Object)language);
                } else if (datatype != null) {
                    object.accumulate("@datatype", (Object)datatype.stringValue());
                }
                subj.accumulate(predicate, (Object)object);
            }
            if (root != null) {
                JSONObject obj = (JSONObject)res2Jdil.get(root);
                this.cutLoops(obj, new HashSet());
                return obj;
            }
            HashSet roots = new HashSet(res2Jdil.keySet());
            roots.removeAll(notRoots);
            if (roots.size() == 1) {
                JSONObject obj = res2Jdil.get(roots.iterator().next());
                this.cutLoops(obj, new HashSet());
                return obj;
            }
        }
        catch (JSONException jse) {
            log.error(jse.getMessage());
        }
        return null;
    }

    void cutLoops(JSONObject obj, HashSet above) {
        if (obj == null) {
            return;
        }
        above.add(obj);
        Iterator it = obj.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object child = obj.opt(key);
            if (child instanceof JSONObject) {
                if (above.contains(child)) {
                    try {
                        JSONObject newChild = new JSONObject();
                        if (((JSONObject)child).has("@id")) {
                            newChild.put("@id", ((JSONObject)child).opt("@id"));
                        }
                        if (((JSONObject)child).has("@isBlank")) {
                            newChild.put("@isBlank", ((JSONObject)child).opt("@isBlank"));
                        }
                        obj.put(key, (Object)newChild);
                    }
                    catch (JSONException newChild) {}
                    continue;
                }
                this.cutLoops((JSONObject)child, above);
                continue;
            }
            if (!(child instanceof JSONArray)) continue;
            JSONArray arr = (JSONArray)child;
            for (int i = 0; i < arr.length(); ++i) {
                try {
                    Object arrChild = arr.get(i);
                    if (!(arrChild instanceof JSONObject)) continue;
                    if (above.contains(arrChild)) {
                        JSONObject newChild = new JSONObject();
                        if (((JSONObject)arrChild).opt("@id") != null) {
                            newChild.put("@id", ((JSONObject)arrChild).opt("@id"));
                        } else {
                            newChild.put("@bid", ((JSONObject)arrChild).opt("@bid"));
                        }
                        arr.put(i, (Object)newChild);
                        continue;
                    }
                    this.cutLoops((JSONObject)arrChild, above);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    JSONObject getOrCreateSubject(Resource resource, Map<Resource, JSONObject> res2Jdil) throws JSONException {
        JSONObject jdil = res2Jdil.get(resource);
        if (jdil == null) {
            jdil = new JSONObject();
            if (resource instanceof BNode) {
                jdil.accumulate("@id", (Object)resource.stringValue());
                jdil.accumulate("@isBlank", (Object)true);
            } else {
                jdil.accumulate("@id", (Object)this.namespaces.abbreviate(resource.stringValue()));
            }
            res2Jdil.put(resource, jdil);
        }
        return jdil;
    }

    JSONObject getOrCreateObject(Resource resource, Map<Resource, JSONObject> res2Jdil) throws JSONException {
        JSONObject jdil = new JSONObject();
        if (resource instanceof BNode) {
            jdil.accumulate("@id", (Object)resource.stringValue());
            jdil.accumulate("@isBlank", (Object)true);
        } else {
            jdil.accumulate("@id", (Object)this.namespaces.abbreviate(resource.stringValue()));
        }
        if (res2Jdil.get(resource) == null) {
            res2Jdil.put(resource, jdil);
        } else {
            jdil = res2Jdil.get(resource);
        }
        return jdil;
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }
}

