/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.util.jdil;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.entrystore.rest.util.jdil.JDILException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;

public class JDILParser {
    public static Map<String, String> extractNamespaces(JSONObject json, Map<String, String> namespaces) throws JDILException {
        HashMap<String, String> newNamespaces = new HashMap<String, String>();
        for (String key : namespaces.keySet()) {
            newNamespaces.put(key, namespaces.get(key));
        }
        if (json.has("@namespaces")) {
            Object jsonNamespaces = json.opt("@namespaces");
            if (jsonNamespaces instanceof String) {
                String nsObj;
                String nsURI = (String)jsonNamespaces;
                try {
                    nsObj = JDILParser.getURIContentAsText(nsURI);
                }
                catch (Exception exc) {
                    throw new JDILException("Failed to GET namespaces from URI " + nsURI + ": " + exc.getMessage());
                }
                try {
                    jsonNamespaces = new JSONObject(nsObj);
                }
                catch (JSONException exc) {
                    throw new JDILException("Content of URI " + nsURI + " supposed to contain namespace definitions is an invalid JSON object: " + exc.getMessage());
                }
            }
            if (jsonNamespaces instanceof JSONObject) {
                Iterator jsonNsIt = ((JSONObject)jsonNamespaces).keys();
                while (jsonNsIt.hasNext()) {
                    String key = (String)jsonNsIt.next();
                    Object o = ((JSONObject)jsonNamespaces).opt(key);
                    if (o instanceof String) {
                        newNamespaces.put(key, (String)o);
                        continue;
                    }
                    throw new JDILException("Expected JSON string as value of namespace " + key + ", got " + ((JSONObject)jsonNamespaces).opt(key).toString());
                }
            } else {
                throw new JDILException("Expected JSON object or URI for @namespaces, got " + jsonNamespaces.toString());
            }
        }
        return newNamespaces;
    }

    public static void removeJDILStar(JSONObject json) {
        String key;
        Iterator keyIt;
        HashSet<String> modifiedKeys = new HashSet<String>();
        Boolean noStars = false;
        block2: while (!noStars.booleanValue()) {
            noStars = true;
            keyIt = json.keys();
            while (keyIt.hasNext()) {
                key = (String)keyIt.next();
                if (modifiedKeys.contains(key) || !key.startsWith("*")) continue;
                noStars = false;
                Object id = json.opt(key);
                json.remove(key);
                JSONObject newObj = new JSONObject();
                key = key.substring(1);
                modifiedKeys.add(key);
                try {
                    newObj.put("@id", id);
                    json.put(key, (Object)newObj);
                }
                catch (JSONException jSONException) {}
                continue block2;
            }
        }
        keyIt = json.keys();
        while (keyIt.hasNext()) {
            key = (String)keyIt.next();
            Object val = json.opt(key);
            if (val instanceof JSONObject) {
                JDILParser.removeJDILStar((JSONObject)val);
                continue;
            }
            if (!(val instanceof JSONArray)) continue;
            JDILParser.removeJDILStar((JSONArray)val);
        }
    }

    public static void removeJDILStar(JSONArray json) {
        for (int i = 0; i < json.length(); ++i) {
            Object val = json.opt(i);
            if (val instanceof JSONObject) {
                JDILParser.removeJDILStar((JSONObject)val);
                continue;
            }
            if (!(val instanceof JSONArray)) continue;
            JDILParser.removeJDILStar((JSONArray)val);
        }
    }

    public static String expandURIString(String uri, Map<String, String> namespaces) {
        if (uri.indexOf(":") != -1) {
            String shortns = uri.substring(0, uri.indexOf(":"));
            if (namespaces.keySet().contains(shortns)) {
                String longns = new String(namespaces.get(shortns));
                return longns.concat(uri.substring(uri.indexOf(":") + 1));
            }
        }
        return uri;
    }

    private static String getURIContentAsText(String URIString) throws JDILException, IOException, URISyntaxException {
        String scheme = new URI(URIString).getScheme();
        if (scheme == null) {
            throw new JDILException("No scheme given in URI " + URIString);
        }
        Client client = new Client(new Protocol(scheme));
        Request request = new Request(Method.GET, URIString);
        Response response = client.handle(request);
        if (response.getStatus().equals((Object)Status.SUCCESS_OK) && response.isEntityAvailable()) {
            return response.getEntity().getText();
        }
        throw new JDILException("Unable to GET URI " + URIString);
    }

    public static JSONObject expandJDILObject(JSONObject jdil, URIDetector uriDetector) throws JDILException {
        JSONObject jdilCopy = null;
        try {
            jdilCopy = new JSONObject(jdil.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        JDILParser.removeJDILStar(jdilCopy);
        return JDILParser.expandJDILObjectWithoutStar(jdilCopy, new HashMap<String, String>(), new HashMap<String, JSONObject>(), uriDetector);
    }

    public static JSONArray expandJDILArray(JSONArray jdil, URIDetector uriDetector) throws JDILException {
        JSONArray jdilCopy = null;
        try {
            jdilCopy = new JSONArray(jdil.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        JDILParser.removeJDILStar(jdilCopy);
        return JDILParser.expandJDILArrayWithoutStar(jdilCopy, new HashMap<String, String>(), new HashMap<String, JSONObject>(), uriDetector);
    }

    private static JSONObject expandJDILObjectWithoutStar(JSONObject jdil, Map<String, String> namespaces, Map<String, JSONObject> namedJdilObjects, URIDetector uriDetector) throws JDILException {
        JSONObject jdilCopy;
        Map<String, String> newNamespaces = JDILParser.extractNamespaces(jdil, namespaces);
        try {
            jdilCopy = new JSONObject(jdil.toString());
        }
        catch (JSONException exc) {
            jdilCopy = new JSONObject();
        }
        Iterator keyIt = jdilCopy.keys();
        while (keyIt.hasNext()) {
            String key = (String)keyIt.next();
            Object val = jdilCopy.opt(key);
            try {
                if (val instanceof JSONObject) {
                    jdilCopy.put(key, (Object)JDILParser.expandJDILObjectWithoutStar((JSONObject)val, newNamespaces, namedJdilObjects, uriDetector));
                    continue;
                }
                if (val instanceof JSONArray) {
                    jdilCopy.put(key, (Object)JDILParser.expandJDILArrayWithoutStar((JSONArray)val, newNamespaces, namedJdilObjects, uriDetector));
                    continue;
                }
                if (!(val instanceof String) || !uriDetector.hasURIValue(key, jdilCopy).booleanValue()) continue;
                jdilCopy.put(key, (Object)JDILParser.expandURIString((String)val, newNamespaces));
            }
            catch (JSONException jSONException) {}
        }
        if (jdilCopy.has("@id")) {
            Object id = jdilCopy.opt("@id");
            if (id instanceof String) {
                try {
                    jdilCopy.put("@id", (Object)JDILParser.expandURIString((String)id, newNamespaces));
                }
                catch (JSONException val) {
                    // empty catch block
                }
                if (namedJdilObjects.keySet().contains(jdilCopy.opt("@id"))) {
                    JSONObject tmp = jdilCopy;
                    jdilCopy = namedJdilObjects.get(jdilCopy.opt("@id"));
                    keyIt = tmp.keys();
                    while (keyIt.hasNext()) {
                        String key = (String)keyIt.next();
                        if (jdilCopy.has(key)) {
                            if (jdilCopy.opt(key).equals(tmp.opt(key))) continue;
                            throw new JDILException("Colliding definitions of " + key + " value in object " + (String)id + ". Both " + jdilCopy.opt(key).toString() + " and " + String.valueOf(tmp.opt(key)) + ".");
                        }
                        try {
                            jdilCopy.put(key, tmp.get(key));
                        }
                        catch (JSONException jSONException) {}
                    }
                } else {
                    namedJdilObjects.put(jdilCopy.opt("@id").toString(), jdilCopy);
                }
            } else {
                throw new JDILException("Expected URI for @id, got " + id.toString());
            }
        }
        jdilCopy.remove("@namespaces");
        return jdilCopy;
    }

    private static JSONArray expandJDILArrayWithoutStar(JSONArray jdil, Map<String, String> namespaces, Map<String, JSONObject> namedJdilObjects, URIDetector uriDetector) throws JDILException {
        JSONArray copy = new JSONArray();
        for (int i = 0; i < jdil.length(); ++i) {
            try {
                Object obj = jdil.get(i);
                if (obj instanceof JSONObject) {
                    copy.put(i, (Object)JDILParser.expandJDILObjectWithoutStar((JSONObject)obj, namespaces, namedJdilObjects, uriDetector));
                    continue;
                }
                if (obj instanceof JSONArray) {
                    copy.put(i, (Object)JDILParser.expandJDILArrayWithoutStar((JSONArray)obj, namespaces, namedJdilObjects, uriDetector));
                    continue;
                }
                copy.put(i, obj);
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return copy;
    }

    public static Boolean hasLoops(JSONObject jdil) {
        return JDILParser.hasLoops(jdil, new HashSet<String>());
    }

    private static Boolean hasLoops(JSONObject jdil, HashSet<String> ancestors) {
        Object tmpObj = null;
        String id = null;
        Boolean hasLoop = false;
        if (jdil.has("@id") && (tmpObj = jdil.opt("@id")) instanceof String) {
            id = (String)tmpObj;
            if (ancestors.contains(id)) {
                return true;
            }
            ancestors.add(id);
        }
        Iterator keyIt = jdil.keys();
        while (keyIt.hasNext()) {
            String key = (String)keyIt.next();
            tmpObj = jdil.opt(key);
            if (tmpObj instanceof JSONObject) {
                if (!JDILParser.hasLoops((JSONObject)tmpObj, ancestors).booleanValue()) continue;
                hasLoop = true;
                break;
            }
            if (!(tmpObj instanceof JSONArray) || !JDILParser.hasLoops((JSONArray)tmpObj, ancestors).booleanValue()) continue;
            hasLoop = true;
            break;
        }
        if (id != null) {
            ancestors.remove(id);
        }
        return hasLoop;
    }

    private static Boolean hasLoops(JSONArray jdil, HashSet<String> ancestors) {
        Boolean hasLoop = false;
        for (int i = 0; i < jdil.length(); ++i) {
            Object tmpObj = jdil.opt(i);
            if (tmpObj instanceof JSONObject) {
                if (!JDILParser.hasLoops((JSONObject)tmpObj, ancestors).booleanValue()) continue;
                hasLoop = true;
                break;
            }
            if (!(tmpObj instanceof JSONArray) || !JDILParser.hasLoops((JSONArray)tmpObj, ancestors).booleanValue()) continue;
            hasLoop = true;
            break;
        }
        return hasLoop;
    }

    public static interface URIDetector {
        public Boolean hasURIValue(String var1, JSONObject var2);
    }
}

