/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene92;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene92.OffHeapVectorValues;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.RandomAccessVectorValuesProducer;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.packed.DirectMonotonicWriter;

public final class Lucene92HnswVectorsWriter
extends KnnVectorsWriter {
    private final SegmentWriteState segmentWriteState;
    private final IndexOutput meta;
    private final IndexOutput vectorData;
    private final IndexOutput vectorIndex;
    private final int maxDoc;
    private final int M;
    private final int beamWidth;
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene92HnswVectorsWriter(SegmentWriteState state, int M, int beamWidth) throws IOException {
        this.M = M;
        this.beamWidth = beamWidth;
        assert (state.fieldInfos.hasVectorValues());
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vem");
        String vectorDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vec");
        String indexDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vex");
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.vectorData = state.directory.createOutput(vectorDataFileName, state.context);
            this.vectorIndex = state.directory.createOutput(indexDataFileName, state.context);
            CodecUtil.writeIndexHeader(this.meta, "lucene92HnswVectorsFormatMeta", 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorData, "lucene92HnswVectorsFormatData", 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorIndex, "lucene92HnswVectorsFormatIndex", 0, state.segmentInfo.getId(), state.segmentSuffix);
            this.maxDoc = state.segmentInfo.maxDoc();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeField(FieldInfo fieldInfo, KnnVectorsReader knnVectorsReader) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        VectorValues vectors = knnVectorsReader.getVectorValues(fieldInfo.name);
        IndexOutput tempVectorData = this.segmentWriteState.directory.createTempOutput(this.vectorData.getName(), "temp", this.segmentWriteState.context);
        IndexInput vectorDataInput = null;
        boolean success = false;
        try {
            DocsWithFieldSet docsWithField = Lucene92HnswVectorsWriter.writeVectorData(tempVectorData, vectors);
            CodecUtil.writeFooter(tempVectorData);
            IOUtils.close(tempVectorData);
            vectorDataInput = this.segmentWriteState.directory.openInput(tempVectorData.getName(), this.segmentWriteState.context);
            this.vectorData.copyBytes(vectorDataInput, vectorDataInput.length() - (long)CodecUtil.footerLength());
            CodecUtil.retrieveChecksum(vectorDataInput);
            long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
            long vectorIndexOffset = this.vectorIndex.getFilePointer();
            OffHeapVectorValues.DenseOffHeapVectorValues offHeapVectors = new OffHeapVectorValues.DenseOffHeapVectorValues(vectors.dimension(), docsWithField.cardinality(), vectorDataInput);
            OnHeapHnswGraph graph = offHeapVectors.size() == 0 ? null : this.writeGraph(offHeapVectors, fieldInfo.getVectorSimilarityFunction());
            long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
            this.writeMeta(fieldInfo, vectorDataOffset, vectorDataLength, vectorIndexOffset, vectorIndexLength, docsWithField, graph);
            success = true;
        }
        catch (Throwable throwable) {
            IOUtils.close(vectorDataInput);
            if (success) {
                this.segmentWriteState.directory.deleteFile(tempVectorData.getName());
            } else {
                IOUtils.closeWhileHandlingException(tempVectorData);
                IOUtils.deleteFilesIgnoringExceptions(this.segmentWriteState.directory, tempVectorData.getName());
            }
            throw throwable;
        }
        IOUtils.close(vectorDataInput);
        if (success) {
            this.segmentWriteState.directory.deleteFile(tempVectorData.getName());
        } else {
            IOUtils.closeWhileHandlingException(tempVectorData);
            IOUtils.deleteFilesIgnoringExceptions(this.segmentWriteState.directory, tempVectorData.getName());
        }
    }

    private static DocsWithFieldSet writeVectorData(IndexOutput output, VectorValues vectors) throws IOException {
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        int docV = vectors.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            BytesRef binaryValue = vectors.binaryValue();
            assert (binaryValue.length == vectors.dimension() * 4);
            output.writeBytes(binaryValue.bytes, binaryValue.offset, binaryValue.length);
            docsWithField.add(docV);
            docV = vectors.nextDoc();
        }
        return docsWithField;
    }

    private void writeMeta(FieldInfo field, long vectorDataOffset, long vectorDataLength, long vectorIndexOffset, long vectorIndexLength, DocsWithFieldSet docsWithField, OnHeapHnswGraph graph) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVLong(vectorDataOffset);
        this.meta.writeVLong(vectorDataLength);
        this.meta.writeVLong(vectorIndexOffset);
        this.meta.writeVLong(vectorIndexLength);
        this.meta.writeInt(field.getVectorDimension());
        int count = docsWithField.cardinality();
        this.meta.writeInt(count);
        if (count == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else if (count == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else {
            long offset = this.vectorData.getFilePointer();
            this.meta.writeLong(offset);
            short jumpTableEntryCount = IndexedDISI.writeBitSet(docsWithField.iterator(), this.vectorData, (byte)9);
            this.meta.writeLong(this.vectorData.getFilePointer() - offset);
            this.meta.writeShort(jumpTableEntryCount);
            this.meta.writeByte((byte)9);
            long start = this.vectorData.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter ordToDocWriter = DirectMonotonicWriter.getInstance(this.meta, this.vectorData, count, 16);
            DocIdSetIterator iterator = docsWithField.iterator();
            int doc = iterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                ordToDocWriter.add(doc);
                doc = iterator.nextDoc();
            }
            ordToDocWriter.finish();
            this.meta.writeLong(this.vectorData.getFilePointer() - start);
        }
        this.meta.writeInt(this.M);
        if (graph == null) {
            this.meta.writeInt(0);
        } else {
            this.meta.writeInt(graph.numLevels());
            for (int level = 0; level < graph.numLevels(); ++level) {
                HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
                this.meta.writeInt(nodesOnLevel.size());
                if (level <= 0) continue;
                while (nodesOnLevel.hasNext()) {
                    int node = nodesOnLevel.nextInt();
                    this.meta.writeInt(node);
                }
            }
        }
    }

    private OnHeapHnswGraph writeGraph(RandomAccessVectorValuesProducer vectorValues, VectorSimilarityFunction similarityFunction) throws IOException {
        HnswGraphBuilder hnswGraphBuilder = new HnswGraphBuilder(vectorValues, similarityFunction, this.M, this.beamWidth, HnswGraphBuilder.randSeed);
        hnswGraphBuilder.setInfoStream(this.segmentWriteState.infoStream);
        OnHeapHnswGraph graph = hnswGraphBuilder.build(vectorValues.randomAccess());
        int countOnLevel0 = graph.size();
        for (int level = 0; level < graph.numLevels(); ++level) {
            int maxConnOnLevel = level == 0 ? this.M * 2 : this.M;
            HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
            while (nodesOnLevel.hasNext()) {
                int i;
                int node = nodesOnLevel.nextInt();
                NeighborArray neighbors = graph.getNeighbors(level, node);
                int size = neighbors.size();
                this.vectorIndex.writeInt(size);
                int[] nnodes = neighbors.node();
                Arrays.sort(nnodes, 0, size);
                for (i = 0; i < size; ++i) {
                    int nnode = nnodes[i];
                    assert (nnode < countOnLevel0) : "node too large: " + nnode + ">=" + countOnLevel0;
                    this.vectorIndex.writeInt(nnode);
                }
                for (i = size; i < maxConnOnLevel; ++i) {
                    this.vectorIndex.writeInt(0);
                }
            }
        }
        return graph;
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter(this.meta);
        }
        if (this.vectorData != null) {
            CodecUtil.writeFooter(this.vectorData);
            CodecUtil.writeFooter(this.vectorIndex);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.meta, this.vectorData, this.vectorIndex);
    }
}

