/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.standalone;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PatternOptionBuilder;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.entrystore.rest.EntryStoreApplication;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntryStoreApplicationStandalone
extends Application {
    private static final Logger log = LoggerFactory.getLogger(EntryStoreApplicationStandalone.class);
    private static EntryStoreApplication entryStoreAppInstance = null;
    public static String ENV_CONFIG_PROPERTIES = "ENTRYSTORE_CONFIG_PROPERTIES";
    public static String ENV_CONNECTOR_PARAMS = "ENTRYSTORE_CONNECTOR_PARAMS";

    public static void main(String[] args) {
        EntryStoreApplication esApp;
        System.setProperty("org.restlet.engine.loggerFacadeClass", "org.restlet.ext.slf4j.Slf4jLoggerFacade");
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption(Option.builder((String)"c").longOpt("config").required(System.getenv("ENTRYSTORE_CONFIG_URI") == null).desc("URL of configuration file, may be omitted if environment variable ENTRYSTORE_CONFIG_URI is set").hasArg().argName("URL").type(PatternOptionBuilder.URL_VALUE).build());
        options.addOption(Option.builder((String)"p").longOpt("port").desc("port to listen on; default: 8181").hasArg().argName("PORT").type(PatternOptionBuilder.NUMBER_VALUE).build());
        options.addOption(Option.builder((String)"l").longOpt("log-level").desc("log level for root level (excludes Solr and Jetty), one of: ALL, TRACE, DEBUG, INFO, WARN, ERROR, FATAL, OFF; default: INFO").hasArg().argName("LEVEL").build());
        options.addOption(Option.builder().longOpt("log-level-all").desc("log level for all levels (including Solr and Jetty), overrides \"--log-level\",  one of: ALL, TRACE, DEBUG, INFO, WARN, ERROR, FATAL, OFF; default: INFO").hasArg().argName("LEVEL").build());
        options.addOption(Option.builder().longOpt("config-properties").desc("comma separated list of configuration properties (key/value pairs) to be used on top of the regular configuration file, overrides existing properties in configuration, the environment variable ENTRYSTORE_CONFIG_PROPERTIES may be used instead.\nExample for changing base URI: \"entrystore.baseurl.folder=http://localhost:8585/store/\"").hasArg().argName("PROPERTIES").build());
        options.addOption(Option.builder().longOpt("connector-params").desc("comma separated list of parameters (key/value pairs) to be used for the server connector, the environment variable ENTRYSTORE_CONNECTOR_PARAMS may be used instead.\nExample for Jetty: \"threadPool.minThreads=50,threadPool.maxThreads=250\"; see the JavaDoc of JettyServerHelper for available parameters").hasArg().argName("SETTINGS").build());
        options.addOption(Option.builder((String)"h").longOpt("help").desc("display this help").build());
        CommandLine cl = null;
        try {
            cl = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage() + "\n");
            EntryStoreApplicationStandalone.printHelp(options);
            System.exit(1);
        }
        if (cl.hasOption("help")) {
            EntryStoreApplicationStandalone.printHelp(options);
            System.exit(0);
        }
        String strPort = cl.getOptionValue("p", "8181");
        int port = 8181;
        try {
            port = Integer.parseInt(strPort);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Invalid port number, must be integer: " + strPort + "\n");
            EntryStoreApplicationStandalone.printHelp(options);
            System.exit(1);
        }
        URI config = null;
        try {
            config = cl.hasOption("c") ? new URI(cl.getOptionValue("c")) : new URI(System.getenv("ENTRYSTORE_CONFIG_URI"));
        }
        catch (URISyntaxException e) {
            System.err.println("Invalid configuration URL: " + e.getMessage() + "\n");
            EntryStoreApplicationStandalone.printHelp(options);
            System.exit(1);
        }
        EntryStoreApplicationStandalone.configureLogging(cl.getOptionValue("log-level", "INFO"), cl.getOptionValue("log-level-all"));
        Component component = new Component();
        Server server = component.getServers().add(Protocol.HTTP, port);
        String conParams = cl.hasOption("connector-params") ? cl.getOptionValue("connector-params") : System.getenv(ENV_CONNECTOR_PARAMS);
        if (conParams != null) {
            for (String param : conParams.split(",")) {
                if (param.isEmpty()) continue;
                String[] kv = param.split("=");
                if (kv.length == 2) {
                    log.debug("Adding connector parameter: {}={}", (Object)kv[0], (Object)kv[1]);
                    server.getContext().getParameters().add(kv[0].trim(), kv[1].trim());
                    continue;
                }
                log.error("Invalid connector parameter: {}", (Object)param);
                System.exit(1);
            }
        }
        String configParams = cl.hasOption("config-properties") ? cl.getOptionValue("config-properties") : System.getenv(ENV_CONFIG_PROPERTIES);
        HashMap<String, String> configOverride = new HashMap<String, String>();
        if (configParams != null) {
            for (String param : configParams.split(",")) {
                if (param.isEmpty()) continue;
                String[] kv = param.split("=");
                if (kv.length == 2) {
                    log.debug("Adding config parameter: {}={}", (Object)kv[0], (Object)kv[1]);
                    configOverride.put(kv[0].trim(), kv[1].trim());
                    continue;
                }
                log.error("Invalid config parameter: {}", (Object)param);
                System.exit(1);
            }
        }
        component.getLogService().setResponseLogFormat("{ciua} \"{m} {rp} {rq}\" {S} {ES} {es} {hh} {cig} {fi}");
        component.getClients().add(Protocol.FILE);
        component.getClients().add(Protocol.HTTP);
        component.getClients().add(Protocol.HTTPS);
        server.getContext().getParameters().add("useForwardedForHeader", "true");
        Context childContext = component.getContext().createChildContext();
        entryStoreAppInstance = esApp = new EntryStoreApplication(config, configOverride, childContext, component);
        childContext.getAttributes().put(EntryStoreApplication.KEY, esApp);
        component.getDefaultHost().attach((Restlet)esApp);
        try {
            component.start();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(100);
        formatter.setLeftPadding(2);
        formatter.printHelp("entrystore", options, true);
    }

    private static void out(String s) {
        System.out.println(s);
    }

    private static void configureLogging(String rootLevel, String allLevels) {
        Level lRoot = Level.toLevel((String)rootLevel, (Level)Level.INFO);
        Configurator.setRootLevel((Level)lRoot);
        EntryStoreApplicationStandalone.out("Root log level set to " + String.valueOf(lRoot));
        if (allLevels != null) {
            Level lAll = Level.toLevel((String)allLevels, (Level)Level.INFO);
            Configurator.setAllLevels((String)LogManager.getRootLogger().getName(), (Level)lAll);
        }
    }

    public static EntryStoreApplication getInstance() {
        return entryStoreAppInstance;
    }
}

