/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.transforms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.entrystore.Entry;
import org.entrystore.transforms.Pipeline;
import org.entrystore.transforms.TransformException;

public abstract class Transform
implements Comparable<Transform> {
    private int prio = 0;
    private Map<String, String> arguments = new HashMap<String, String>();

    public void extractArguments(Model graph, Resource resource) {
        Value obj;
        Iterator prios = graph.filter(null, Pipeline.transformPriority, null, new Resource[0]).iterator();
        if (prios.hasNext() && (obj = ((Statement)prios.next()).getObject()) instanceof Literal) {
            this.prio = ((Literal)obj).integerValue().intValue();
        }
        for (Statement s : graph.filter(resource, Pipeline.transformArgument, null, new Resource[0])) {
            Value argKey;
            if (!(s.getObject() instanceof BNode)) continue;
            String keyStr = null;
            String valueStr = null;
            Iterator argKeyIt = graph.filter((Resource)((BNode)s.getObject()), Pipeline.transformArgumentKey, null, new Resource[0]).iterator();
            if (argKeyIt.hasNext() && (argKey = ((Statement)argKeyIt.next()).getObject()) instanceof Literal) {
                Value argValue;
                keyStr = ((Literal)argKey).stringValue();
                Iterator argValueIt = graph.filter((Resource)((BNode)s.getObject()), Pipeline.transformArgumentValue, null, new Resource[0]).iterator();
                if (argValueIt.hasNext() && (argValue = ((Statement)argValueIt.next()).getObject()) instanceof Literal) {
                    valueStr = ((Literal)argValue).stringValue();
                }
            }
            if (keyStr == null || valueStr == null) continue;
            this.arguments.put(keyStr.toLowerCase(), valueStr);
        }
    }

    @Override
    public int compareTo(Transform step) {
        return this.prio - step.prio;
    }

    public int getPrio() {
        return this.prio;
    }

    public void setPrio(int prio) {
        this.prio = prio;
    }

    public abstract Object transform(Pipeline var1, Entry var2) throws TransformException;

    public Object transform(Pipeline pipeline, Model graph) throws TransformException {
        return graph;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }
}

