/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.harvesting.oaipmh.harvester.factory;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.entrystore.Entry;
import org.entrystore.harvester.Harvester;
import org.entrystore.harvester.factory.HarvesterFactory;
import org.entrystore.harvester.factory.HarvesterFactoryException;
import org.entrystore.harvesting.oaipmh.harvester.OAIHarvester;
import org.entrystore.impl.RepositoryManagerImpl;
import org.entrystore.repository.RepositoryException;
import org.entrystore.repository.config.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAIHarvesterFactory
implements HarvesterFactory {
    static Logger log = LoggerFactory.getLogger(OAIHarvesterFactory.class);

    public Harvester createHarvester(String target, String metadataType, String set, String timeRegExp, RepositoryManagerImpl rm, URI ownerContextURI) throws HarvesterFactoryException {
        String oai = rm.getConfiguration().getString(Settings.HARVESTER_OAI, "off");
        if (oai.equals("off")) {
            throw new HarvesterFactoryException("The OAI-PMH harvester module is not enabled");
        }
        Entry contextEntry = rm.getContextManager().getEntry(ownerContextURI);
        if (contextEntry == null) {
            throw new HarvesterFactoryException("Can not find the context entry");
        }
        if (this.isOAIHarvester(contextEntry)) {
            return this.getHarvester(rm, ownerContextURI);
        }
        this.initOAIHarvester(contextEntry, timeRegExp, set, metadataType, target);
        return new OAIHarvester(target, metadataType, set, timeRegExp, rm, ownerContextURI);
    }

    public Harvester getHarvester(RepositoryManagerImpl rm, URI ownerContextURI) throws HarvesterFactoryException {
        String oai = rm.getConfiguration().getString(Settings.HARVESTER_OAI, "off");
        if (oai.equals("off")) {
            throw new HarvesterFactoryException("The OAI-PMH harvester module is not enabled");
        }
        String metadataType = null;
        String target = null;
        String timeRegExp = null;
        String set = null;
        Entry contextEntry = rm.getContextManager().getEntry(ownerContextURI);
        if (!this.isOAIHarvester(contextEntry)) {
            return null;
        }
        for (Statement s : contextEntry.getGraph()) {
            if (s.getPredicate().toString().equals("http://entrystore.org/terms/OAIHarvester")) {
                log.info("isHarvester: type OAIHarvester");
            }
            if (s.getPredicate().toString().equals("http://entrystore.org/terms/harvestTimeRegExp")) {
                timeRegExp = s.getObject().stringValue();
            }
            if (s.getPredicate().toString().equals("http://entrystore.org/terms/target")) {
                target = s.getObject().stringValue();
            }
            if (s.getPredicate().toString().equals("http://entrystore.org/terms/metadataType")) {
                metadataType = s.getObject().stringValue();
            }
            if (!s.getPredicate().toString().equals("http://entrystore.org/terms/set")) continue;
            set = s.getObject().stringValue();
        }
        return new OAIHarvester(target, metadataType, set, timeRegExp, rm, ownerContextURI);
    }

    public boolean isOAIHarvester(Entry contextEntry) {
        for (Statement s : contextEntry.getGraph()) {
            if (!s.getPredicate().toString().equals("http://entrystore.org/terms/harvester") || !s.getObject().stringValue().equals("http://entrystore.org/terms/OAIHarvester")) continue;
            return true;
        }
        return false;
    }

    private void initOAIHarvester(Entry contextEntry, String timeRegExp, String set, String metadataType, String target) {
        Model graph = contextEntry.getGraph();
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        IRI root = vf.createIRI(contextEntry.getEntryURI().toString());
        try {
            IRI harvesterRoot = vf.createIRI("http://entrystore.org/terms/OAIHarvester");
            graph.add((Resource)root, vf.createIRI("http://entrystore.org/terms/harvester"), (Value)harvesterRoot, new Resource[0]);
            graph.add((Resource)harvesterRoot, vf.createIRI("http://entrystore.org/terms/harvestTimeRegExp"), (Value)vf.createLiteral(timeRegExp), new Resource[0]);
            graph.add((Resource)harvesterRoot, vf.createIRI("http://entrystore.org/terms/target"), (Value)vf.createLiteral(target), new Resource[0]);
            graph.add((Resource)harvesterRoot, vf.createIRI("http://entrystore.org/terms/metadataType"), (Value)vf.createLiteral(metadataType), new Resource[0]);
            if (set != null) {
                graph.add((Resource)harvesterRoot, vf.createIRI("http://entrystore.org/terms/set"), (Value)vf.createLiteral(set), new Resource[0]);
            }
            contextEntry.setGraph(graph);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public void deleteHarvester(Entry contextEntry) {
        Model graph = contextEntry.getGraph();
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        try {
            IRI harvesterRoot = vf.createIRI("http://entrystore.org/terms/harvester");
            IRI oaiRoot = vf.createIRI("http://entrystore.org/terms/OAIHarvester");
            ArrayList<Statement> statements = new ArrayList<Statement>();
            for (Statement statement : graph) {
                if (!statement.getPredicate().equals((Object)harvesterRoot) && !statement.getSubject().equals((Object)oaiRoot)) continue;
                statements.add(statement);
            }
            graph.removeAll(statements);
            contextEntry.setGraph(graph);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }
}

