/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.harvesting.oaipmh.jobs;

import ORG.oclc.oai.harvester2.verb.GetRecord;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.entrystore.Context;
import org.entrystore.harvesting.oaipmh.jobs.ListRecordsJob;
import org.quartz.UnableToInterruptJobException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GetRecordJob {
    private static Log log = LogFactory.getLog(GetRecordJob.class);
    private static XPathFactory factory;
    private static XPath xpath;

    public static void getRecord(String target, String identifier, String metadataType, Context context) {
        factory = XPathFactory.newInstance();
        xpath = factory.newXPath();
        xpath.setNamespaceContext(GetRecordJob.createNamespace());
        GetRecord getRecord = null;
        try {
            getRecord = new GetRecord(target, identifier, metadataType);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage());
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage());
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        Element el = getRecord.getDocument().getDocumentElement();
        if (el.getElementsByTagName("GetRecord").getLength() == 0) {
            log.error((Object)"No GetRecord");
        }
        Element getRecordElement = (Element)el.getElementsByTagName("GetRecord").item(0);
        Element element = (Element)getRecordElement.getElementsByTagName("record").item(0);
        try {
            new ListRecordsJob().createEntry(context, element, target, metadataType);
        }
        catch (XPathExpressionException e) {
            log.error((Object)e.getMessage());
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
    }

    private static NamespaceContext createNamespace() {
        NamespaceContext ctx = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                String uri = prefix.equals("oai") ? "http://www.openarchives.org/OAI/2.0/" : (prefix.equals("dc") ? "http://purl.org/dc/elements/1.1/" : (prefix.equals("oai_dc") ? "http://www.openarchives.org/OAI/2.0/oai_dc/" : null));
                return uri;
            }

            public Iterator getPrefixes(String val) {
                return null;
            }

            @Override
            public String getPrefix(String uri) {
                return null;
            }
        };
        return ctx;
    }
}

