/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.entrystore.Entry;
import org.entrystore.PrincipalManager;
import org.entrystore.impl.ContextImpl;
import org.entrystore.impl.EntryImpl;
import org.entrystore.impl.RepositoryProperties;
import org.entrystore.impl.SoftCache;
import org.entrystore.repository.RepositoryEvent;
import org.entrystore.repository.RepositoryEventObject;

public class EntryNamesContext
extends ContextImpl {
    private static final Log log = LogFactory.getLog(EntryNamesContext.class);
    HashMap<String, URI> names2EntryURI;
    HashMap<URI, String> entryURI2Name;

    public EntryNamesContext(EntryImpl entry, String uri, SoftCache cache) {
        super(entry, uri, cache);
    }

    protected String getName(URI entryURI) {
        if (this.names2EntryURI == null) {
            this.loadNameIndex();
        }
        return this.entryURI2Name.get(entryURI);
    }

    public Entry getEntryByName(String name) {
        if (this.names2EntryURI == null) {
            this.loadNameIndex();
        }
        return this.getByEntryURI(this.names2EntryURI.get(name));
    }

    @Override
    protected void removeFromIndex(EntryImpl entry, RepositoryConnection rc) throws RepositoryException {
        super.removeFromIndex(entry, rc);
        if (this.names2EntryURI == null) {
            this.loadNameIndex();
        }
        URI entryURI = entry.getEntryURI();
        IRI cURI = rc.getValueFactory().createIRI(entryURI.toString());
        if (this.entryURI2Name.containsKey(entryURI)) {
            String oldName = this.entryURI2Name.get(entryURI);
            this.entryURI2Name.remove(entryURI);
            this.names2EntryURI.remove(oldName);
            Literal oldAliasLiteral = rc.getValueFactory().createLiteral(oldName);
            rc.remove((Resource)cURI, RepositoryProperties.alias, (Value)oldAliasLiteral, new Resource[]{this.resourceURI});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean setEntryName(URI entryURI, String newName) {
        if (entryURI == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        Entry forEntry = this.getByEntryURI(entryURI);
        if (forEntry == null) {
            throw new org.entrystore.repository.RepositoryException("Unable to set name for non-existing entry");
        }
        PrincipalManager pm = this.entry.getRepositoryManager().getPrincipalManager();
        if (pm != null) {
            pm.checkAuthenticatedUserAuthorized(forEntry, PrincipalManager.AccessProperty.WriteResource);
        }
        if (this.names2EntryURI == null) {
            this.loadNameIndex();
        }
        if (newName != null && this.names2EntryURI.containsKey(newName)) {
            if (newName.equals(this.entryURI2Name.get(entryURI))) {
                return true;
            }
            log.error((Object)("The name " + newName + " is already in use."));
            return false;
        }
        try {
            Repository repository = this.entry.repository;
            synchronized (repository) {
                RepositoryConnection rc = this.entry.repository.getConnection();
                try {
                    ValueFactory vf = this.entry.repository.getValueFactory();
                    rc.begin();
                    IRI cURI = vf.createIRI(entryURI.toString());
                    if (this.entryURI2Name.containsKey(entryURI)) {
                        String oldName = this.entryURI2Name.get(entryURI);
                        this.entryURI2Name.remove(entryURI);
                        this.names2EntryURI.remove(oldName);
                        Literal oldAliasLiteral = vf.createLiteral(oldName);
                        rc.remove((Resource)cURI, RepositoryProperties.alias, (Value)oldAliasLiteral, new Resource[]{this.resourceURI});
                    }
                    if (newName != null) {
                        this.names2EntryURI.put(newName, entryURI);
                        this.entryURI2Name.put(entryURI, newName);
                        Literal nameLiteral = vf.createLiteral(newName);
                        rc.add((Resource)cURI, RepositoryProperties.alias, (Value)nameLiteral, new Resource[]{this.resourceURI});
                        this.entry.updateModifiedDateSynchronized(rc, vf);
                        ((EntryImpl)forEntry).updateModifiedDateSynchronized(rc, vf);
                    }
                    rc.commit();
                    this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
                    this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject(forEntry, RepositoryEvent.ResourceUpdated));
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    rc.rollback();
                    throw new org.entrystore.repository.RepositoryException("Error in connection to repository", e);
                }
                finally {
                    log.info((Object)("Successfully set the name " + newName + " for entry with URI: " + String.valueOf(entryURI)));
                    rc.close();
                }
            }
        }
        catch (RepositoryException e) {
            throw new org.entrystore.repository.RepositoryException("Cannot connect to repository", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadNameIndex() {
        try {
            Repository repository = this.entry.repository;
            synchronized (repository) {
                if (this.names2EntryURI != null) {
                    return;
                }
                try (RepositoryConnection rc = this.entry.repository.getConnection();){
                    this.names2EntryURI = new HashMap();
                    this.entryURI2Name = new HashMap();
                    List statements = rc.getStatements(null, RepositoryProperties.alias, null, false, new Resource[]{this.resourceURI}).asList();
                    Iterator iterator = statements.iterator();
                    while (iterator.hasNext()) {
                        Statement statement = (Statement)iterator.next();
                        try {
                            URI entryURI = URI.create(statement.getSubject().stringValue());
                            String name = statement.getObject().stringValue();
                            this.names2EntryURI.put(name, entryURI);
                            this.entryURI2Name.put(entryURI, name);
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage());
                            throw new org.entrystore.repository.RepositoryException("Error in connection to repository", e);
                        }
                    }
                    return;
                }
            }
        }
        catch (RepositoryException e) {
            log.error((Object)e.getMessage());
            throw new org.entrystore.repository.RepositoryException("Cannot connect to repository", (Exception)((Object)e));
        }
    }

    protected Set<String> getEntryNames() {
        this.checkAccess(null, PrincipalManager.AccessProperty.ReadResource);
        if (this.names2EntryURI == null) {
            this.loadNameIndex();
        }
        return this.names2EntryURI.keySet();
    }
}

