/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.net.URI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.entrystore.Entry;
import org.entrystore.Metadata;
import org.entrystore.impl.ContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMetadataWrapper
implements Metadata {
    Logger log = LoggerFactory.getLogger(LocalMetadataWrapper.class);
    Entry entry;
    URI refEntryURI;

    public LocalMetadataWrapper(Entry entry) {
        this.entry = entry;
        Entry e = entry.getRepositoryManager().getContextManager().getEntry(entry.getExternalMetadataURI());
        if (e != null) {
            this.refEntryURI = e.getEntryURI();
        } else {
            this.log.warn("Could not find Entry with external MD URI: " + String.valueOf(entry.getExternalMetadataURI()));
        }
    }

    public Model getGraph() {
        Entry e = null;
        if (this.refEntryURI != null) {
            e = ((ContextImpl)this.entry.getContext()).getSoftCache().getByEntryURI(this.refEntryURI);
        }
        if (e == null) {
            e = this.entry.getRepositoryManager().getContextManager().getEntry(this.entry.getExternalMetadataURI());
        }
        if (e != null && e.getLocalMetadata() != null) {
            return e.getLocalMetadata().getGraph();
        }
        this.log.warn("Entry is null, returning an empty graph");
        return new LinkedHashModel();
    }

    public URI getResourceURI() {
        return this.entry.getResourceURI();
    }

    public URI getURI() {
        return this.entry.getExternalMetadataURI();
    }

    public boolean isCached() {
        return true;
    }

    public void setGraph(Model graph) {
        throw new UnsupportedOperationException();
    }
}

