/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.net.URI;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.entrystore.GraphEntity;
import org.entrystore.ProvenanceType;
import org.entrystore.impl.EntryImpl;
import org.entrystore.impl.RepositoryProperties;

public class MetadataEntityImpl
implements GraphEntity {
    private IRI uri;
    private EntryImpl entry;
    private Date date;
    private IRI attributedURI;
    private boolean latest;
    Log log = LogFactory.getLog(MetadataEntityImpl.class);

    public MetadataEntityImpl(EntryImpl entry, IRI uri, Date date, boolean isLatest) {
        this.entry = entry;
        this.uri = uri;
        this.date = date;
        this.latest = isLatest;
    }

    public MetadataEntityImpl(EntryImpl entry, Statement generatedStmt, IRI latestEntityURI) {
        this(entry, (IRI)generatedStmt.getSubject(), ((Literal)generatedStmt.getObject()).calendarValue().toGregorianCalendar().getTime(), generatedStmt.getSubject().equals((Object)latestEntityURI));
    }

    public URI getResourceURI() {
        return this.entry.getResourceURI();
    }

    public URI getURI() {
        return URI.create(this.uri.stringValue());
    }

    protected IRI getSesameURI() {
        return this.uri;
    }

    public Date getGeneratedDate() {
        return this.date;
    }

    public URI getAttributedURI() {
        if (this.attributedURI == null) {
            RepositoryConnection rc = null;
            try {
                rc = this.entry.repository.getConnection();
                RepositoryResult attr = rc.getStatements((Resource)this.uri, RepositoryProperties.wasAttributedTo, null, false, new Resource[]{this.entry.entryURI});
                if (attr.hasNext()) {
                    this.attributedURI = (IRI)((Statement)attr.next()).getObject();
                }
                attr.close();
            }
            catch (RepositoryException e) {
                this.log.error((Object)e.getMessage());
            }
            finally {
                try {
                    rc.close();
                }
                catch (RepositoryException e) {
                    this.log.error((Object)e.getMessage());
                }
            }
        }
        return URI.create(this.attributedURI.stringValue());
    }

    public ProvenanceType getProvenanceType() {
        return ProvenanceType.Metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model getGraph() {
        if (this.latest) {
            return this.entry.getMetadataGraph();
        }
        RepositoryConnection rc = null;
        try {
            rc = this.entry.repositoryManager.getProvenanceRepository().getConnection();
            Model model = (Model)Iterations.addAll((CloseableIteration)rc.getStatements(null, null, null, false, new Resource[]{this.uri}), (Collection)new LinkedHashModel());
            return model;
        }
        catch (RepositoryException e) {
            this.log.error((Object)e.getMessage());
            Model model = null;
            return model;
        }
        finally {
            try {
                rc.close();
            }
            catch (RepositoryException e) {
                this.log.error((Object)e.getMessage());
            }
        }
    }

    public void setGraph(Model graph) {
        throw new UnsupportedOperationException("Changing metadata history is not supported by this instance");
    }

    public boolean isCached() {
        return false;
    }

    public void remove(RepositoryConnection rc) throws RepositoryException {
        if (!this.latest) {
            rc.clear(new Resource[]{this.uri});
        }
    }
}

