/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.net.URI;
import java.util.Collection;
import javax.xml.datatype.DatatypeConfigurationException;
import lombok.Generated;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.entrystore.Entry;
import org.entrystore.Metadata;
import org.entrystore.PrincipalManager;
import org.entrystore.impl.ContextManagerImpl;
import org.entrystore.impl.EntryImpl;
import org.entrystore.impl.ProvenanceImpl;
import org.entrystore.repository.RepositoryEvent;
import org.entrystore.repository.RepositoryEventObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataImpl
implements Metadata {
    private EntryImpl entry;
    private IRI uri;
    private IRI resourceUri;
    private Resource mdContext;
    private boolean cached;
    private boolean localCache;
    Logger log = LoggerFactory.getLogger(MetadataImpl.class);

    public MetadataImpl(EntryImpl entry, IRI uri, IRI resourceUri, boolean cached) {
        this.entry = entry;
        this.uri = uri;
        this.resourceUri = resourceUri;
        this.mdContext = uri;
        this.cached = cached;
        this.localCache = true;
    }

    public Model getGraph() {
        PrincipalManager pm = this.entry.getRepositoryManager().getPrincipalManager();
        if (pm != null) {
            pm.checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.ReadMetadata);
        }
        RepositoryConnection rc = null;
        try {
            rc = this.entry.repository.getConnection();
            Model model = (Model)Iterations.addAll((CloseableIteration)rc.getStatements(null, null, null, false, new Resource[]{this.mdContext}), (Collection)new LinkedHashModel());
            return model;
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage());
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
        finally {
            try {
                rc.close();
            }
            catch (RepositoryException e) {
                this.log.error(e.getMessage());
            }
        }
    }

    public URI getURI() {
        if (this.uri != null) {
            return URI.create(this.uri.toString());
        }
        this.log.warn("Metadata URI is null of entry: " + String.valueOf(this.entry.getEntryURI()));
        return null;
    }

    public URI getResourceURI() {
        return URI.create(this.resourceUri.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGraph(Model graph) {
        PrincipalManager pm = this.entry.getRepositoryManager().getPrincipalManager();
        if (pm != null) {
            pm.checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteMetadata);
        }
        try {
            Repository repository = this.entry.repository;
            synchronized (repository) {
                rc.begin();
                try (RepositoryConnection rc = this.entry.repository.getConnection();){
                    Model oldGraph = this.removeGraphSynchronized(rc);
                    this.addGraphSynchronized(rc, graph);
                    ProvenanceImpl provenance = (ProvenanceImpl)this.entry.getProvenance();
                    if (provenance != null && !this.cached) {
                        provenance.addMetadataEntity(oldGraph, rc);
                    }
                    rc.commit();
                    if (this.cached) {
                        this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ExternalMetadataUpdated, graph));
                    } else {
                        this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.MetadataUpdated, graph));
                    }
                }
            }
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage());
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
    }

    public Model removeGraphSynchronized(RepositoryConnection rc) throws RepositoryException {
        String base = this.entry.repositoryManager.getRepositoryURL().toString();
        Model graph = (Model)Iterations.addAll((CloseableIteration)rc.getStatements(null, null, null, false, new Resource[]{this.mdContext}), (Collection)new LinkedHashModel());
        if (this.resourceUri.stringValue().startsWith(base)) {
            for (Statement statement : graph) {
                Value obj = statement.getObject();
                Resource subj = statement.getSubject();
                if (!(obj instanceof IRI) || !obj.stringValue().startsWith(base) || !subj.stringValue().startsWith(base)) continue;
                URI entryURI = URI.create(statement.getObject().stringValue());
                EntryImpl sourceEntry = (EntryImpl)this.entry.getRepositoryManager().getContextManager().getEntry(entryURI);
                if (sourceEntry == null) continue;
                sourceEntry.removeRelationSynchronized(statement, rc);
            }
        }
        rc.clear(new Resource[]{this.mdContext});
        return graph;
    }

    public void addGraphSynchronized(RepositoryConnection rc, Model graph) throws RepositoryException, DatatypeConfigurationException {
        String base = this.entry.repositoryManager.getRepositoryURL().toString();
        rc.add((Iterable)graph, new Resource[]{this.mdContext});
        if (this.cached) {
            this.entry.updateCachedExternalMetadataDateSynchronized(rc, this.entry.repository.getValueFactory());
        } else {
            this.entry.updateModifiedDateSynchronized(rc, this.entry.repository.getValueFactory());
        }
        if (this.resourceUri.stringValue().startsWith(base)) {
            for (Statement statement : graph) {
                Value obj = statement.getObject();
                Resource subj = statement.getSubject();
                if (!(obj instanceof IRI) || !obj.stringValue().startsWith(base) || !subj.stringValue().startsWith(base)) continue;
                URI entryURI = URI.create(statement.getObject().stringValue());
                EntryImpl sourceEntry = (EntryImpl)((ContextManagerImpl)this.entry.getRepositoryManager().getContextManager()).getEntryIgnoreACL(entryURI);
                if (sourceEntry == null) continue;
                sourceEntry.addRelationSynchronized(statement, rc);
            }
        }
    }

    @Generated
    public boolean isCached() {
        return this.cached;
    }
}

