/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.entrystore.Entity;
import org.entrystore.GraphEntity;
import org.entrystore.Provenance;
import org.entrystore.ProvenanceType;
import org.entrystore.impl.EntryImpl;
import org.entrystore.impl.MetadataEntityImpl;
import org.entrystore.impl.RepositoryProperties;

public class ProvenanceImpl
implements Provenance {
    Log log = LogFactory.getLog(ProvenanceImpl.class);
    private EntryImpl entry;

    public ProvenanceImpl(EntryImpl entry) {
        this.entry = entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entity> getEntities(ProvenanceType type) {
        RepositoryConnection rc = null;
        try {
            rc = this.entry.repository.getConnection();
            rc.begin();
            List<Entity> result = this.getEntities(type, rc);
            rc.commit();
            List<Entity> list = result;
            return list;
        }
        catch (RepositoryException e) {
            if (rc != null) {
                try {
                    rc.rollback();
                }
                catch (RepositoryException e1) {
                    this.log.error((Object)e1.getMessage());
                }
            }
            this.log.error((Object)e.getMessage());
        }
        finally {
            if (rc != null) {
                try {
                    rc.close();
                }
                catch (RepositoryException e) {
                    this.log.error((Object)e.getMessage());
                }
            }
        }
        return new ArrayList<Entity>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entity> getEntities(ProvenanceType type, RepositoryConnection rc) throws RepositoryException {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        RepositoryResult latestStmt = null;
        IRI latestURI = null;
        try {
            latestStmt = rc.getStatements(null, OWL.SAMEAS, (Value)this.entry.getSesameLocalMetadataURI(), false, new Resource[]{this.entry.entryURI});
            latestURI = latestStmt.hasNext() ? (IRI)((Statement)latestStmt.next()).getSubject() : null;
        }
        finally {
            if (latestStmt != null && !latestStmt.isClosed()) {
                latestStmt.close();
            }
        }
        RepositoryResult rr = null;
        try {
            rr = rc.getStatements(null, RepositoryProperties.generatedAtTime, null, false, new Resource[]{this.entry.entryURI});
            while (rr.hasNext()) {
                entities.add((Entity)new MetadataEntityImpl(this.entry, (Statement)rr.next(), latestURI));
            }
        }
        finally {
            if (rr != null && !rr.isClosed()) {
                rr.close();
            }
        }
        entities.sort(new Comparator<Entity>(this){

            @Override
            public int compare(Entity t1, Entity t2) {
                Date d2;
                Date d1 = t1.getGeneratedDate();
                if (d1.after(d2 = t2.getGeneratedDate())) {
                    return 1;
                }
                if (d1.before(d2)) {
                    return -1;
                }
                return 0;
            }
        });
        return entities;
    }

    public Entity getEntityAt(Date date, ProvenanceType type) {
        List list = Lists.reverse(this.getEntities(type));
        for (Entity e : list) {
            if (!e.getGeneratedDate().before(date)) continue;
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity getEntityFor(URI uri) {
        RepositoryConnection rc = null;
        RepositoryResult rr = null;
        RepositoryResult latestStmt = null;
        try {
            rc = this.entry.repository.getConnection();
            rr = rc.getStatements((Resource)rc.getValueFactory().createIRI(uri.toString()), RepositoryProperties.generatedAtTime, null, false, new Resource[]{this.entry.entryURI});
            latestStmt = rc.getStatements(null, OWL.SAMEAS, (Value)this.entry.getSesameLocalMetadataURI(), false, new Resource[]{this.entry.entryURI});
            IRI latestURI = latestStmt.hasNext() ? (IRI)((Statement)latestStmt.next()).getSubject() : null;
            MetadataEntityImpl entity = null;
            if (rr.hasNext()) {
                entity = new MetadataEntityImpl(this.entry, (Statement)rr.next(), latestURI);
            }
            MetadataEntityImpl metadataEntityImpl = entity;
            return metadataEntityImpl;
        }
        catch (RepositoryException e) {
            this.log.error((Object)e.getMessage());
        }
        finally {
            if (rr != null && !rr.isClosed()) {
                try {
                    rr.close();
                }
                catch (RepositoryException e) {
                    this.log.error((Object)e.getMessage());
                }
            }
            if (latestStmt != null && !latestStmt.isClosed()) {
                try {
                    latestStmt.close();
                }
                catch (RepositoryException e) {
                    this.log.error((Object)e.getMessage());
                }
            }
            if (rc != null) {
                try {
                    rc.close();
                }
                catch (RepositoryException e) {
                    this.log.error((Object)e.getMessage());
                }
            }
        }
        return null;
    }

    public Entity getEntityFor(String revision, ProvenanceType type) {
        return this.getEntityFor(this.getRevisionURI(revision, ProvenanceType.Metadata));
    }

    private URI getNewRevisionURIFromOld(URI latestEntityURI, ProvenanceType type) {
        String lmu = this.entry.getLocalMetadataURI().toString();
        String oldRev = latestEntityURI.toString().substring(lmu.length() + 5);
        String newRev = Integer.toString(Integer.parseInt(oldRev) + 1);
        return this.getRevisionURI(newRev, type);
    }

    private URI getRevisionURI(String revision, ProvenanceType type) {
        return URI.create(this.entry.getLocalMetadataURI().toString() + "?rev=" + revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphEntity addMetadataEntity(Model oldgraph) {
        RepositoryConnection rc = null;
        try {
            rc = this.entry.repository.getConnection();
            rc.begin();
            GraphEntity result = this.addMetadataEntity(oldgraph, rc);
            rc.commit();
            GraphEntity graphEntity = result;
            return graphEntity;
        }
        catch (RepositoryException e) {
            if (rc != null) {
                try {
                    rc.rollback();
                }
                catch (RepositoryException e1) {
                    this.log.error((Object)e1.getMessage());
                }
            }
            this.log.error((Object)e.getMessage());
        }
        finally {
            if (rc != null) {
                try {
                    rc.close();
                }
                catch (RepositoryException e) {
                    this.log.error((Object)e.getMessage());
                }
            }
        }
        return null;
    }

    private IRI getUserURI(ValueFactory vf) {
        if (this.entry.repositoryManager != null && this.entry.repositoryManager.getPrincipalManager() != null && this.entry.repositoryManager.getPrincipalManager().getAuthenticatedUserURI() != null) {
            return vf.createIRI(this.entry.repositoryManager.getPrincipalManager().getAuthenticatedUserURI().toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeProvenanceGraph(IRI ng, Model graph) {
        RepositoryConnection rc = null;
        try {
            rc = this.entry.repositoryManager.getProvenanceRepository().getConnection();
            rc.begin();
            rc.add((Iterable)graph, new Resource[]{ng});
            rc.commit();
        }
        catch (RepositoryException e) {
            if (rc != null) {
                try {
                    rc.rollback();
                }
                catch (RepositoryException e1) {
                    this.log.error((Object)e.getMessage());
                }
            }
            this.log.error((Object)e.getMessage());
        }
        finally {
            if (rc != null) {
                try {
                    rc.close();
                }
                catch (RepositoryException e) {
                    this.log.error((Object)e.getMessage());
                }
            }
        }
    }

    protected GraphEntity addMetadataEntity(Model oldgraph, RepositoryConnection rc) throws RepositoryException {
        IRI uri;
        MetadataEntityImpl latestEntity = (MetadataEntityImpl)this.getEntityAt(new Date(), ProvenanceType.Metadata);
        ValueFactory vf = rc.getValueFactory();
        IRI attr = this.getUserURI(vf);
        if (attr == null) {
            return null;
        }
        IRI eURI = this.entry.entryURI;
        if (latestEntity == null) {
            uri = vf.createIRI(this.getRevisionURI("1", ProvenanceType.Metadata).toString());
        } else {
            URI newMDURI = this.getNewRevisionURIFromOld(latestEntity.getURI(), ProvenanceType.Metadata);
            uri = vf.createIRI(newMDURI.toString());
            rc.add((Resource)uri, RepositoryProperties.wasRevisionOf, (Value)latestEntity.getSesameURI(), new Resource[]{eURI});
            rc.remove(rc.getStatements((Resource)latestEntity.getSesameURI(), OWL.SAMEAS, null, false, new Resource[]{eURI}), new Resource[]{eURI});
            this.storeProvenanceGraph(latestEntity.getSesameURI(), oldgraph);
        }
        try {
            Literal modified = vf.createLiteral(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
            rc.add((Resource)uri, RepositoryProperties.wasAttributedTo, (Value)attr, new Resource[]{eURI});
            rc.add((Resource)uri, RepositoryProperties.generatedAtTime, (Value)modified, new Resource[]{eURI});
            rc.add((Resource)uri, OWL.SAMEAS, (Value)this.entry.getSesameLocalMetadataURI(), new Resource[]{eURI});
            return new MetadataEntityImpl(this.entry, uri, modified.calendarValue().toGregorianCalendar().getTime(), true);
        }
        catch (DatatypeConfigurationException e) {
            this.log.error((Object)e.getMessage());
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        List<Entity> entities = this.getEntities(ProvenanceType.Metadata);
        RepositoryConnection rc = null;
        try {
            rc = this.entry.repositoryManager.getProvenanceRepository().getConnection();
            rc.begin();
            for (Entity e : entities) {
                ((MetadataEntityImpl)e).remove(rc);
            }
            rc.commit();
        }
        catch (RepositoryException e) {
            if (rc != null) {
                try {
                    rc.rollback();
                }
                catch (RepositoryException e1) {
                    this.log.error((Object)e1.getMessage());
                }
            }
            this.log.error((Object)e.getMessage());
        }
        finally {
            if (rc != null) {
                try {
                    rc.close();
                }
                catch (RepositoryException e) {
                    this.log.error((Object)e.getMessage());
                }
            }
        }
    }

    protected boolean hasProvenanceCharacter(Statement st) {
        IRI predicate = st.getPredicate();
        return RepositoryProperties.wasRevisionOf.equals((Object)predicate) || RepositoryProperties.generatedAtTime.equals((Object)predicate) || RepositoryProperties.wasAttributedTo.equals((Object)predicate) || OWL.SAMEAS.equals((Object)predicate) && this.entry.getSesameLocalMetadataURI().equals((Object)st.getObject());
    }

    protected Model getMinimalGraph(RepositoryConnection rc) throws RepositoryException {
        RepositoryResult rr = rc.getStatements(null, null, null, false, new Resource[]{this.entry.entryURI});
        LinkedHashModel result = new LinkedHashModel();
        while (rr.hasNext()) {
            Statement st = (Statement)rr.next();
            if (!this.hasProvenanceCharacter(st)) continue;
            result.add((Object)st);
        }
        rr.close();
        return result;
    }
}

