/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Queues;
import java.io.File;
import java.net.URI;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.ContextManager;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.PrincipalManager;
import org.entrystore.config.Config;
import org.entrystore.impl.RepositoryManagerImpl;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicRepository {
    Logger log = LoggerFactory.getLogger(PublicRepository.class);
    private boolean rebuilding = false;
    private Repository repository;
    private RepositoryManager rm;
    private PrincipalManager pm;
    private Thread entrySubmitter;
    private final Cache<URI, Entry> postQueue = Caffeine.newBuilder().build();
    private final Queue<Entry> deleteQueue = Queues.newConcurrentLinkedQueue();
    private static final int BATCH_SIZE = 1000;

    public PublicRepository(RepositoryManager rm) {
        this.rm = rm;
        this.pm = rm.getPrincipalManager();
        Config config = rm.getConfiguration();
        String storeType = config.getString(Settings.REPOSITORY_PUBLIC_TYPE, "memory").trim();
        this.log.info("Public repository type: " + storeType);
        if (storeType.equalsIgnoreCase("memory")) {
            this.repository = new SailRepository((Sail)new MemoryStore());
        } else if (storeType.equalsIgnoreCase("native")) {
            if (!config.containsKey(Settings.REPOSITORY_PUBLIC_PATH)) {
                this.log.error("Incomplete configuration of public repository");
            } else {
                File path = new File(config.getURI(Settings.REPOSITORY_PUBLIC_PATH));
                String indexes = config.getString(Settings.REPOSITORY_PUBLIC_INDEXES);
                ((RepositoryManagerImpl)rm).checkAndUpgradeNativeStore(path, indexes);
                this.log.info("Public repository: using Native Store at {} with indexes {}", (Object)path, (Object)indexes);
                NativeStore store = null;
                store = indexes != null ? new NativeStore(path, indexes) : new NativeStore(path);
                if (store != null) {
                    this.repository = new SailRepository((Sail)store);
                }
            }
        }
        if (this.repository == null) {
            this.log.error("Failed to create public repository");
            return;
        }
        try {
            this.repository.init();
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage());
        }
        if (this.getTripleCount() == 0L || "on".equalsIgnoreCase(config.getString(Settings.REPOSITORY_PUBLIC_REBUILD_ON_STARTUP, "off"))) {
            this.rebuildRepository();
        }
        this.entrySubmitter = new EntrySubmitter();
        this.entrySubmitter.start();
    }

    public RepositoryConnection getConnection() {
        try {
            return this.repository.getConnection();
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Entry entry) {
        URI entryURI = entry.getEntryURI();
        Cache<URI, Entry> cache = this.postQueue;
        synchronized (cache) {
            this.log.info("Adding document to update queue: " + String.valueOf(entryURI));
            this.postQueue.put((Object)entryURI, (Object)entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Entry entry) {
        URI entryURI = entry.getEntryURI();
        Queue<Entry> queue = this.deleteQueue;
        synchronized (queue) {
            this.log.info("Adding entry to delete queue: " + String.valueOf(entryURI));
            this.deleteQueue.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(Entry e, RepositoryConnection rc) throws RepositoryException {
        if (this.isAdministrative(e)) {
            return;
        }
        URI currentUser = this.pm.getAuthenticatedUserURI();
        try {
            this.pm.setAuthenticatedUserURI(this.pm.getGuestUser().getURI());
            try {
                ValueFactory vf = this.repository.getValueFactory();
                IRI contextURI = vf.createIRI(e.getContext().getURI().toString());
                Model mdGraph = null;
                IRI mdNG = null;
                if (e.getLocalMetadata() != null) {
                    mdGraph = e.getLocalMetadata().getGraph();
                    mdNG = vf.createIRI(e.getLocalMetadataURI().toString());
                }
                Model extMdGraph = null;
                IRI extMdNG = null;
                if (e.getCachedExternalMetadata() != null) {
                    extMdGraph = e.getCachedExternalMetadata().getGraph();
                    extMdNG = vf.createIRI(e.getCachedExternalMetadataURI().toString());
                }
                Model resGraph = null;
                IRI resNG = null;
                if (GraphType.Graph.equals((Object)e.getGraphType()) && EntryType.Local.equals((Object)e.getEntryType())) {
                    resGraph = (Model)e.getResource();
                    resNG = vf.createIRI(e.getResourceURI().toString());
                }
                if (mdGraph != null) {
                    rc.add((Iterable)mdGraph, new Resource[]{mdNG, contextURI});
                }
                if (extMdGraph != null) {
                    rc.add((Iterable)extMdGraph, new Resource[]{extMdNG, contextURI});
                }
                if (resGraph != null) {
                    rc.add((Iterable)resGraph, new Resource[]{resNG, contextURI});
                }
            }
            catch (AuthorizationException authorizationException) {
                // empty catch block
            }
        }
        finally {
            this.pm.setAuthenticatedUserURI(currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntries(Set<Entry> entries) {
        URI currentUser = this.pm.getAuthenticatedUserURI();
        try {
            this.pm.setAuthenticatedUserURI(this.pm.getGuestUser().getURI());
            Repository repository = this.repository;
            synchronized (repository) {
                RepositoryConnection rc = null;
                try {
                    rc = this.repository.getConnection();
                    rc.begin();
                    for (Entry e : entries) {
                        this.updateEntry(e, rc);
                    }
                    rc.commit();
                }
                catch (RepositoryException re) {
                    try {
                        if (rc != null) {
                            rc.rollback();
                        }
                    }
                    catch (RepositoryException re1) {
                        this.log.error(re1.getMessage());
                    }
                    this.log.error(re.getMessage());
                }
                finally {
                    if (rc != null) {
                        try {
                            rc.close();
                        }
                        catch (RepositoryException re2) {
                            this.log.error(re2.getMessage());
                        }
                    }
                }
            }
        }
        finally {
            this.pm.setAuthenticatedUserURI(currentUser);
        }
    }

    private void updateEntry(Entry e, RepositoryConnection rc) throws RepositoryException {
        if (e == null) {
            return;
        }
        if (GraphType.Context.equals((Object)e.getGraphType()) && EntryType.Local.equals((Object)e.getEntryType())) {
            String contextURI = e.getResourceURI().toString();
            String id = contextURI.substring(contextURI.lastIndexOf("/") + 1);
            Context context = this.rm.getContextManager().getContext(id);
            if (context != null) {
                Set entries = context.getEntries();
                for (URI entryURI : entries) {
                    if (entryURI == null) continue;
                    try {
                        this.updateEntry(this.rm.getContextManager().getEntry(entryURI), rc);
                    }
                    catch (AuthorizationException ae) {}
                }
            }
        } else {
            this.log.debug("Processing entry: " + String.valueOf(e.getEntryURI()));
            this.removeEntry(e, rc);
            this.addEntry(e, rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntries(Set<Entry> entries) {
        URI currentUser = this.pm.getAuthenticatedUserURI();
        try {
            this.pm.setAuthenticatedUserURI(this.pm.getGuestUser().getURI());
            Repository repository = this.repository;
            synchronized (repository) {
                RepositoryConnection rc = null;
                try {
                    rc = this.repository.getConnection();
                    rc.begin();
                    for (Entry e : entries) {
                        this.removeEntry(e, rc);
                    }
                    rc.commit();
                }
                catch (RepositoryException re) {
                    try {
                        rc.rollback();
                    }
                    catch (RepositoryException re1) {
                        this.log.error(re1.getMessage());
                    }
                    this.log.error(re.getMessage());
                }
                finally {
                    if (rc != null) {
                        try {
                            rc.close();
                        }
                        catch (RepositoryException re2) {
                            this.log.error(re2.getMessage());
                        }
                    }
                }
            }
        }
        finally {
            this.pm.setAuthenticatedUserURI(currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntry(Entry e, RepositoryConnection rc) throws RepositoryException {
        PrincipalManager pm = e.getRepositoryManager().getPrincipalManager();
        URI currentUser = pm.getAuthenticatedUserURI();
        try {
            pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
            ValueFactory vf = this.repository.getValueFactory();
            IRI contextURI = vf.createIRI(e.getContext().getURI().toString());
            IRI entryNG = vf.createIRI(e.getEntryURI().toString());
            IRI mdNG = vf.createIRI(e.getLocalMetadataURI().toString());
            IRI resNG = vf.createIRI(e.getResourceURI().toString());
            IRI extMdNG = null;
            if (e.getExternalMetadataURI() != null) {
                extMdNG = vf.createIRI(e.getCachedExternalMetadataURI().toString());
            }
            if (extMdNG != null) {
                rc.remove(rc.getStatements((Resource)null, (IRI)null, (Value)null, false, new Resource[]{entryNG, mdNG, extMdNG, resNG}), new Resource[]{contextURI, entryNG, mdNG, extMdNG, resNG});
            } else {
                rc.remove(rc.getStatements((Resource)null, (IRI)null, (Value)null, false, new Resource[]{entryNG, mdNG, extMdNG, resNG}), new Resource[]{contextURI, entryNG, mdNG, resNG});
            }
        }
        finally {
            pm.setAuthenticatedUserURI(currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildRepository() {
        Repository repository = this.repository;
        synchronized (repository) {
            if (this.rebuilding) {
                this.log.warn("The public repository is already being rebuilt: ignoring additional rebuilding requests");
                return;
            }
            this.rebuilding = true;
        }
        this.log.info("Rebuilding public repository");
        repository = this.repository;
        synchronized (repository) {
            RepositoryConnection rc = null;
            try {
                rc = this.repository.getConnection();
                Date before = new Date();
                rc.begin();
                rc.clear(new Resource[0]);
                this.log.info("Clearing public repository took " + (new Date().getTime() - before.getTime()) + " ms");
                ContextManager cm = this.rm.getContextManager();
                Set contexts = cm.getEntries();
                for (URI contextURI : contexts) {
                    String id = contextURI.toString().substring(contextURI.toString().lastIndexOf("/") + 1);
                    Context context = cm.getContext(id);
                    if (context == null) continue;
                    this.log.info("Adding context " + String.valueOf(contextURI) + " to public repository");
                    before = new Date();
                    Set entries = context.getEntries();
                    this.log.info("Fetching entries took " + (new Date().getTime() - before.getTime()) + " ms");
                    before = new Date();
                    Date timeTracker = new Date();
                    long publicEntryCount = 0L;
                    long processedCount = 0L;
                    for (URI entryURI : entries) {
                        if (entryURI == null) continue;
                        if (new Date().getTime() - timeTracker.getTime() > 60000L && ++processedCount > 0L) {
                            this.log.debug("Average time per entry after " + (new Date().getTime() - before.getTime()) + " ms: " + (new Date().getTime() - before.getTime()) / processedCount + " ms");
                            timeTracker = new Date();
                        }
                        try {
                            Entry entry = cm.getEntry(entryURI);
                            if (entry == null) continue;
                            this.addEntry(entry, rc);
                            ++publicEntryCount;
                        }
                        catch (AuthorizationException ae) {}
                    }
                    this.log.info("Added " + publicEntryCount + " entries to public repository");
                    this.log.info("Total time for context: " + (new Date().getTime() - before.getTime()) + " ms");
                    if (entries.size() > 0) {
                        this.log.debug("Total average time per entry: " + (new Date().getTime() - before.getTime()) / (long)entries.size() + " ms");
                    }
                    this.log.info("Done processing context " + String.valueOf(contextURI));
                }
                rc.commit();
            }
            catch (RepositoryException re) {
                try {
                    rc.rollback();
                }
                catch (RepositoryException re1) {
                    this.log.error(re1.getMessage());
                }
                this.log.error(re.getMessage());
            }
            finally {
                try {
                    rc.close();
                }
                catch (RepositoryException re) {
                    this.log.error(re.getMessage());
                }
                this.log.info("Rebuild of public repository complete");
                this.log.info("Number of triples in public repository: " + this.getTripleCount());
                this.rebuilding = false;
            }
        }
    }

    private boolean isAdministrative(Entry e) {
        GraphType gt = e.getGraphType();
        return !GraphType.Graph.equals((Object)gt) && !GraphType.String.equals((Object)gt) && !GraphType.None.equals((Object)gt) && !GraphType.List.equals((Object)gt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTripleCount() {
        long amountTriples = 0L;
        RepositoryConnection rc = null;
        try {
            rc = this.repository.getConnection();
            amountTriples = rc.size(new Resource[0]);
        }
        catch (RepositoryException re) {
            this.log.error(re.getMessage());
        }
        finally {
            if (rc != null) {
                try {
                    rc.close();
                }
                catch (RepositoryException e) {
                    this.log.error(e.getMessage());
                }
            }
        }
        return amountTriples;
    }

    public void shutdown() {
        if (this.entrySubmitter != null) {
            this.entrySubmitter.interrupt();
        }
        try {
            this.repository.shutDown();
        }
        catch (RepositoryException e) {
            this.log.error("Error when shutting down public repository: " + e.getMessage());
        }
    }

    public class EntrySubmitter
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!EntrySubmitter.interrupted()) {
                PublicRepository.this.postQueue.cleanUp();
                if (PublicRepository.this.postQueue.estimatedSize() > 0L || !PublicRepository.this.deleteQueue.isEmpty()) {
                    int batchCount;
                    Queue<Entry> queue;
                    if (!PublicRepository.this.deleteQueue.isEmpty()) {
                        HashSet<Entry> entriesToRemove = new HashSet<Entry>();
                        queue = PublicRepository.this.deleteQueue;
                        synchronized (queue) {
                            Entry e;
                            for (batchCount = 0; batchCount < 1000 && (e = PublicRepository.this.deleteQueue.poll()) != null; ++batchCount) {
                                entriesToRemove.add(e);
                            }
                        }
                        if (batchCount > 0) {
                            PublicRepository.this.log.info("Removing " + batchCount + " entries from Public Repository, " + PublicRepository.this.deleteQueue.size() + " entries remaining in removal queue");
                            PublicRepository.this.removeEntries(entriesToRemove);
                        }
                    }
                    if (PublicRepository.this.postQueue.estimatedSize() <= 0L) continue;
                    HashSet<Entry> entriesToUpdate = new HashSet<Entry>();
                    queue = PublicRepository.this.postQueue;
                    synchronized (queue) {
                        ConcurrentMap postQueueMap = PublicRepository.this.postQueue.asMap();
                        Iterator it = postQueueMap.keySet().iterator();
                        while (batchCount < 1000 && it.hasNext()) {
                            URI key = (URI)it.next();
                            Entry entry = (Entry)postQueueMap.get(key);
                            postQueueMap.remove(key, entry);
                            if (entry == null) {
                                PublicRepository.this.log.warn("Value for key " + String.valueOf(key) + " is null in Public Repository submit queue");
                            }
                            entriesToUpdate.add(entry);
                            ++batchCount;
                        }
                    }
                    PublicRepository.this.postQueue.cleanUp();
                    PublicRepository.this.log.info("Sending " + entriesToUpdate.size() + " entries for update in Public Repository, " + PublicRepository.this.postQueue.estimatedSize() + " entries remaining in post queue");
                    PublicRepository.this.updateEntries(entriesToUpdate);
                    continue;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    PublicRepository.this.log.info("Public Repository submitter got interrupted, shutting down submitter thread");
                    return;
                }
            }
        }
    }
}

