/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.util.Collection;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.entrystore.Entry;
import org.entrystore.PrincipalManager;
import org.entrystore.impl.EntryImpl;
import org.entrystore.impl.ResourceImpl;
import org.entrystore.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFResource
extends ResourceImpl {
    Logger log = LoggerFactory.getLogger(RDFResource.class);

    protected RDFResource(EntryImpl entry, String resourceURI) {
        super(entry, resourceURI);
    }

    public RDFResource(EntryImpl entry, IRI resourceURI) {
        super(entry, resourceURI);
    }

    public Model getGraph() {
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.ReadResource);
        RepositoryConnection rc = null;
        try {
            rc = this.entry.repository.getConnection();
            Model model = (Model)Iterations.addAll((CloseableIteration)rc.getStatements(null, null, null, false, new Resource[]{this.resourceURI}), (Collection)new LinkedHashModel());
            return model;
        }
        catch (org.eclipse.rdf4j.repository.RepositoryException e) {
            this.log.error(e.getMessage());
            throw new RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
        finally {
            try {
                rc.close();
            }
            catch (org.eclipse.rdf4j.repository.RepositoryException e) {
                this.log.error(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGraph(Model graph) {
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        try {
            Repository repository = this.entry.repository;
            synchronized (repository) {
                rc.setAutoCommit(false);
                try (RepositoryConnection rc = this.entry.repository.getConnection();){
                    rc.clear(new Resource[]{this.resourceURI});
                    rc.add((Iterable)graph, new Resource[]{this.resourceURI});
                    this.entry.updateModifiedDateSynchronized(rc, this.entry.repository.getValueFactory());
                    rc.commit();
                }
            }
        }
        catch (org.eclipse.rdf4j.repository.RepositoryException e) {
            this.log.error(e.getMessage());
            throw new RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(RepositoryConnection rc) throws Exception {
        Repository repository = this.entry.repository;
        synchronized (repository) {
            rc.clear(new Resource[]{this.resourceURI});
        }
    }
}

